/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import com.mojang.math.Vector3f;
import iskallia.vault.block.LandmineBlock;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.entity.ILandmineIgnore;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.skill.ability.effect.EarthquakeLandmineAbility;
import iskallia.vault.util.ServerScheduler;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class LandmineBlockEntity
extends BlockEntity {
    private UUID ownerId;
    private String ownerName;
    private EarthquakeLandmineAbility ability;
    private int durationTicks;
    private int ticksAlive = 0;
    private boolean hasTriggered = false;
    private boolean isChainReaction = false;

    public LandmineBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.LANDMINE_TILE_ENTITY, pos, state);
    }

    public void initialize(ServerPlayer owner, EarthquakeLandmineAbility ability, int durationTicks) {
        this.ownerId = owner.m_142081_();
        this.ownerName = owner.m_5446_().getString();
        this.ability = ability;
        this.durationTicks = durationTicks;
        this.ticksAlive = 0;
        this.hasTriggered = false;
        this.m_6596_();
    }

    public boolean isOwner(Player player) {
        return this.ownerId != null && this.ownerId.equals(player.m_142081_());
    }

    public static void tick(Level level, BlockPos pos, BlockState state, LandmineBlockEntity landmine) {
        if (level.f_46443_ || landmine.hasTriggered) {
            return;
        }
        ++landmine.ticksAlive;
        if (landmine.ticksAlive >= landmine.durationTicks) {
            landmine.expire();
            return;
        }
        if (landmine.ticksAlive % 60 == 0) {
            landmine.showIdleParticles();
        }
        if (landmine.durationTicks - landmine.ticksAlive < 200 && landmine.ticksAlive % 20 == 0) {
            landmine.showWarningParticles();
        }
    }

    public void trigger(LivingEntity entity) {
        if (this.hasTriggered || this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (!this.shouldTriggerFor(entity)) {
            return;
        }
        this.hasTriggered = true;
        this.m_6596_();
        this.showTriggerWarningParticles();
        this.f_58857_.m_6263_(null, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, SoundEvents.f_12210_, SoundSource.BLOCKS, 1.0f, 2.0f);
        ServerScheduler.INSTANCE.schedule(10, this::explode);
    }

    public void triggerChainReaction() {
        if (this.hasTriggered || this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        this.isChainReaction = true;
        this.hasTriggered = true;
        this.m_6596_();
        ServerScheduler.INSTANCE.schedule(5 + this.f_58857_.f_46441_.nextInt(10), () -> this.explode());
    }

    private void explode() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_ || this.ability == null) {
            return;
        }
        ServerPlayer owner = this.getOwnerPlayer();
        if (owner == null) {
            this.f_58857_.m_7471_(this.f_58858_, false);
            return;
        }
        Vec3 explosionPos = new Vec3((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5);
        this.ability.triggerExplosion(owner, explosionPos, false);
        this.triggerNearbyLandmines(explosionPos, this.ability.getRadius((Entity)owner));
        this.f_58857_.m_7471_(this.f_58858_, false);
    }

    private void triggerNearbyLandmines(Vec3 explosionPos, float radius) {
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        int radiusInt = (int)Math.ceil(radius);
        BlockPos center = new BlockPos(explosionPos);
        for (int x = -radiusInt; x <= radiusInt; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -radiusInt; z <= radiusInt; ++z) {
                    BlockEntity blockEntity;
                    BlockState state;
                    BlockPos checkPos = center.m_142082_(x, y, z);
                    double distance = Math.sqrt(checkPos.m_123331_((Vec3i)center));
                    if (!(distance <= (double)radius) || !((state = this.f_58857_.m_8055_(checkPos)).m_60734_() instanceof LandmineBlock) || !((blockEntity = this.f_58857_.m_7702_(checkPos)) instanceof LandmineBlockEntity)) continue;
                    LandmineBlockEntity otherLandmine = (LandmineBlockEntity)blockEntity;
                    if (otherLandmine.hasTriggered) continue;
                    ServerScheduler.INSTANCE.schedule(5 + this.f_58857_.f_46441_.nextInt(15), otherLandmine::triggerChainReaction);
                }
            }
        }
    }

    public void expire() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.5f, 0.5f, 0.5f), 1.0f), (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, 10, 0.3, 0.1, 0.3, 0.02);
        }
        this.f_58857_.m_6263_(null, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, SoundEvents.f_12448_, SoundSource.BLOCKS, 0.5f, 1.2f);
        this.f_58857_.m_7471_(this.f_58858_, false);
    }

    private boolean shouldTriggerFor(LivingEntity entity) {
        Player player;
        if (this.f_58857_ == null) {
            return false;
        }
        if (entity instanceof Player && this.isOwner(player = (Player)entity)) {
            return false;
        }
        if (entity instanceof Player) {
            return VaultUtils.getVault(this.f_58857_).map(VaultUtils::isPvPVault).orElse(false);
        }
        if (entity instanceof ILandmineIgnore) {
            ILandmineIgnore l = (ILandmineIgnore)entity;
            return !l.isLandmineIgnored();
        }
        return true;
    }

    private void showIdleParticles() {
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        serverLevel.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.8f, 0.2f, 0.2f), 0.5f), (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.3, (double)this.f_58858_.m_123343_() + 0.5, 1, 0.1, 0.1, 0.1, 0.0);
    }

    private void showWarningParticles() {
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        serverLevel.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.0f, 0.0f), 0.8f), (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.3, (double)this.f_58858_.m_123343_() + 0.5, 3, 0.2, 0.1, 0.2, 0.05);
    }

    private void showTriggerWarningParticles() {
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        for (int i = 0; i < 15; ++i) {
            double offsetX = (serverLevel.f_46441_.nextDouble() - 0.5) * 1.5;
            double offsetZ = (serverLevel.f_46441_.nextDouble() - 0.5) * 1.5;
            serverLevel.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.0f, 0.0f), 1.2f), (double)this.f_58858_.m_123341_() + 0.5 + offsetX, (double)this.f_58858_.m_123342_() + 0.4, (double)this.f_58858_.m_123343_() + 0.5 + offsetZ, 1, 0.0, 0.2, 0.0, 0.1);
        }
    }

    @Nullable
    private ServerPlayer getOwnerPlayer() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.ownerId != null) {
                return serverLevel.m_142572_().m_6846_().m_11259_(this.ownerId);
            }
        }
        return null;
    }

    public void onRemoved() {
        this.hasTriggered = true;
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        if (this.ownerId != null) {
            nbt.m_128362_("ownerId", this.ownerId);
        }
        if (this.ownerName != null) {
            nbt.m_128359_("ownerName", this.ownerName);
        }
        nbt.m_128405_("durationTicks", this.durationTicks);
        nbt.m_128405_("ticksAlive", this.ticksAlive);
        nbt.m_128379_("hasTriggered", this.hasTriggered);
        nbt.m_128379_("isChainReaction", this.isChainReaction);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128403_("ownerId")) {
            this.ownerId = nbt.m_128342_("ownerId");
        }
        if (nbt.m_128441_("ownerName")) {
            this.ownerName = nbt.m_128461_("ownerName");
        }
        this.durationTicks = nbt.m_128451_("durationTicks");
        this.ticksAlive = nbt.m_128451_("ticksAlive");
        this.hasTriggered = nbt.m_128471_("hasTriggered");
        this.isChainReaction = nbt.m_128471_("isChainReaction");
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        if (this.ownerName != null) {
            nbt.m_128359_("ownerName", this.ownerName);
        }
        nbt.m_128379_("hasTriggered", this.hasTriggered);
        return nbt;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

