/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.init.ModBlocks;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LodestoneTileEntity
extends BlockEntity {
    protected boolean consumed = false;

    public LodestoneTileEntity(BlockPos pos, BlockState blockState) {
        super(ModBlocks.LODESTONE_TILE_ENTITY, pos, blockState);
    }

    public boolean isConsumed() {
        return this.consumed;
    }

    public void setConsumed(boolean consumed) {
        this.consumed = consumed;
        this.sendUpdates();
    }

    public void sendUpdates() {
        if (this.f_58857_ == null) {
            return;
        }
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        this.m_6596_();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, LodestoneTileEntity tile) {
        if (level.m_5776_()) {
            tile.playEffects();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playEffects() {
        if (this.m_58904_() == null || this.consumed) {
            return;
        }
        BlockPos pos = this.m_58899_();
        if (this.isConsumed()) {
            return;
        }
        if (this.m_58904_().m_46467_() % 2L < 1L) {
            return;
        }
        ParticleEngine mgr = Minecraft.m_91087_().f_91061_;
        float ringSize = 3.0f;
        int i = 0;
        while ((float)i < ringSize) {
            float z;
            float y;
            float angle = (float)(i + 1) * (float)Math.PI / ringSize + (float)this.m_58904_().m_46467_() / 7.0f;
            float radius = 1.0f;
            float x = (float)((double)((float)pos.m_123341_() + 0.5f) + (double)radius * Math.cos(angle));
            Particle fwParticle = mgr.m_107370_((ParticleOptions)ParticleTypes.f_123815_, (double)x, (double)(y = (float)((double)((float)pos.m_123342_() + 0.2f * (float)(3 * i + 1)) + Math.sin(angle) * (double)0.4f)), (double)(z = (float)((double)((float)pos.m_123343_() + 0.5f) + (double)radius * Math.sin(angle))), 0.0, 0.0, 0.0);
            if (fwParticle != null) {
                fwParticle.m_107253_(0.76862746f, 0.13333334f, 0.9254902f);
                fwParticle.m_172260_(0.0, 0.0, 0.0);
                fwParticle.m_107257_(10);
            }
            ++i;
        }
    }

    protected void m_183515_(@Nonnull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128379_("Consumed", this.consumed);
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.consumed = nbt.m_128471_("Consumed");
    }

    @Nonnull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

