/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.block.entity.SkinnableTileEntity;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class LootStatueTileEntity
extends SkinnableTileEntity {
    private int currentTick = 0;
    private ItemStack lootItem = ItemStack.f_41583_;
    private int chipCount = 0;
    private ItemStack standItem;
    private BlockState stand = Blocks.f_50405_.m_49966_();
    private int wobbleTime = 0;

    public LootStatueTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.LOOT_STATUE_TILE_ENTITY, pos, state);
    }

    public LootStatueTileEntity(BlockEntityType type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public BlockState getStand() {
        return this.stand;
    }

    public int getCurrentTick() {
        return this.currentTick;
    }

    @Nonnull
    public ItemStack getLootItem() {
        return this.lootItem;
    }

    public void setLootItem(@Nonnull ItemStack stack) {
        this.lootItem = stack;
        this.m_6596_();
        this.sendUpdates();
    }

    @Override
    protected void updateSkin() {
    }

    public boolean addChip() {
        if (this.chipCount >= ModConfigs.STATUE_LOOT.getMaxAccelerationChips()) {
            return false;
        }
        ++this.chipCount;
        this.sendUpdates();
        return true;
    }

    public ItemStack removeChip() {
        ItemStack stack = ItemStack.f_41583_;
        if (this.chipCount > 0) {
            --this.chipCount;
            stack = new ItemStack((ItemLike)ModItems.ACCELERATION_CHIP, 1);
            this.sendUpdates();
        }
        return stack;
    }

    public int getChipCount() {
        return this.chipCount;
    }

    public int getWobbleTime() {
        return this.wobbleTime;
    }

    public int getMaxWobble() {
        return 40;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, LootStatueTileEntity tile) {
        if (!level.f_46443_) {
            if (tile.currentTick++ >= tile.getModifiedInterval()) {
                ItemStack stack;
                tile.currentTick = 0;
                if (!tile.lootItem.m_41619_() && tile.poopItem(stack = tile.lootItem.m_41777_(), false)) {
                    tile.m_6596_();
                }
            }
        } else if (tile.wobbleTime > 0) {
            --tile.wobbleTime;
        }
    }

    private int getModifiedInterval() {
        int interval = ModConfigs.STATUE_LOOT.getInterval();
        if (this.getChipCount() == 0) {
            return interval;
        }
        return interval - ModConfigs.STATUE_LOOT.getIntervalDecrease(this.getChipCount());
    }

    private boolean poopItem(ItemStack stack, boolean simulate) {
        assert (this.f_58857_ != null);
        BlockPos down = this.m_58899_().m_7495_();
        BlockEntity tileEntity = this.f_58857_.m_7702_(down);
        if (tileEntity != null) {
            LazyOptional handler = tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP);
            handler.ifPresent(h -> ItemHandlerHelper.insertItemStacked((IItemHandler)h, (ItemStack)stack, (boolean)simulate));
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        return super.getRenderBoundingBox().m_82363_(0.0, 2.0, 0.0);
    }

    public void m_183515_(@NotNull CompoundTag nbt) {
        String nickname = this.skin.getLatestNickname();
        if (nickname != null) {
            nbt.m_128359_("PlayerNickname", nickname);
        }
        if (this.chipCount != 0) {
            nbt.m_128405_("ChipCount", this.chipCount);
        }
        nbt.m_128405_("CurrentTick", this.getCurrentTick());
        nbt.m_128365_("LootItem", (Tag)this.getLootItem().serializeNBT());
        if (this.stand.m_60734_() != Blocks.f_50405_) {
            nbt.m_128365_("Stand", (Tag)NbtUtils.m_129202_((BlockState)this.stand));
        }
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("PlayerNickname")) {
            this.skin.updateSkin(nbt.m_128461_("PlayerNickname"));
        }
        if (nbt.m_128441_("ChipCount")) {
            this.chipCount = nbt.m_128451_("ChipCount");
        }
        this.lootItem = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("LootItem"));
        this.currentTick = nbt.m_128451_("CurrentTick");
        if (nbt.m_128441_("Stand")) {
            this.stand = NbtUtils.m_129241_((CompoundTag)nbt.m_128469_("Stand"));
        }
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void setStand(ItemStack stack, BlockItem blockItem) {
        this.standItem = stack;
        this.stand = blockItem.m_40614_().m_49966_();
        this.sendUpdates();
    }

    public void wobble() {
        this.wobbleTime = this.getMaxWobble();
    }
}

