/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.block.MonolithBlock;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.init.ModBlocks;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class MonolithTileEntity
extends BlockEntity {
    private static final Random rand = new Random();
    private boolean generated;
    private boolean overStacking;
    private Map<ResourceLocation, Integer> modifiers = new HashMap<ResourceLocation, Integer>();

    public MonolithTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.MONOLITH_TILE_ENTITY, pos, state);
    }

    public boolean isGenerated() {
        return this.generated;
    }

    public boolean isOverStacking() {
        return this.overStacking;
    }

    public Map<ResourceLocation, Integer> getModifiers() {
        return this.modifiers;
    }

    public void setGenerated(boolean generated) {
        this.generated = generated;
        this.sendUpdates();
    }

    public void setOverStacking(boolean overStacking) {
        this.overStacking = overStacking;
        this.sendUpdates();
    }

    public void addModifier(VaultModifier<?> modifier) {
        this.modifiers.put(modifier.getId(), this.modifiers.getOrDefault(modifier.getId(), 0) + 1);
        this.sendUpdates();
    }

    public void removeModifiers() {
        this.modifiers.clear();
        this.sendUpdates();
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void sendUpdates() {
        if (this.f_58857_ == null) {
            return;
        }
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        this.m_6596_();
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.generated = nbt.m_128471_("Generated");
        this.overStacking = nbt.m_128471_("OverStacking");
        this.modifiers = new HashMap<ResourceLocation, Integer>();
        CompoundTag modifiersNBT = nbt.m_128469_("Modifiers");
        modifiersNBT.m_128431_().forEach(key -> {
            ResourceLocation id = new ResourceLocation(key);
            int count = modifiersNBT.m_128451_(key);
            this.modifiers.put(id, count);
        });
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128379_("Generated", this.generated);
        nbt.m_128379_("OverStacking", this.overStacking);
        CompoundTag modifiersNBT = new CompoundTag();
        this.modifiers.forEach((id, count) -> modifiersNBT.m_128405_(id.toString(), count.intValue()));
        nbt.m_128365_("Modifiers", (Tag)modifiersNBT);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MonolithTileEntity tile) {
        CommonEvents.MONOLITH_UPDATE.invoke(level, state, pos, tile);
        if (level.m_5776_()) {
            tile.playEffects();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playEffects() {
        if (this.m_58904_() == null) {
            return;
        }
        BlockPos pos = this.m_58899_();
        BlockState state = this.m_58900_();
        if (this.m_58904_().m_46467_() % 1L != 0L) {
            return;
        }
        ParticleEngine mgr = Minecraft.m_91087_().f_91061_;
        if (state.m_61143_(MonolithBlock.STATE) == MonolithBlock.State.LIT) {
            Vec3 offset;
            Random random = this.m_58904_().m_5822_();
            if (random.nextInt(5) == 0) {
                offset = new Vec3(random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1));
                this.m_58904_().m_6493_((ParticleOptions)ParticleTypes.f_123777_, true, (double)pos.m_123341_() + 0.5 + offset.f_82479_, (double)pos.m_123342_() + random.nextDouble() * (double)0.15f + (double)0.55f, (double)pos.m_123343_() + 0.5 + offset.f_82481_, offset.f_82479_ / 120.0, random.nextDouble() * -0.005 + 0.075, offset.f_82481_ / 120.0);
            }
            if (random.nextInt(2) == 0) {
                offset = new Vec3(random.nextDouble() / 9.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, random.nextDouble() / 9.0 * (double)(random.nextBoolean() ? 1 : -1));
                this.m_58904_().m_6493_((ParticleOptions)ParticleTypes.f_123777_, true, (double)pos.m_123341_() + 0.5 + offset.f_82479_, (double)pos.m_123342_() + (double)1.55f + random.nextDouble() * (double)0.15f, (double)pos.m_123343_() + 0.5 + offset.f_82481_, offset.f_82479_ / 120.0, random.nextDouble() * -0.005 + 0.075, offset.f_82481_ / 120.0);
            }
            if (random.nextInt(15) == 0) {
                offset = new Vec3(random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1));
                this.m_58904_().m_6493_((ParticleOptions)ParticleTypes.f_123756_, true, (double)pos.m_123341_() + 0.5 + offset.f_82479_, (double)pos.m_123342_() + random.nextDouble() * (double)0.15f + (double)0.55f, (double)pos.m_123343_() + 0.5 + offset.f_82481_, offset.f_82479_ / 12.0, random.nextDouble() * 0.1 + 0.1, offset.f_82481_ / 12.0);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void spawnIgniteParticles(BlockPos pos) {
        Vec3 offset;
        Random random;
        int i;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        for (i = 0; i < 50; ++i) {
            random = level.m_5822_();
            offset = new Vec3(random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1));
            level.m_6493_((ParticleOptions)ParticleTypes.f_123755_, true, (double)pos.m_123341_() + 0.5 + offset.f_82479_, (double)pos.m_123342_() + random.nextDouble() * (double)0.15f + (double)0.45f, (double)pos.m_123343_() + 0.5 + offset.f_82481_, offset.f_82479_ / 2.0, random.nextDouble() * 0.1 + 0.1, offset.f_82481_ / 2.0);
        }
        for (i = 0; i < 20; ++i) {
            random = level.m_5822_();
            offset = new Vec3(random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1));
            level.m_6493_((ParticleOptions)ParticleTypes.f_123777_, true, (double)pos.m_123341_() + 0.5 + offset.f_82479_, (double)pos.m_123342_() + random.nextDouble() * (double)0.15f + (double)0.45f, (double)pos.m_123343_() + 0.5 + offset.f_82481_, offset.f_82479_ / 2.0, random.nextDouble() * 0.1 + 0.1, offset.f_82481_ / 2.0);
        }
        for (i = 0; i < 20; ++i) {
            random = level.m_5822_();
            offset = new Vec3(random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1));
            level.m_6493_((ParticleOptions)ParticleTypes.f_123756_, true, (double)pos.m_123341_() + 0.5 + offset.f_82479_, (double)pos.m_123342_() + random.nextDouble() * (double)0.15f + (double)0.45f, (double)pos.m_123343_() + 0.5 + offset.f_82481_, offset.f_82479_ / 2.0, random.nextDouble() * 0.1 + 0.1, offset.f_82481_ / 2.0);
        }
        for (i = 0; i < 20; ++i) {
            random = level.m_5822_();
            offset = new Vec3(random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1));
            level.m_6493_((ParticleOptions)ParticleTypes.f_123755_, true, (double)pos.m_123341_() + 0.5 + offset.f_82479_, (double)pos.m_7494_().m_123342_() + random.nextDouble() * (double)0.15f, (double)pos.m_123343_() + 0.5 + offset.f_82481_, offset.f_82479_ / 20.0, random.nextDouble() * 0.2 + 0.2, offset.f_82481_ / 20.0);
        }
        for (i = 0; i < 20; ++i) {
            random = level.m_5822_();
            offset = new Vec3(random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1));
            level.m_6493_((ParticleOptions)ParticleTypes.f_123777_, true, (double)pos.m_123341_() + 0.5 + offset.f_82479_, (double)pos.m_7494_().m_123342_() + random.nextDouble() * (double)0.15f, (double)pos.m_123343_() + 0.5 + offset.f_82481_, offset.f_82479_ / 20.0, random.nextDouble() * 0.2 + 0.1, offset.f_82481_ / 20.0);
        }
    }
}

