/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.core.vault.pandora.PandoraEffect;
import iskallia.vault.init.ModBlocks;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PandoraBoxTileEntity
extends BlockEntity {
    public PandoraEffect.Config<?> config;
    public int tickCount = 0;
    private boolean opened = false;

    public PandoraBoxTileEntity(BlockPos pos, BlockState blockState) {
        super(ModBlocks.PANDORA_BOX_TILE_ENTITY, pos, blockState);
    }

    public boolean isOpened() {
        return this.opened;
    }

    public void setOpened(boolean opened) {
        this.opened = opened;
        this.sendUpdates();
    }

    public void sendUpdates() {
        if (this.f_58857_ == null) {
            return;
        }
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        this.m_6596_();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, PandoraBoxTileEntity tile) {
        ++tile.tickCount;
        if (level.m_5776_()) {
            tile.playEffects();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playEffects() {
        if (this.m_58904_() == null || this.opened) {
            return;
        }
        BlockPos pos = this.m_58899_();
        Random random = new Random();
        if (random.nextFloat() < 0.5f) {
            ParticleEngine mgr = Minecraft.m_91087_().f_91061_;
            double offsetX = (random.nextDouble() - 1.0) * 1.0 + 0.5;
            double offsetY = random.nextDouble() * 1.5;
            double offsetZ = (random.nextDouble() - 1.0) * 1.0 + 0.5;
            mgr.m_107370_((ParticleOptions)ParticleTypes.f_123809_, (double)pos.m_123341_() + 0.5 + offsetX, (double)pos.m_123342_() + offsetY, (double)pos.m_123343_() + 0.5 + offsetZ, (random.nextDouble() - 0.5) * 0.1, random.nextDouble() * 0.05, (random.nextDouble() - 0.5) * 0.1);
        }
    }

    protected void m_183515_(@Nonnull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128379_("Opened", this.opened);
        if (this.config != null) {
            nbt.m_128365_("Config", (Tag)this.config.serializeNBT());
        }
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.opened = nbt.m_128471_("Opened");
        if (nbt.m_128425_("Config", 10)) {
            this.config = PandoraEffect.Config.fromNBT(nbt.m_128469_("Config"));
        }
    }

    @Nonnull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

