/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.block.entity.base.FilteredInputInventoryTileEntity;
import iskallia.vault.block.entity.base.InventoryRetainerTileEntity;
import iskallia.vault.container.PersonalVaultContainer;
import iskallia.vault.container.oversized.OverSizedInventory;
import iskallia.vault.container.oversized.OverSizedItemStack;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModItems;
import iskallia.vault.integration.IntegrationRefinedStorage;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersonalVaultTileEntity
extends BlockEntity
implements MenuProvider,
InventoryRetainerTileEntity,
FilteredInputInventoryTileEntity {
    private final OverSizedInventory craftingInventory;
    private final ResultContainer output = new ResultContainer(){

        public void m_6596_() {
            super.m_6596_();
            PersonalVaultTileEntity.this.m_6596_();
        }
    };

    public PersonalVaultTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.PERSONAL_VAULT_ENTITY, pos, state);
        this.craftingInventory = new OverSizedInventory.FilteredInsert(2, this, this::canInsertRecipeInput);
    }

    public Component m_5446_() {
        return new TextComponent("Personal Vault | Builder");
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return new PersonalVaultContainer(id, player, this.m_58899_());
    }

    public OverSizedInventory getInventory() {
        return this.craftingInventory;
    }

    protected boolean canInsertRecipeInput(int slot, @Nonnull ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        return stack.m_150930_((Item)ModBlocks.VAULT_GOLD) || stack.m_150930_((Item)ModItems.ECHO_GEM);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (IntegrationRefinedStorage.shouldPreventImportingCapability(this.m_58904_(), this.m_58899_(), side)) {
            return super.getCapability(cap, side);
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.getInventoryCapability(side);
        }
        return super.getCapability(cap, side);
    }

    protected <T> LazyOptional<T> getInventoryCapability(Direction side) {
        return this.getFilteredInputCapability(side, new Container[]{this.craftingInventory});
    }

    public ResultContainer getResultContainer() {
        return this.output;
    }

    @Override
    public boolean isInventorySideAccessible(@Nullable Direction side) {
        return true;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.getInventory().load(tag);
        this.getResultContainer().m_6836_(0, ItemStack.m_41712_((CompoundTag)tag.m_128469_("result")));
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        this.getInventory().save(pTag);
        pTag.m_128365_("result", (Tag)this.getResultContainer().m_8020_(0).serializeNBT());
    }

    public static InventoryRetainerTileEntity.ContentDisplayInfo addInventoryTooltip(ItemStack stack, CompoundTag tag) {
        return InventoryRetainerTileEntity.displayContentsOverSized(5, stacks -> {
            ItemStack result = ItemStack.m_41712_((CompoundTag)tag.m_128469_("result"));
            if (!result.m_41619_()) {
                stacks.add(OverSizedItemStack.of(result));
            }
            stacks.addAll(OverSizedInventory.loadContents("inventory", tag));
        });
    }

    @Override
    public void storeInventoryContents(CompoundTag tag) {
        this.getInventory().save("inventory", tag);
        tag.m_128365_("result", (Tag)this.getResultContainer().m_8020_(0).m_41777_().serializeNBT());
    }

    @Override
    public void loadInventoryContents(CompoundTag tag) {
        this.getInventory().load("inventory", tag);
        this.getResultContainer().m_6836_(0, ItemStack.m_41712_((CompoundTag)tag.m_128469_("result")));
    }

    @Override
    public void clearInventoryContents() {
        this.getInventory().m_6211_();
        this.getResultContainer().m_6211_();
    }

    public boolean craftingInventoryStillValid(Player player) {
        if (this.m_58904_() == null || this.m_58904_().m_7702_(this.m_58899_()) != this) {
            return false;
        }
        return this.getInventory().m_6542_(player);
    }
}

