/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.core.vault.pylon.PylonBuff;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModParticles;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PylonTileEntity
extends BlockEntity {
    protected boolean consumed = false;
    public PylonBuff.Config<?> config;
    public int tickCount = 0;

    public PylonTileEntity(BlockPos pos, BlockState blockState) {
        super(ModBlocks.PYLON_TILE_ENTITY, pos, blockState);
    }

    public boolean isConsumed() {
        return this.consumed;
    }

    public void setConsumed(boolean consumed) {
        this.consumed = consumed;
        this.sendUpdates();
    }

    public void sendUpdates() {
        if (this.f_58857_ == null) {
            return;
        }
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        this.m_6596_();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, PylonTileEntity tile) {
        ++tile.tickCount;
        if (level.m_5776_()) {
            tile.playEffects();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playEffects() {
        boolean isUber;
        if (this.m_58904_() == null || this.consumed) {
            return;
        }
        BlockPos pos = this.m_58899_();
        Random random = new Random();
        if (this.isConsumed()) {
            return;
        }
        if (this.m_58904_().m_46467_() % 2L < 1L) {
            return;
        }
        ParticleEngine mgr = Minecraft.m_91087_().f_91061_;
        int color = this.config == null ? -1 : this.config.getColor();
        int uberColor = this.config == null ? -1 : this.config.getUberColor();
        int r = color >>> 16 & 0xFF;
        int g = color >>> 8 & 0xFF;
        int b = color & 0xFF;
        int r2 = uberColor >>> 16 & 0xFF;
        int g2 = uberColor >>> 8 & 0xFF;
        int b2 = uberColor & 0xFF;
        float ringSize = 3.0f;
        boolean bl = isUber = this.config != null && this.config.getUber();
        if (!isUber) {
            int i = 0;
            while ((float)i < ringSize) {
                float z;
                float y;
                float angle = (float)(i + 1) * (float)Math.PI / ringSize + (float)this.tickCount / 7.0f;
                float radius = 1.0f;
                float x = (float)((double)((float)pos.m_123341_() + 0.5f) + (double)radius * Math.cos(angle));
                Particle fwParticle = mgr.m_107370_((ParticleOptions)ParticleTypes.f_123815_, (double)x, (double)(y = (float)((double)((float)pos.m_123342_() + 0.2f * (float)(3 * i + 1)) + Math.sin(angle) * (double)0.4f)), (double)(z = (float)((double)((float)pos.m_123343_() + 0.5f) + (double)radius * Math.sin(angle))), 0.0, 0.0, 0.0);
                if (fwParticle != null) {
                    fwParticle.m_107253_((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
                    fwParticle.m_172260_(0.0, 0.0, 0.0);
                    fwParticle.m_107257_(10);
                }
                ++i;
            }
        } else {
            for (int i = 0; i < 2; ++i) {
                float z;
                float y;
                float radius = random.nextFloat() * 0.75f + 0.35f;
                float rotation = random.nextFloat() * 360.0f;
                Vec3 offset = new Vec3((double)radius * Math.cos(rotation), 0.0, (double)radius * Math.sin(rotation));
                float f = -0.5f + random.nextFloat() + (float)offset.m_7096_();
                float f1 = -0.5f + random.nextFloat() + (float)offset.m_7098_();
                float f2 = -0.5f + random.nextFloat() + (float)offset.m_7094_();
                Particle fwParticle = mgr.m_107370_((ParticleOptions)ModParticles.UBER_PYLON.get(), (double)((float)pos.m_123341_() + 0.5f), (double)pos.m_123342_(), (double)((float)pos.m_123343_() + 0.5f), (double)f, (double)f1, (double)f2);
                if (fwParticle != null) {
                    fwParticle.m_107253_((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
                    if (random.nextInt(3) == 0) {
                        fwParticle.m_107253_((float)r2 / 255.0f, (float)g2 / 255.0f, (float)b2 / 255.0f);
                    }
                }
                float angle = (float)Math.PI * (float)i + (float)this.tickCount / 7.0f;
                radius = 2.0f;
                float x = (float)((double)((float)pos.m_123341_() + 0.5f) + (double)radius * Math.cos(angle));
                fwParticle = mgr.m_107370_((ParticleOptions)ParticleTypes.f_123815_, (double)x, (double)(y = (float)pos.m_123342_() + 0.5f), (double)(z = (float)((double)((float)pos.m_123343_() + 0.5f) + (double)radius * Math.sin(angle))), 0.0, 0.0, 0.0);
                if (fwParticle != null) {
                    fwParticle.m_107253_((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
                    fwParticle.m_172260_(0.0, 0.0, 0.0);
                    fwParticle.m_107257_(10);
                }
                if ((fwParticle = mgr.m_107370_((ParticleOptions)ModParticles.UBER_PYLON_FOUNTAIN.get(), (double)((float)pos.m_123341_() + 0.5f + Mth.m_144924_((Random)random, (float)-0.175f, (float)0.175f)), (double)((float)pos.m_123342_() + 0.8f), (double)((float)pos.m_123343_() + 0.5f + Mth.m_144924_((Random)random, (float)-0.175f, (float)0.175f)), 40.0, 0.0625, (double)0.2625f)) != null) {
                    fwParticle.m_107253_((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
                }
                if ((fwParticle = mgr.m_107370_((ParticleOptions)ModParticles.UBER_PYLON_FOUNTAIN.get(), (double)((float)pos.m_123341_() + 0.5f + Mth.m_144924_((Random)random, (float)-0.175f, (float)0.175f)), (double)((float)pos.m_123342_() + 0.8f), (double)((float)pos.m_123343_() + 0.5f + Mth.m_144924_((Random)random, (float)-0.175f, (float)0.175f)), 40.0, 0.0625, (double)0.2625f)) != null) {
                    fwParticle.m_107253_((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
                }
                if ((fwParticle = mgr.m_107370_((ParticleOptions)ModParticles.UBER_PYLON_FOUNTAIN.get(), (double)((float)pos.m_123341_() + 0.5f + Mth.m_144924_((Random)random, (float)-0.175f, (float)0.175f)), (double)((float)pos.m_123342_() + 0.8f), (double)((float)pos.m_123343_() + 0.5f + Mth.m_144924_((Random)random, (float)-0.175f, (float)0.175f)), 40.0, 0.0625, (double)0.2625f)) == null) continue;
                fwParticle.m_107253_((float)r2 / 255.0f, (float)g2 / 255.0f, (float)b2 / 255.0f);
            }
        }
    }

    protected void m_183515_(@Nonnull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128379_("Consumed", this.consumed);
        if (this.config != null) {
            nbt.m_128365_("Config", (Tag)this.config.serializeNBT());
        }
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.consumed = nbt.m_128471_("Consumed");
        if (nbt.m_128425_("Config", 10)) {
            this.config = PylonBuff.Config.fromNBT(nbt.m_128469_("Config"));
        }
    }

    @Nonnull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

