/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.block.RoyaleCrateBlock;
import iskallia.vault.container.oversized.OverSizedItemStack;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.util.nbt.NBTHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RoyaleCrateBlockEntity
extends BlockEntity {
    private final ItemStackHandler itemHandler = this.createHandler();
    private final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);
    private final List<OverSizedItemStack> items = new ArrayList<OverSizedItemStack>();

    public RoyaleCrateBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.ROYALE_CRATE_TILE_ENTITY, pos, state);
    }

    public List<OverSizedItemStack> getItems() {
        return this.items;
    }

    public void sendUpdates() {
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        this.m_6596_();
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        NBTHelper.writeCollection(pTag, "items", this.items, CompoundTag.class, OverSizedItemStack::serialize);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        if (pTag.m_128441_("items")) {
            NBTHelper.readCollection(pTag, "items", CompoundTag.class, OverSizedItemStack::deserialize, this.items);
        }
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(5000){

            protected void onContentsChanged(int slot) {
                RoyaleCrateBlockEntity.this.sendUpdates();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                if (!stack.m_41720_().m_142095_()) {
                    return false;
                }
                return !(Block.m_49814_((Item)stack.m_41720_()) instanceof ShulkerBoxBlock) && !(Block.m_49814_((Item)stack.m_41720_()) instanceof RoyaleCrateBlock);
            }
        };
    }

    @Nonnull
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }
}

