/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.config.RoyalePresetConfig;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.entity.entity.TommyEntity;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModEntities;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class RoyaleDrafterControllerTileEntity
extends BlockEntity {
    private int monitoredEntityId = -1;
    private Map<UUID, Map<String, Map<String, Integer>>> presets = new HashMap<UUID, Map<String, Map<String, Integer>>>();
    private Map<UUID, List<ResourceLocation>> blueTrinketPresets = new HashMap<UUID, List<ResourceLocation>>();
    private Map<UUID, List<ResourceLocation>> redTrinketPresets = new HashMap<UUID, List<ResourceLocation>>();
    private Map<UUID, Integer> tab = new HashMap<UUID, Integer>();
    private Map<UUID, List<List<ItemStack>>> loot = new HashMap<UUID, List<List<ItemStack>>>();

    public RoyaleDrafterControllerTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.TOMMY_CONTROLLER_TILE_ENTITY, pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, RoyaleDrafterControllerTileEntity tile) {
        Entity monitoredEntity;
        if (level.m_5776_()) {
            return;
        }
        if (VaultUtils.isVaultLevel(level)) {
            VaultUtils.getVault(level).ifPresent(vault -> vault.get(Vault.LISTENERS).getAll().forEach(listener -> listener.getPlayer().ifPresent(player -> {
                tile.generatePlayerIfNotExists((Player)player);
                if (tile.getMonitoredEntityId() == -1) {
                    tile.setMonitoredEntityId(tile.createTommy().m_142049_());
                }
            })));
        }
        if (tile.monitoredEntityId == -1) {
            monitoredEntity = tile.createTommy();
        } else {
            monitoredEntity = level.m_6815_(tile.monitoredEntityId);
            if (monitoredEntity == null) {
                monitoredEntity = tile.createTommy();
            }
        }
        monitoredEntity.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
    }

    public void generatePlayerIfNotExists(Player player) {
        UUID playerId = player.m_142081_();
        Vault vault = VaultUtils.getVault(player.m_183503_()).orElse(null);
        if (vault == null) {
            return;
        }
        int vaultLevel = vault.get(Vault.LEVEL).get();
        if (!this.presets.containsKey(playerId)) {
            this.presets.put(playerId, ModConfigs.PRESET_CONFIG.generatePresets(vaultLevel));
        }
        if (!this.blueTrinketPresets.containsKey(playerId)) {
            this.blueTrinketPresets.put(playerId, ModConfigs.PRESET_CONFIG.getRandomBlueTrinketPresets(vaultLevel));
        }
        if (!this.redTrinketPresets.containsKey(playerId)) {
            this.redTrinketPresets.put(playerId, ModConfigs.PRESET_CONFIG.getRandomRedTrinketPresets(vaultLevel));
        }
        if (!this.tab.containsKey(playerId)) {
            this.tab.put(playerId, 0);
        }
        if (!this.loot.containsKey(playerId)) {
            this.loot.put(playerId, ModConfigs.ROYALE_LOOT.generate(player));
        }
    }

    private Entity createTommy() {
        ServerLevel sWorld = (ServerLevel)this.m_58904_();
        TommyEntity tommy = (TommyEntity)ModEntities.TOMMY.m_20655_(sWorld, null, null, null, this.m_58899_(), MobSpawnType.STRUCTURE, false, false);
        tommy.setTommyPos(this.m_58899_());
        sWorld.m_7967_((Entity)tommy);
        this.monitoredEntityId = tommy.m_142049_();
        return tommy;
    }

    public int getMonitoredEntityId() {
        return this.monitoredEntityId;
    }

    public void setMonitoredEntityId(int id) {
        if (this.monitoredEntityId == -1) {
            this.monitoredEntityId = id;
        }
    }

    @Nullable
    public RoyalePresetConfig.SkillPreset getPreset(String id, UUID player) {
        for (String preset : this.presets.get(player).keySet()) {
            if (!preset.equals(id)) continue;
            return ModConfigs.PRESET_CONFIG.getSkillPreset(preset);
        }
        return null;
    }

    @Nullable
    public Map<String, Integer> getPresetValues(String id, UUID player) {
        return this.presets.get(player).get(id);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        CompoundTag presets = nbt.m_128469_("presets");
        this.presets.clear();
        for (Object key : presets.m_128431_()) {
            CompoundTag presetTag = presets.m_128469_((String)key);
            UUID playerId = presetTag.m_128342_("playerId");
            HashMap playerPresets = new HashMap();
            ListTag valuesList = presetTag.m_128437_("values", 10);
            for (int i = 0; i < valuesList.size(); ++i) {
                CompoundTag valueTag = valuesList.m_128728_(i);
                String presetId = valueTag.m_128461_("presetId");
                HashMap<String, Integer> values = new HashMap<String, Integer>();
                ListTag valuesArray = valueTag.m_128437_("values", 10);
                for (int j = 0; j < valuesArray.size(); ++j) {
                    CompoundTag vTag = valuesArray.m_128728_(j);
                    values.put(vTag.m_128461_("key"), vTag.m_128451_("value"));
                }
                playerPresets.put(presetId, values);
            }
            this.presets.put(playerId, playerPresets);
        }
        this.monitoredEntityId = nbt.m_128451_("monitoredEntityId");
        CompoundTag blueTrinketPresetsTag = nbt.m_128469_("blueTrinketPresets");
        for (Object key : blueTrinketPresetsTag.m_128431_()) {
            ListTag presetList = blueTrinketPresetsTag.m_128437_((String)key, 8);
            List<ResourceLocation> bluePresets = presetList.stream().map(tag -> new ResourceLocation(tag.m_7916_())).toList();
            this.blueTrinketPresets.put(UUID.fromString((String)key), bluePresets);
        }
        CompoundTag redTrinketPresetsTag = nbt.m_128469_("redTrinketPresets");
        for (String key : redTrinketPresetsTag.m_128431_()) {
            ListTag presetList = redTrinketPresetsTag.m_128437_(key, 8);
            List<ResourceLocation> redPresets = presetList.stream().map(tag -> new ResourceLocation(tag.m_7916_())).toList();
            this.redTrinketPresets.put(UUID.fromString(key), redPresets);
        }
        this.tab.clear();
        CompoundTag tabTag = nbt.m_128469_("tab");
        for (String key : tabTag.m_128431_()) {
            this.tab.put(UUID.fromString(key), tabTag.m_128451_(key));
        }
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        CompoundTag presets = new CompoundTag();
        for (Map.Entry<UUID, Map<String, Map<String, Integer>>> entry : this.presets.entrySet()) {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128362_("playerId", entry.getKey());
            ListTag listTag = new ListTag();
            for (Map.Entry<String, Map<String, Integer>> valueEntry : entry.getValue().entrySet()) {
                CompoundTag valueTag = new CompoundTag();
                valueTag.m_128359_("presetId", valueEntry.getKey());
                ListTag values = new ListTag();
                for (Map.Entry<String, Integer> vEntry : valueEntry.getValue().entrySet()) {
                    CompoundTag vTag = new CompoundTag();
                    vTag.m_128359_("key", vEntry.getKey());
                    vTag.m_128405_("value", vEntry.getValue().intValue());
                    values.add((Object)vTag);
                }
                valueTag.m_128365_("values", (Tag)values);
                listTag.add((Object)valueTag);
            }
            compoundTag.m_128365_("values", (Tag)listTag);
            presets.m_128365_(entry.getKey().toString(), (Tag)compoundTag);
        }
        pTag.m_128365_("presets", (Tag)presets);
        pTag.m_128405_("monitoredEntityId", this.monitoredEntityId);
        CompoundTag blueTrinketPresetsTag = new CompoundTag();
        for (Map.Entry<UUID, List<ResourceLocation>> entry : this.blueTrinketPresets.entrySet()) {
            ListTag listTag = new ListTag();
            for (ResourceLocation preset : entry.getValue()) {
                listTag.add((Object)StringTag.m_129297_((String)preset.toString()));
            }
            blueTrinketPresetsTag.m_128365_(entry.getKey().toString(), (Tag)listTag);
        }
        pTag.m_128365_("blueTrinketPresets", (Tag)blueTrinketPresetsTag);
        CompoundTag compoundTag = new CompoundTag();
        for (Map.Entry<UUID, List<ResourceLocation>> entry : this.redTrinketPresets.entrySet()) {
            ListTag presetList = new ListTag();
            for (ResourceLocation preset : entry.getValue()) {
                presetList.add((Object)StringTag.m_129297_((String)preset.toString()));
            }
            compoundTag.m_128365_(entry.getKey().toString(), (Tag)presetList);
        }
        pTag.m_128365_("redTrinketPresets", (Tag)compoundTag);
        CompoundTag compoundTag2 = new CompoundTag();
        for (Map.Entry<UUID, Integer> entry : this.tab.entrySet()) {
            compoundTag2.m_128405_(entry.getKey().toString(), entry.getValue().intValue());
        }
        pTag.m_128365_("tab", (Tag)compoundTag2);
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void sendUpdates() {
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 11);
        this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        this.m_6596_();
    }

    public Map<String, Map<String, Integer>> getPresets(UUID player) {
        return this.presets.get(player);
    }

    public List<ResourceLocation> getBlueTrinketPresets(UUID player) {
        return this.blueTrinketPresets.get(player);
    }

    public List<ResourceLocation> getRedTrinketPresets(UUID player) {
        return this.redTrinketPresets.get(player);
    }

    public int getTab(UUID player) {
        return this.tab.getOrDefault(player, 0);
    }

    public void setTab(int tab, UUID player) {
        this.tab.put(player, tab);
        this.sendUpdates();
    }

    public List<List<ItemStack>> getLoot(UUID uuid) {
        return this.loot.getOrDefault(uuid, List.of());
    }
}

