/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import com.google.common.collect.Lists;
import iskallia.vault.container.inventory.RoyaleLootCrateContainer;
import iskallia.vault.container.oversized.OverSizedItemStack;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.key.LootTableKey;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.VaultRoyaleCrateGenerationEvent;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.world.loot.LootTable;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.IdentifiableItem;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModParticles;
import iskallia.vault.util.MiscUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class RoyaleLootBlockEntity
extends ChestBlockEntity
implements MenuProvider {
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(Level p_155357_, BlockPos p_155358_, BlockState p_155359_) {
            RoyaleLootBlockEntity.this.playSound(p_155359_, SoundEvents.f_11725_);
        }

        protected void m_142289_(Level p_155367_, BlockPos p_155368_, BlockState p_155369_) {
            RoyaleLootBlockEntity.this.playSound(p_155369_, SoundEvents.f_11724_);
        }

        protected void m_142148_(Level p_155361_, BlockPos p_155362_, BlockState p_155363_, int p_155364_, int p_155365_) {
            RoyaleLootBlockEntity.this.m_142151_(p_155361_, p_155362_, p_155363_, p_155364_, p_155365_);
        }

        protected boolean m_142718_(Player p_155355_) {
            AbstractContainerMenu abstractContainerMenu = p_155355_.f_36096_;
            if (!(abstractContainerMenu instanceof RoyaleLootCrateContainer)) {
                return false;
            }
            RoyaleLootCrateContainer container = (RoyaleLootCrateContainer)abstractContainerMenu;
            return container.getCrateEntity() == RoyaleLootBlockEntity.this && container.getCrateInventory() == RoyaleLootBlockEntity.this.getPersonalContainer(p_155355_);
        }
    };
    private boolean generated;
    private int generatedStacksCount;
    private int size = 5;
    private boolean vaultCrate;
    private final Map<UUID, NonNullList<ItemStack>> playerInventories = new HashMap<UUID, NonNullList<ItemStack>>();
    private final Set<UUID> generatedPlayers = new HashSet<UUID>();

    public RoyaleLootBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.ROYALE_CRATE_ENTITY, pos, state);
        this.m_6520_(NonNullList.m_122780_((int)this.size, (Object)ItemStack.f_41583_));
    }

    public void m_5856_(Player pPlayer) {
        if (!this.f_58859_ && !pPlayer.m_5833_()) {
            this.openersCounter.m_155452_(pPlayer, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void m_5785_(Player pPlayer) {
        if (!this.f_58859_ && !pPlayer.m_5833_()) {
            this.openersCounter.m_155468_(pPlayer, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void m_155350_() {
        if (!this.f_58859_) {
            this.openersCounter.m_155476_(this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public int m_6643_() {
        return this.size;
    }

    public AbstractContainerMenu m_7208_(int pId, Inventory inv, Player pPlayer) {
        Container personalInv = this.getPersonalContainer(pPlayer);
        return new RoyaleLootCrateContainer(pId, inv, personalInv, this);
    }

    protected void playSound(BlockState pState, SoundEvent pSound) {
        Vec3i vec3i = ((Direction)pState.m_61143_((Property)BarrelBlock.f_49042_)).m_122436_();
        double d0 = (double)this.f_58858_.m_123341_() + 0.5 + (double)vec3i.m_123341_() / 2.0;
        double d1 = (double)this.f_58858_.m_123342_() + 0.5 + (double)vec3i.m_123342_() / 2.0;
        double d2 = (double)this.f_58858_.m_123343_() + 0.5 + (double)vec3i.m_123343_() / 2.0;
        this.f_58857_.m_6263_(null, d0, d1, d2, pSound, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.nextFloat() * 0.1f + 0.9f);
    }

    public void m_59640_(Player player) {
        this.generateChestLoot(player, false);
    }

    public Container getPersonalContainer(Player player) {
        if (player == null) {
            NonNullList emptyList = NonNullList.m_122780_((int)this.size, (Object)ItemStack.f_41583_);
            NonNullList mutableList = NonNullList.m_122779_();
            mutableList.addAll((Collection)emptyList);
            return new PersonalInventory((NonNullList<ItemStack>)mutableList);
        }
        UUID id = player.m_142081_();
        NonNullList inv = this.playerInventories.computeIfAbsent(id, u -> {
            NonNullList newList = NonNullList.m_122779_();
            for (int i = 0; i < this.size; ++i) {
                newList.add((Object)ItemStack.f_41583_);
            }
            return newList;
        });
        if (!this.generatedPlayers.contains(id)) {
            this.generateLootFor(player, (NonNullList<ItemStack>)inv);
            this.generatedPlayers.add(id);
            if (!this.generated) {
                this.generated = true;
            }
        }
        return new PersonalInventory((NonNullList<ItemStack>)inv);
    }

    private void generateLootFor(Player player, NonNullList<ItemStack> destination) {
        NonNullList old = this.m_7086_();
        boolean prevGen = this.generated;
        int prevCount = this.generatedStacksCount;
        this.generated = false;
        this.m_6520_(destination);
        JavaRandom playerRandom = JavaRandom.ofNanoTime();
        this.generateChestLootWithRandom(player, false, playerRandom);
        for (int i = 0; i < destination.size(); ++i) {
            destination.set(i, (Object)this.m_8020_(i));
        }
        this.m_6520_(old);
        this.generated = prevGen;
        this.generatedStacksCount = prevCount;
    }

    private void generateChestLootWithRandom(Player source, boolean compress, RandomSource random) {
        ServerPlayer player;
        block6: {
            block5: {
                if (this.m_58904_() == null || this.m_58904_().m_5776_() || !(source instanceof ServerPlayer)) break block5;
                player = (ServerPlayer)source;
                if (this.vaultCrate) break block6;
            }
            return;
        }
        if (MiscUtils.isPlayerFakeMP(player) || source.m_5833_()) {
            return;
        }
        ArrayList<ItemStack> loot = new ArrayList<ItemStack>();
        VaultRoyaleCrateGenerationEvent.Data data = CommonEvents.VAULT_ROYALE_CRATE_LOOT_GENERATION.invoke(player, this.m_58900_(), this.m_58899_(), this.f_59605_, this, loot, Version.latest(), random, VaultRoyaleCrateGenerationEvent.Phase.PRE);
        this.f_59605_ = data.getLootTable();
        if (this.f_59605_ == null) {
            return;
        }
        this.generateLootTable(data.getVersion(), source, loot, random);
        CommonEvents.VAULT_ROYALE_CRATE_LOOT_GENERATION.invoke(player, this.m_58900_(), this.m_58899_(), this.f_59605_, this, loot, data.getVersion(), random, VaultRoyaleCrateGenerationEvent.Phase.POST);
        this.fillLoot(source, loot, compress, random);
    }

    public void generateChestLoot(Player source, boolean compress) {
        ServerPlayer player;
        block7: {
            block6: {
                if (this.m_58904_() == null || this.m_58904_().m_5776_() || !(source instanceof ServerPlayer)) break block6;
                player = (ServerPlayer)source;
                if (!this.generated && this.vaultCrate) break block7;
            }
            return;
        }
        if (MiscUtils.isPlayerFakeMP(player) || source.m_5833_()) {
            this.generated = true;
            this.generatedStacksCount = 0;
            this.m_6596_();
            return;
        }
        ArrayList<ItemStack> loot = new ArrayList<ItemStack>();
        VaultRoyaleCrateGenerationEvent.Data data = CommonEvents.VAULT_ROYALE_CRATE_LOOT_GENERATION.invoke(player, this.m_58900_(), this.m_58899_(), this.f_59605_, this, loot, Version.latest(), JavaRandom.ofNanoTime(), VaultRoyaleCrateGenerationEvent.Phase.PRE);
        this.f_59605_ = data.getLootTable();
        if (this.f_59605_ == null) {
            this.generated = true;
            this.generatedStacksCount = 0;
            this.m_6596_();
            return;
        }
        this.generateLootTable(data.getVersion(), source, loot, data.getRandom());
        CommonEvents.VAULT_ROYALE_CRATE_LOOT_GENERATION.invoke(player, this.m_58900_(), this.m_58899_(), this.f_59605_, this, loot, data.getVersion(), data.getRandom(), VaultRoyaleCrateGenerationEvent.Phase.POST);
        this.fillLoot(source, loot, compress, data.getRandom());
        this.generated = true;
        this.generatedStacksCount = 0;
        for (int i = 0; i < this.m_6643_(); ++i) {
            this.generatedStacksCount += this.m_8020_(i).m_41619_() ? 1 : 0;
        }
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    private void generateLootTable(Version version, @Nullable Player player, List<ItemStack> loot, RandomSource random) {
        LootTable table;
        LootTableKey key = VaultRegistry.LOOT_TABLE.getKey(this.f_59605_);
        if (key != null && (table = (LootTable)key.get(version)) != null) {
            for (LootTable.Entry entry : table.getEntries()) {
                entry.getPool().getRandomFlat(version, random).ifPresent(e -> {
                    OverSizedItemStack stack = e.getOverStack(random);
                    ItemStack singleStack = stack.splitByStackSize().get(0);
                    if (singleStack != null) {
                        loot.add(singleStack);
                    }
                });
            }
        }
        this.m_6596_();
    }

    public void fillLoot(Player source, List<ItemStack> loot, boolean compress, RandomSource random) {
        if (compress) {
            List<ItemStack> mergedLoot = MiscUtils.splitAndLimitStackSize(MiscUtils.mergeItemStacks(loot));
            mergedLoot.forEach(stack -> MiscUtils.addItemStack((Container)this, stack));
            this.m_6596_();
            return;
        }
        if (loot.size() > this.size) {
            loot = MiscUtils.splitAndLimitStackSize(MiscUtils.mergeItemStacks(loot));
        }
        List<Integer> slots = this.getAvailableSlots((Container)this, random);
        for (ItemStack itemstack : loot) {
            VaultGearData gearData;
            Item item;
            if (slots.isEmpty()) break;
            this.m_6836_(slots.remove(slots.size() - 1), itemstack.m_41619_() ? ItemStack.f_41583_ : itemstack);
            if (source != null && (item = itemstack.m_41720_()) instanceof IdentifiableItem) {
                IdentifiableItem identifiableItem = (IdentifiableItem)item;
                identifiableItem.instantIdentify(source, itemstack, false);
            }
            if (!(itemstack.m_41720_() instanceof VaultGearItem) || (gearData = VaultGearData.read(itemstack)).removeAttribute(ModGearAttributes.SOULBOUND) == null) continue;
            gearData.write(itemstack);
        }
        this.m_6596_();
    }

    private List<Integer> getAvailableSlots(Container pInventory, RandomSource pRand) {
        int i;
        ArrayList list = Lists.newArrayList();
        for (i = 0; i < pInventory.m_6643_(); ++i) {
            if (!pInventory.m_8020_(i).m_41619_()) continue;
            list.add(i);
        }
        for (i = list.size(); i > 1; --i) {
            int index = pRand.nextInt(i);
            int temp = (Integer)list.get(i - 1);
            list.set(i - 1, (Integer)list.get(index));
            list.set(index, temp);
        }
        return list;
    }

    public void m_6836_(int index, @NotNull ItemStack stack) {
        super.m_6836_(index, stack);
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        stack.m_41784_().m_128379_("VaultRoyaleLootable", true);
    }

    public ItemStack m_7407_(int index, int count) {
        ItemStack stack = super.m_7407_(index, count);
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        return stack;
    }

    public ItemStack m_8016_(int index) {
        ItemStack stack = super.m_8016_(index);
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        return stack;
    }

    protected boolean m_59631_(CompoundTag nbt) {
        super.m_59631_(nbt);
        return false;
    }

    protected boolean m_59634_(CompoundTag nbt) {
        super.m_59634_(nbt);
        return false;
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        int i;
        super.m_142466_(nbt);
        this.generated = nbt.m_128471_("Generated");
        this.generatedStacksCount = nbt.m_128451_("GeneratedStacksCount");
        this.vaultCrate = nbt.m_128425_("LootTable", 8) && !nbt.m_128461_("LootTable").isBlank();
        this.playerInventories.clear();
        if (nbt.m_128425_("PlayerInventories", 9)) {
            ListTag list = nbt.m_128437_("PlayerInventories", 10);
            for (i = 0; i < list.size(); ++i) {
                CompoundTag pt = list.m_128728_(i);
                UUID id = pt.m_128342_("Player");
                NonNullList items = NonNullList.m_122780_((int)this.size, (Object)ItemStack.f_41583_);
                ContainerHelper.m_18980_((CompoundTag)pt, (NonNullList)items);
                this.playerInventories.put(id, (NonNullList<ItemStack>)items);
            }
        }
        this.generatedPlayers.clear();
        if (nbt.m_128425_("GeneratedPlayers", 9)) {
            ListTag gens = nbt.m_128437_("GeneratedPlayers", 11);
            for (i = 0; i < gens.size(); ++i) {
                this.generatedPlayers.add(NbtUtils.m_129233_((Tag)gens.get(i)));
            }
        }
    }

    protected void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128379_("Generated", this.generated);
        nbt.m_128405_("GeneratedStacksCount", this.generatedStacksCount);
        ListTag list = new ListTag();
        for (Map.Entry<UUID, NonNullList<ItemStack>> entry : this.playerInventories.entrySet()) {
            CompoundTag pt = new CompoundTag();
            pt.m_128362_("Player", entry.getKey());
            ContainerHelper.m_18973_((CompoundTag)pt, entry.getValue());
            list.add((Object)pt);
        }
        if (!list.isEmpty()) {
            nbt.m_128365_("PlayerInventories", (Tag)list);
        }
        ListTag gens = new ListTag();
        for (UUID id : this.generatedPlayers) {
            gens.add((Object)NbtUtils.m_129226_((UUID)id));
        }
        if (!gens.isEmpty()) {
            nbt.m_128365_("GeneratedPlayers", (Tag)gens);
        }
    }

    public boolean isVaultCrate() {
        return this.vaultCrate;
    }

    public void setVaultCrate(boolean vaultCrate) {
        this.vaultCrate = vaultCrate;
        this.m_6596_();
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, RoyaleLootBlockEntity royaleCrateBlockEntity) {
        if (level.f_46443_ && royaleCrateBlockEntity.isVaultCrate() && !royaleCrateBlockEntity.generated) {
            RoyaleLootBlockEntity.clientTick(level, blockPos, blockState, royaleCrateBlockEntity);
        }
    }

    private static void clientTick(Level level, BlockPos blockPos, BlockState blockState, RoyaleLootBlockEntity royaleCrateBlockEntity) {
        if (level.m_46467_() % 5L == 0L) {
            for (int i = 0; i < 10; ++i) {
                double x = (double)blockPos.m_123341_() + Math.random();
                double y = (double)blockPos.m_123342_() + Math.random();
                double z = (double)blockPos.m_123343_() + Math.random();
                level.m_7106_((ParticleOptions)ModParticles.GRID_GATEWAY.get(), x, (double)(blockPos.m_123342_() + 1), z, 0.0, 0.05, 0.0);
            }
        }
    }

    private class PersonalInventory
    implements Container {
        private final NonNullList<ItemStack> items;

        PersonalInventory(NonNullList<ItemStack> items) {
            this.items = items;
        }

        public int m_6643_() {
            return this.items.size();
        }

        public boolean m_7983_() {
            for (ItemStack stack : this.items) {
                if (stack.m_41619_()) continue;
                return false;
            }
            return true;
        }

        public ItemStack m_8020_(int index) {
            return (ItemStack)this.items.get(index);
        }

        public ItemStack m_7407_(int index, int count) {
            ItemStack stack = ContainerHelper.m_18969_(this.items, (int)index, (int)count);
            if (!stack.m_41619_()) {
                this.m_6596_();
            }
            return stack;
        }

        public ItemStack m_8016_(int index) {
            ItemStack stack = ContainerHelper.m_18966_(this.items, (int)index);
            return stack;
        }

        public void m_6836_(int index, ItemStack stack) {
            this.items.set(index, (Object)stack);
            stack.m_41784_().m_128379_("VaultRoyaleLootable", true);
            this.m_6596_();
        }

        public void m_6596_() {
            RoyaleLootBlockEntity.this.m_6596_();
        }

        public boolean m_6542_(Player player) {
            return RoyaleLootBlockEntity.this.m_6542_(player);
        }

        public void m_6211_() {
            this.items.clear();
        }
    }
}

