/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.container.oversized.OverSizedInventory;
import iskallia.vault.init.ModBlocks;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class SkillAltarTileEntity
extends BlockEntity {
    private static final String OWNER_ID_TAG = "ownerId";
    @Nullable
    private UUID ownerId = null;
    private final OverSizedInventory vaultGoldInventory = new OverSizedInventory(1, stacks -> this.m_6596_(), player -> true);
    private int renderIconKeyIndex = -1;
    private long lastIconSwitchTime = 0L;
    private long nextIconSwitchTime = 0L;

    public SkillAltarTileEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super(ModBlocks.SKILL_ALTAR_TILE_ENTITY, pWorldPosition, pBlockState);
    }

    public void setOwner(UUID ownerId) {
        this.ownerId = ownerId;
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.ownerId != null) {
            tag.m_128362_(OWNER_ID_TAG, this.ownerId);
        }
        tag.m_128365_("regretOrbs", (Tag)this.vaultGoldInventory.m_8020_(0).m_41739_(new CompoundTag()));
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.ownerId = tag.m_128441_(OWNER_ID_TAG) ? tag.m_128342_(OWNER_ID_TAG) : null;
        this.vaultGoldInventory.m_6836_(0, ItemStack.m_41712_((CompoundTag)tag.m_128469_("regretOrbs")));
    }

    public OverSizedInventory getVaultGoldInventory() {
        return this.vaultGoldInventory;
    }

    public UUID getOwnerId() {
        return this.ownerId;
    }

    public void consumeOrbs(int count) {
        ItemStack regretOrbs = this.vaultGoldInventory.m_8020_(0);
        regretOrbs.m_41774_(count);
        this.vaultGoldInventory.m_6836_(0, regretOrbs);
        this.m_6596_();
    }

    public int getRenderIconKeyIndex() {
        return this.renderIconKeyIndex;
    }

    public long getLastIconSwitchTime() {
        return this.lastIconSwitchTime;
    }

    public long getNextIconSwitchTime() {
        return this.nextIconSwitchTime;
    }

    public void switchToNextIcon(int nextIconKeyIndex, long lastIconSwitchTime, long nextIconSwitchTime) {
        this.renderIconKeyIndex = nextIconKeyIndex;
        this.lastIconSwitchTime = lastIconSwitchTime;
        this.nextIconSwitchTime = nextIconSwitchTime;
    }
}

