/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.block.SoulPlaqueBlock;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.util.SkinProfile;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class SoulPlaqueTileEntity
extends BlockEntity {
    private UUID uuid;
    private SkinProfile skin = new SkinProfile();
    private int score;

    public SoulPlaqueTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public SoulPlaqueTileEntity(BlockPos pos, BlockState state) {
        this(ModBlocks.SOUL_PLAQUE_TILE_ENTITY, pos, state);
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public SkinProfile getSkin() {
        return this.skin;
    }

    public int getScore() {
        return this.score;
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void sendUpdates() {
        if (this.f_58857_ == null) {
            return;
        }
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        this.m_6596_();
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.uuid = nbt.m_128441_("OwnerUuid") ? UUID.fromString(nbt.m_128461_("OwnerUuid")) : null;
        if (nbt.m_128441_("OwnerName")) {
            this.skin.updateSkin(nbt.m_128461_("OwnerName"));
        }
        this.score = nbt.m_128451_("Score");
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        if (this.uuid != null) {
            nbt.m_128359_("OwnerUuid", this.uuid.toString());
        }
        if (this.skin.getLatestNickname() != null) {
            nbt.m_128359_("OwnerName", this.skin.getLatestNickname());
        }
        nbt.m_128405_("Score", this.score);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SoulPlaqueTileEntity tile) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)level;
        int tier = ModConfigs.ASCENSION.getTier(tile.getScore());
        if ((Integer)state.m_61143_((Property)SoulPlaqueBlock.TIER) != tier) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)SoulPlaqueBlock.TIER, (Comparable)Integer.valueOf(tier)), 2);
        }
    }
}

