/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.block.SparkBlock;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModParticles;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SparkTileEntity
extends BlockEntity {
    private int totalLifetime = 0;
    private int lifetime = 0;
    private int lifetimeOld = 0;
    private final int offsetTicks = new Random().nextInt(360);

    public SparkTileEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super(ModBlocks.SPARK_TILE_ENTITY, pWorldPosition, pBlockState);
    }

    public int getOffsetTicks() {
        return this.offsetTicks;
    }

    public void setLifetime(int lifetime) {
        this.totalLifetime = lifetime;
        this.lifetime = lifetime;
        this.m_6596_();
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    public float getLifeTimePercentage() {
        return this.totalLifetime > 0 ? (float)this.lifetime / (float)this.totalLifetime : 1.0f;
    }

    public float getLifeTimePercentageOld() {
        return this.totalLifetime > 0 ? (float)this.lifetimeOld / (float)this.totalLifetime : 1.0f;
    }

    public boolean hasntExpiredYet() {
        return this.lifetime > 0;
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.totalLifetime = tag.m_128451_("TotalLifetime");
        this.lifetime = tag.m_128451_("Lifetime");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("TotalLifetime", this.totalLifetime);
        tag.m_128405_("Lifetime", this.lifetime);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SparkTileEntity tile) {
        tile.lifetimeOld = tile.lifetime;
        if (tile.lifetime > 0) {
            --tile.lifetime;
            if (level.f_46443_) {
                Random random = new Random();
                float rotation = random.nextFloat() * 360.0f;
                float radiusOffset = random.nextFloat() + 0.5f;
                Vec3 offset = new Vec3((double)(radiusOffset / 15.0f) * Math.cos(rotation), 0.0, (double)(radiusOffset / 15.0f) * Math.sin(rotation));
                level.m_6493_((ParticleOptions)ModParticles.WENDARR_SPARK_EXPLODE.get(), true, (double)pos.m_123341_() + 0.5 + offset.f_82479_, (double)pos.m_123342_() + 0.5 + random.nextDouble() * (double)0.15f, (double)pos.m_123343_() + 0.5 + offset.f_82481_, offset.f_82479_ / 8.0, random.nextDouble() * 0.025 - (double)0.0125f, offset.f_82481_ / 8.0);
                level.m_6493_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, Blocks.f_49992_.m_49966_()), true, (double)pos.m_123341_() + 0.5 + offset.f_82479_, (double)pos.m_123342_() + random.nextDouble() * (double)0.15f, (double)pos.m_123343_() + 0.5 + offset.f_82481_, offset.f_82479_ / 8.0, random.nextDouble() * 0.025 - (double)0.0125f, offset.f_82481_ / 8.0);
            }
            if (tile.lifetime == 0) {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)SparkBlock.EXPENDED, (Comparable)Boolean.valueOf(true)));
            }
        }
    }
}

