/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.init.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class SpectatorTerminalTileEntity
extends BlockEntity {
    public float rot;
    public float oRot;
    public float tRot;
    public float rotX;
    public float oRotX;
    public float tRotX;

    public SpectatorTerminalTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.SPECTATOR_TERMINAL_ENTITY, pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SpectatorTerminalTileEntity tile) {
        tile.oRot = tile.rot;
        tile.oRotX = tile.rotX;
        Player player = level.m_45924_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 14.0, false);
        if (player != null) {
            double dx = player.m_20185_() - ((double)pos.m_123341_() + 0.5);
            double dz = player.m_20189_() - ((double)pos.m_123343_() + 0.5);
            double dy = player.m_20188_() - ((double)pos.m_123342_() + 0.75) + 0.4;
            tile.tRot = (float)Mth.m_14136_((double)dz, (double)dx);
            double horizDist = Math.sqrt(dx * dx + dz * dz);
            tile.tRotX = (float)(-Mth.m_14136_((double)dy, (double)horizDist));
        } else {
            tile.tRot += 0.02f;
            tile.tRotX = 0.0f;
        }
        float yawDiff = Mth.m_14118_((float)(tile.rot * 57.295776f), (float)(tile.tRot * 57.295776f)) * ((float)Math.PI / 180);
        tile.rot += yawDiff * 0.4f;
        float pitchDiff = Mth.m_14118_((float)(tile.rotX * 57.295776f), (float)(tile.tRotX * 57.295776f)) * ((float)Math.PI / 180);
        tile.rotX += pitchDiff * 0.4f;
    }

    public float getYaw(float partialTicks) {
        float diff = this.rot - this.oRot;
        while ((double)diff < -Math.PI) {
            diff = (float)((double)diff + Math.PI * 2);
        }
        while ((double)diff >= Math.PI) {
            diff = (float)((double)diff - Math.PI * 2);
        }
        return this.oRot + diff * partialTicks;
    }

    public float getPitch(float partialTicks) {
        float diff = this.rotX - this.oRotX;
        while ((double)diff < -Math.PI) {
            diff = (float)((double)diff + Math.PI * 2);
        }
        while ((double)diff >= Math.PI) {
            diff = (float)((double)diff - Math.PI * 2);
        }
        return this.oRotX + diff * partialTicks;
    }
}

