/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.block.StabilizerBlock;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModParticles;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class StabilizerTileEntity
extends BlockEntity {
    private static final Random rand = new Random();
    private static final AABB RENDER_BOX = new AABB(-1.0, -1.0, -1.0, 1.0, 2.0, 1.0);
    private boolean active = false;
    private int timeout = 20;
    private final List<Object> particleReferences = new ArrayList<Object>();

    public StabilizerTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.STABILIZER_TILE_ENTITY, pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, StabilizerTileEntity tile) {
        if (!level.m_5776_()) {
            BlockState up = level.m_8055_(pos.m_7494_());
            if (!(up.m_60734_() instanceof StabilizerBlock)) {
                level.m_46597_(pos.m_7494_(), (BlockState)ModBlocks.STABILIZER.m_49966_().m_61124_(StabilizerBlock.HALF, (Comparable)DoubleBlockHalf.UPPER));
            }
            if (tile.active && tile.timeout > 0) {
                --tile.timeout;
                if (tile.timeout <= 0) {
                    tile.active = false;
                    tile.markForUpdate();
                }
            }
        } else {
            tile.setupParticle();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void setupParticle() {
        if (this.particleReferences.size() < 3) {
            int toAdd = 3 - this.particleReferences.size();
            for (int i = 0; i < toAdd; ++i) {
                ParticleEngine mgr = Minecraft.m_91087_().f_91061_;
                Particle p = mgr.m_107370_((ParticleOptions)ModParticles.STABILIZER_CUBE.get(), (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, 0.0, 0.0, 0.0);
                if (p == null) continue;
                this.particleReferences.add(p);
            }
        }
        this.particleReferences.removeIf(ref -> !((Particle)ref).m_107276_());
        if (this.isActive()) {
            Vec3 particlePos = new Vec3((double)((float)this.f_58858_.m_123341_() + rand.nextFloat()), (double)((float)this.f_58858_.m_123342_() + rand.nextFloat() * 2.0f), (double)((float)this.f_58858_.m_123343_() + rand.nextFloat()));
            ParticleEngine mgr = Minecraft.m_91087_().f_91061_;
            SimpleAnimatedParticle p = (SimpleAnimatedParticle)mgr.m_107370_((ParticleOptions)ParticleTypes.f_123815_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 0.0, 0.0, 0.0);
            if (p != null) {
                p.m_107657_(301982);
            }
        }
    }

    public void setActive() {
        this.active = true;
        this.timeout = 20;
        this.markForUpdate();
    }

    public boolean isActive() {
        return this.active;
    }

    private void markForUpdate() {
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
            this.m_6596_();
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.active = tag.m_128471_("active");
    }

    public void m_183515_(CompoundTag tag) {
        tag.m_128379_("active", this.active);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        this.m_183515_(nbt);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag nbt) {
        this.m_142466_(nbt);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag nbt = pkt.m_131708_();
        this.handleUpdateTag(nbt);
    }

    public AABB getRenderBoundingBox() {
        return RENDER_BOX.m_82338_(this.m_58899_());
    }
}

