/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import com.mojang.serialization.DynamicOps;
import iskallia.vault.VaultMod;
import iskallia.vault.init.ModBlocks;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.Logger;

public class SurgeBlockTileEntity
extends BlockEntity {
    public static final int MAX_LIFE_TIME = 10;
    @Nullable
    private BlockState storedBlockState = null;
    private int lifeTime = 0;
    private float attackDamage = 0.0f;
    private boolean didDamage = false;
    private UUID ownerId;
    private float surgeRatio = 0.0f;
    private boolean spawnedParticles = false;

    public SurgeBlockTileEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super(ModBlocks.SURGE_BLOCK_TILE_ENTITY, pWorldPosition, pBlockState);
    }

    public void setData(UUID owner, BlockState state, float attackDamage, float surgeRatio) {
        this.storedBlockState = state;
        this.attackDamage = attackDamage;
        this.ownerId = owner;
        this.surgeRatio = surgeRatio;
        this.m_6596_();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.storedBlockState = BlockState.f_61039_.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_("StoredBlockState")).resultOrPartial(arg_0 -> ((Logger)VaultMod.LOGGER).error(arg_0)).orElse(null);
        this.attackDamage = tag.m_128457_("AttackDamage");
        this.didDamage = tag.m_128471_("DidDamage");
        this.ownerId = tag.m_128342_("OwnerId");
        this.surgeRatio = tag.m_128457_("SurgeRatio");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.saveData(tag);
    }

    private void saveData(CompoundTag tag) {
        if (this.storedBlockState != null) {
            BlockState.f_61039_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.storedBlockState).resultOrPartial(arg_0 -> ((Logger)VaultMod.LOGGER).error(arg_0)).ifPresent(blockStateTag -> tag.m_128365_("StoredBlockState", blockStateTag));
            tag.m_128350_("AttackDamage", this.attackDamage);
            tag.m_128379_("DidDamage", this.didDamage);
            tag.m_128362_("OwnerId", this.ownerId);
            tag.m_128350_("SurgeRatio", this.surgeRatio);
        }
    }

    public BlockState getStoredBlockState() {
        return this.storedBlockState;
    }

    public int getLifeTime() {
        return this.lifeTime;
    }

    public float getSurgeRatio() {
        return this.surgeRatio;
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, SurgeBlockTileEntity tileEntity) {
        ++tileEntity.lifeTime;
        if (!level.m_5776_()) {
            if (!tileEntity.didDamage) {
                BlockPos above = blockPos.m_7494_();
                LivingEntity owner = tileEntity.getOwner();
                if (owner == null) {
                    return;
                }
                level.m_142425_(EntityTypeTest.m_156916_(LivingEntity.class), new AABB((double)above.m_123341_(), (double)above.m_123342_(), (double)above.m_123343_(), (double)(above.m_123341_() + 1), (double)above.m_123342_() + 0.7, (double)(above.m_123343_() + 1)), e -> true).forEach(target -> {
                    if (target == owner) {
                        return;
                    }
                    Vec3 deltaMovement = target.m_20184_();
                    double knockback = 0.5;
                    if (deltaMovement.m_7098_() < knockback * 2.0) {
                        target.m_20256_(deltaMovement.m_82520_(0.0, knockback, 0.0));
                        target.f_19812_ = true;
                    }
                    if (owner.m_6779_(target)) {
                        DamageSource damageSource;
                        if (owner instanceof Player) {
                            Player player = (Player)owner;
                            damageSource = DamageSource.m_19344_((Player)player);
                        } else {
                            damageSource = DamageSource.m_19370_((LivingEntity)owner);
                        }
                        target.m_6469_(damageSource, tileEntity.attackDamage);
                    }
                });
                tileEntity.didDamage = true;
                tileEntity.m_6596_();
            } else if (tileEntity.lifeTime >= 10 && tileEntity.storedBlockState != null) {
                level.m_7731_(blockPos, tileEntity.storedBlockState, 3);
            }
        } else if (!tileEntity.spawnedParticles && tileEntity.storedBlockState != null) {
            tileEntity.spawnedParticles = true;
            Random rnd = level.f_46441_;
            level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, tileEntity.storedBlockState), (double)blockPos.m_123341_() + rnd.nextDouble(), (double)(blockPos.m_123342_() + 2), (double)blockPos.m_123343_() + rnd.nextDouble(), 0.0, 0.01, 0.0);
        }
    }

    @Nullable
    private LivingEntity getOwner() {
        LivingEntity livingEntity;
        Level level;
        if (this.ownerId == null || !((level = this.f_58857_) instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Entity entity = serverLevel.m_8791_(this.ownerId);
        return entity instanceof LivingEntity ? (livingEntity = (LivingEntity)entity) : null;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag updateTag = super.m_5995_();
        this.saveData(updateTag);
        return updateTag;
    }
}

