/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.block.ICollectionTileEntity;
import iskallia.vault.core.vault.TeamTaskManager;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.task.Task;
import iskallia.vault.world.data.TeamTaskData;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import org.jetbrains.annotations.Nullable;

public class TaskPillarTileEntity
extends BlockEntity
implements ICollectionTileEntity {
    private static final int COMPLETION_CHECK_INTERVAL = 5;
    private long lastCompletionCheckTime = 0L;
    private boolean checkedForReclaimTaskId = false;
    private int lightsTintColor = -12303292;
    @Nullable
    private String taskId = null;
    @Nullable
    private String reclaimTaskId = null;
    private boolean replacedBlocksOnCompletion = false;
    @Nullable
    private String completedByTeam = null;

    public TaskPillarTileEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super(ModBlocks.TASK_PILLAR_TILE_ENTITY, pWorldPosition, pBlockState);
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            TeamTaskManager.addTaskEventListener(this, new TeamTaskManager.TaskEventListener(){

                @Override
                public void onTaskRefresh(String taskId) {
                    Level level;
                    if (this.isTaskOrAReclaimChild(taskId) && (level = TaskPillarTileEntity.this.f_58857_) instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        if (!taskId.equals(TaskPillarTileEntity.this.taskId)) {
                            TaskPillarTileEntity.this.taskId = taskId;
                            TaskPillarTileEntity.this.checkedForReclaimTaskId = false;
                        }
                        TeamTaskData teamTaskData = TeamTaskData.get(serverLevel.m_142572_());
                        String newCompletedByTeam = teamTaskData.getCompletedTaskTeam(taskId).orElse(null);
                        if (TaskPillarTileEntity.this.completedByTeam != null && newCompletedByTeam == null) {
                            TaskPillarTileEntity.this.completedByTeam = null;
                            TaskPillarTileEntity.this.lightsTintColor = -12303292;
                            TaskPillarTileEntity.placeBlocksBelow((Level)serverLevel, TaskPillarTileEntity.this.m_58899_(), Blocks.f_50069_.m_49966_());
                            TaskPillarTileEntity.this.m_6596_();
                            TaskPillarTileEntity.this.f_58857_.m_7260_(TaskPillarTileEntity.this.m_58899_(), TaskPillarTileEntity.this.m_58900_(), TaskPillarTileEntity.this.m_58900_(), 3);
                        } else if (TaskPillarTileEntity.this.completedByTeam != null && !TaskPillarTileEntity.this.completedByTeam.equals(newCompletedByTeam)) {
                            TaskPillarTileEntity.this.completedByTeam = newCompletedByTeam;
                            TaskPillarTileEntity.this.replacedBlocksOnCompletion = false;
                        }
                    }
                }

                private boolean isTaskOrAReclaimChild(String taskId) {
                    if (TaskPillarTileEntity.this.taskId == null) {
                        return false;
                    }
                    return TaskPillarTileEntity.this.taskId.equals(taskId) || ModConfigs.TEAM_TASKS.getNextTask(taskId).map(t -> this.isTaskOrAReclaimChild(t.getId())).orElse(false) != false;
                }

                @Override
                public void onConfigLoad() {
                    TaskPillarTileEntity.this.checkedForReclaimTaskId = false;
                }
            });
        }
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            TeamTaskManager.removeTaskEventListener(this);
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            TeamTaskManager.removeTaskEventListener(this);
        }
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public Optional<Task> getTask(ServerPlayer serverPlayer) {
        if (serverPlayer.m_20194_() == null) {
            return Optional.empty();
        }
        TeamTaskData teamTaskData = TeamTaskData.get(serverPlayer.m_20194_());
        return this.getTask((Player)serverPlayer, teamTaskData, (Scoreboard)serverPlayer.m_20194_().m_129896_());
    }

    public Optional<Task> getTask(Player player, TeamTaskData teamTaskData, Scoreboard scoreboard) {
        PlayerTeam playerTeam = scoreboard.m_83500_(player.m_36316_().getName());
        if (playerTeam == null) {
            return Optional.empty();
        }
        TeamTaskData.TeamTasks teamTasks = teamTaskData.getTeamTasks(teamTaskData.getCompletedTaskTeam(this.taskId).orElse(playerTeam.m_5758_()));
        return teamTasks != null ? teamTasks.getTask(this.taskId) : Optional.empty();
    }

    public Optional<Task> getReclaimTask(Player player, TeamTaskData teamTaskData, Scoreboard scoreboard) {
        if (this.reclaimTaskId == null) {
            return Optional.empty();
        }
        PlayerTeam playerTeam = scoreboard.m_83500_(player.m_36316_().getName());
        if (playerTeam == null) {
            return Optional.empty();
        }
        TeamTaskData.TeamTasks teamTasks = teamTaskData.getTeamTasks(playerTeam.m_5758_());
        return teamTasks != null ? teamTasks.getTask(this.reclaimTaskId) : Optional.empty();
    }

    public CompoundTag m_5995_() {
        CompoundTag updateTag = super.m_5995_();
        this.saveData(updateTag);
        return updateTag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.saveData(tag);
    }

    private void saveData(CompoundTag tag) {
        if (this.taskId != null) {
            tag.m_128359_("TaskId", this.taskId);
        }
        if (this.reclaimTaskId != null) {
            tag.m_128359_("ReclaimTaskId", this.reclaimTaskId);
        }
        if (this.completedByTeam != null) {
            tag.m_128359_("CompletedByTeam", this.completedByTeam);
        }
        tag.m_128379_("ReplacedBlocksOnCompletion", this.replacedBlocksOnCompletion);
        tag.m_128405_("TintColor", this.lightsTintColor);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.taskId = tag.m_128461_("TaskId");
        this.reclaimTaskId = tag.m_128441_("ReclaimTaskId") ? tag.m_128461_("ReclaimTaskId") : null;
        this.completedByTeam = tag.m_128441_("CompletedByTeam") ? tag.m_128461_("CompletedByTeam") : null;
        this.replacedBlocksOnCompletion = tag.m_128471_("ReplacedBlocksOnCompletion");
        this.lightsTintColor = tag.m_128451_("TintColor");
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    @Override
    public boolean isForTask(String taskId) {
        return this.taskId != null && this.taskId.equals(taskId) || this.reclaimTaskId != null && this.reclaimTaskId.equals(taskId);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, TaskPillarTileEntity tile) {
        if (tile.taskId == null || tile.lastCompletionCheckTime + 5L > level.m_46467_() || !(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        tile.lastCompletionCheckTime = level.m_46467_();
        if (tile.completedByTeam != null) {
            TeamTaskData teamTaskData = TeamTaskData.get(serverLevel.m_142572_());
            teamTaskData.getCompletedTaskTeam(tile.reclaimTaskId).ifPresent(teamName -> {
                tile.completedByTeam = teamName;
                tile.taskId = tile.reclaimTaskId;
                tile.reclaimTaskId = null;
                tile.checkedForReclaimTaskId = false;
                tile.replacedBlocksOnCompletion = false;
            });
        } else {
            TeamTaskData teamTaskData = TeamTaskData.get(serverLevel.m_142572_());
            teamTaskData.getCompletedTaskTeam(tile.taskId).ifPresent(s -> {
                tile.completedByTeam = s;
            });
            tile.replacedBlocksOnCompletion = false;
        }
        if (!tile.checkedForReclaimTaskId) {
            tile.checkedForReclaimTaskId = true;
            ModConfigs.TEAM_TASKS.getNextTask(tile.taskId).ifPresentOrElse(nextTask -> {
                tile.reclaimTaskId = nextTask.getId();
                tile.m_6596_();
                level.m_7260_(pos, state, state, 3);
            }, () -> {
                tile.reclaimTaskId = null;
                tile.m_6596_();
                level.m_7260_(pos, state, state, 3);
            });
        }
        if (tile.replacedBlocksOnCompletion) {
            return;
        }
        TaskPillarTileEntity.placeBlocks(level, pos, state, tile, serverLevel);
    }

    private static void placeBlocks(Level level, BlockPos pos, BlockState state, TaskPillarTileEntity tile, ServerLevel serverLevel) {
        if (tile.completedByTeam == null) {
            return;
        }
        ServerScoreboard scoreboard = serverLevel.m_6188_();
        PlayerTeam team = scoreboard.m_83489_(tile.completedByTeam);
        if (team == null) {
            return;
        }
        TaskPillarTileEntity.placeBlocksBelow(level, pos, TaskPillarTileEntity.getBlockFromTeamColor(team.m_7414_()).m_49966_());
        tile.lightsTintColor = team.m_7414_().m_126665_() != null ? TaskPillarTileEntity.darkenColor(team.m_7414_().m_126665_()) : -1;
        tile.replacedBlocksOnCompletion = true;
        tile.m_6596_();
        level.m_7260_(pos, state, state, 3);
    }

    private static void placeBlocksBelow(Level level, BlockPos pos, BlockState stateToPlace) {
        BlockPos firstCorner = pos.m_7495_().m_142629_(Direction.Axis.X, -1).m_142629_(Direction.Axis.Z, -1);
        BlockPos secondCorner = firstCorner.m_142629_(Direction.Axis.X, 2).m_142629_(Direction.Axis.Z, 2);
        BlockPos.m_121940_((BlockPos)firstCorner, (BlockPos)secondCorner).forEach(p -> level.m_7731_(p, stateToPlace, 3));
    }

    private static int darkenColor(Integer color) {
        float ratio = 0.8f;
        int r = Math.min((int)Math.min((float)(color >> 16 & 0xFF) * ratio, 255.0f), 255);
        int g = Math.min((int)Math.min((float)(color >> 8 & 0xFF) * ratio, 255.0f), 255);
        int b = Math.min((int)Math.min((float)(color & 0xFF) * ratio, 255.0f), 255);
        return r << 16 | g << 8 | b;
    }

    private static Block getBlockFromTeamColor(ChatFormatting color) {
        return switch (color) {
            case ChatFormatting.WHITE -> Blocks.f_50542_;
            case ChatFormatting.BLACK -> Blocks.f_50505_;
            case ChatFormatting.DARK_PURPLE -> Blocks.f_50500_;
            case ChatFormatting.BLUE -> Blocks.f_50290_;
            case ChatFormatting.DARK_BLUE -> Blocks.f_50501_;
            case ChatFormatting.YELLOW -> Blocks.f_50494_;
            case ChatFormatting.GREEN -> Blocks.f_50495_;
            case ChatFormatting.DARK_GRAY -> Blocks.f_50497_;
            case ChatFormatting.GRAY -> Blocks.f_50498_;
            case ChatFormatting.AQUA -> Blocks.f_50545_;
            case ChatFormatting.DARK_AQUA -> Blocks.f_50499_;
            case ChatFormatting.LIGHT_PURPLE -> Blocks.f_50496_;
            case ChatFormatting.DARK_GREEN -> Blocks.f_50503_;
            case ChatFormatting.RED -> Blocks.f_50293_;
            case ChatFormatting.DARK_RED -> Blocks.f_50504_;
            default -> Blocks.f_50333_;
        };
    }

    public int getTintColor(int tintIndex) {
        return tintIndex == 1 ? this.lightsTintColor : -1;
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_(), this.m_58899_().m_142082_(1, 2, 1));
    }

    public String getTaskId() {
        return this.taskId;
    }

    public boolean hasReclaimTaskId() {
        return this.reclaimTaskId != null;
    }
}

