/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import com.mojang.math.Vector3f;
import iskallia.vault.block.entity.TotemTileEntity;
import iskallia.vault.client.particles.ColoredParticleOptions;
import iskallia.vault.client.particles.SphericalParticleOptions;
import iskallia.vault.entity.ITotemIgnore;
import iskallia.vault.event.ActiveFlags;
import iskallia.vault.gear.etching.EtchingGearAttributes;
import iskallia.vault.gear.etching.EtchingHelper;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModParticles;
import iskallia.vault.skill.ability.effect.TotemMobDamageAbility;
import iskallia.vault.util.EntityHelper;
import iskallia.vault.util.calc.AbilityPowerHelper;
import iskallia.vault.util.damage.PlayerDamageHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class TotemMobDamageTileEntity
extends TotemTileEntity {
    private static final Predicate<Entity> ENTITY_SELECTION_FILTER = entity -> {
        LivingEntity livingEntity;
        return !(entity instanceof Player) && entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_6084_() && livingEntity.f_19797_ > 5 && !livingEntity.m_21023_((MobEffect)ModEffects.TOTEM_MOB_DAMAGE);
    };
    private int damageIntervalTicks;
    private float damagePerInterval;
    private final List<LivingEntity> entityList = new ArrayList<LivingEntity>();
    public static final Vector3f PARTICLE_EFFECT_COLOR = new Vector3f(1.0f, 0.322f, 0.824f);
    private static final String TAG_DAMAGE_PER_INTERVAL = "damagePerInterval";
    private static final String TAG_DAMAGE_INTERVAL_TICKS = "damageIntervalTicks";

    public TotemMobDamageTileEntity(BlockPos blockPos, BlockState blockState) {
        super(ModBlocks.TOTEM_MOB_DAMAGE_TILE_ENTITY, blockPos, blockState);
    }

    public void initialize(UUID playerUUID, int durationTicks, float effectRadius, float damagePerInterval, int damageIntervalTicks) {
        super.initialize(playerUUID, durationTicks, effectRadius);
        this.damagePerInterval = damagePerInterval;
        this.damageIntervalTicks = damageIntervalTicks;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, TotemMobDamageTileEntity tile) {
        tile.serverTick();
    }

    @Override
    protected boolean serverTick() {
        if (!super.serverTick() || this.f_58857_ == null) {
            this.entityList.clear();
            return false;
        }
        EntityHelper.getEntitiesInRange((LevelAccessor)this.f_58857_, this.getEffectBounds(), this.getEffectOrigin(), this.getEffectRadius(), ENTITY_SELECTION_FILTER, this.entityList);
        if (!this.entityList.isEmpty()) {
            Player player = this.f_58857_.m_46003_(this.getPlayerUUID());
            if (player == null) {
                return false;
            }
            this.updateEffects(this.entityList, this.damageIntervalTicks);
            this.hurtEntities(this.entityList, player, this.damagePerInterval);
            this.entityList.clear();
        }
        return true;
    }

    private void hurtEntities(List<LivingEntity> entityList, Player player, float damagePercent) {
        float abilityDamage = AbilityPowerHelper.getAbilityPower(player);
        float[] adBonus = new float[]{0.0f};
        EtchingHelper.getEtchings((LivingEntity)player, EtchingGearAttributes.TOTEM_MOB_DAMAGE_AD).stream().findFirst().ifPresent(stack -> {
            float attack = (float)player.m_21133_(Attributes.f_22281_);
            adBonus[0] = adBonus[0] + (attack *= PlayerDamageHelper.getDamageMultiplier(player, true, false)) * ((Float)stack.getValue()).floatValue();
        });
        float damage = (abilityDamage + adBonus[0]) * damagePercent;
        ActiveFlags.IS_AP_ATTACKING.runIfNotSet(() -> ActiveFlags.IS_TOTEM_ATTACKING.runIfNotSet(() -> {
            for (LivingEntity livingEntity : entityList) {
                ITotemIgnore ignore;
                if (livingEntity instanceof ITotemIgnore && (ignore = (ITotemIgnore)livingEntity).isTotemIgnored()) continue;
                Vec3 movement = livingEntity.m_20184_();
                livingEntity.m_6469_(DamageSource.m_19344_((Player)player), damage);
                livingEntity.m_20256_(movement);
            }
        }));
    }

    private void updateEffects(List<LivingEntity> entityList, int damageIntervalTicks) {
        for (LivingEntity livingEntity : entityList) {
            ITotemIgnore ignore;
            if (livingEntity instanceof ITotemIgnore && (ignore = (ITotemIgnore)livingEntity).isTotemIgnored()) continue;
            TotemMobDamageAbility.TotemMobDamageEffect.addTo(livingEntity, damageIntervalTicks);
        }
    }

    @Nonnull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Override
    public Vector3f getParticleEffectColor() {
        return PARTICLE_EFFECT_COLOR;
    }

    @Override
    public ParticleOptions getFountainParticleOptions() {
        return new ColoredParticleOptions((ParticleType<ColoredParticleOptions>)((ParticleType)ModParticles.TOTEM_FOUNTAIN.get()), PARTICLE_EFFECT_COLOR);
    }

    @Override
    protected ParticleOptions getEffectRangeParticleOptions(float effectRadius) {
        return new SphericalParticleOptions((ParticleType<SphericalParticleOptions>)((ParticleType)ModParticles.TOTEM_EFFECT_RANGE.get()), effectRadius, PARTICLE_EFFECT_COLOR);
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag tag) {
        this.damagePerInterval = tag.m_128457_(TAG_DAMAGE_PER_INTERVAL);
        this.damageIntervalTicks = tag.m_128451_(TAG_DAMAGE_INTERVAL_TICKS);
        super.m_142466_(tag);
    }

    @Override
    protected void m_183515_(@Nonnull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128350_(TAG_DAMAGE_PER_INTERVAL, this.damagePerInterval);
        tag.m_128405_(TAG_DAMAGE_INTERVAL_TICKS, this.damageIntervalTicks);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    protected RenderContext createRenderContext() {
        return new RenderContext();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class RenderContext
    extends TotemTileEntity.RenderContext {
        public List<LivingEntity> targetList;
    }
}

