/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import com.mojang.math.Vector3f;
import iskallia.vault.block.entity.TotemTileEntity;
import iskallia.vault.client.particles.ColoredParticleOptions;
import iskallia.vault.client.particles.SphericalParticleOptions;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModParticles;
import iskallia.vault.skill.ability.effect.TotemAbility;
import iskallia.vault.util.MathUtilities;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TotemPlayerHealthTileEntity
extends TotemTileEntity {
    private float healthPerTick;
    private final List<Player> playerList = new ArrayList<Player>();
    public static final Vector3f PARTICLE_EFFECT_COLOR = new Vector3f(0.533f, 1.0f, 0.0f);
    private static final String TAG_HEALTH_PER_TICK = "healthPerTick";

    public TotemPlayerHealthTileEntity(BlockPos blockPos, BlockState blockState) {
        super(ModBlocks.TOTEM_PLAYER_HEALTH_TILE_ENTITY, blockPos, blockState);
    }

    public void initialize(UUID playerUUID, int durationTicks, float effectRadius, float healthPerSecond) {
        super.initialize(playerUUID, durationTicks, effectRadius);
        this.healthPerTick = healthPerSecond / 20.0f;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, TotemPlayerHealthTileEntity tile) {
        tile.serverTick();
    }

    @Override
    protected boolean serverTick() {
        if (!super.serverTick()) {
            this.playerList.clear();
            return false;
        }
        this.getPlayersInRange(this.getEffectBounds(), this.getEffectOrigin(), this.getEffectRadius(), this.playerList);
        this.updatePlayerEffect(this.playerList, this.healthPerTick);
        this.playerList.clear();
        return true;
    }

    private void updatePlayerEffect(List<Player> playerList, float healthPerTick) {
        for (Player player : playerList) {
            TotemAbility.TotemPlayerHealthEffect.addTo((LivingEntity)player, healthPerTick);
        }
    }

    private void getPlayersInRange(AABB area, Vec3 center, float range, List<Player> result) {
        if (this.f_58857_ == null) {
            return;
        }
        for (Player player : this.f_58857_.m_6907_()) {
            if (!area.m_82390_(player.m_20182_()) || !MathUtilities.isAABBIntersectingOrInsideSphere(player.m_142469_(), center, range)) continue;
            result.add(player);
        }
    }

    @Override
    public Vector3f getParticleEffectColor() {
        return PARTICLE_EFFECT_COLOR;
    }

    @Override
    protected ParticleOptions getFountainParticleOptions() {
        return new ColoredParticleOptions((ParticleType<ColoredParticleOptions>)((ParticleType)ModParticles.TOTEM_FOUNTAIN.get()), PARTICLE_EFFECT_COLOR);
    }

    @Override
    protected ParticleOptions getEffectRangeParticleOptions(float effectRadius) {
        return new SphericalParticleOptions((ParticleType<SphericalParticleOptions>)((ParticleType)ModParticles.TOTEM_EFFECT_RANGE.get()), effectRadius, PARTICLE_EFFECT_COLOR);
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag tag) {
        this.healthPerTick = tag.m_128457_(TAG_HEALTH_PER_TICK);
        super.m_142466_(tag);
    }

    @Override
    protected void m_183515_(@Nonnull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128350_(TAG_HEALTH_PER_TICK, this.healthPerTick);
    }
}

