/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import com.mojang.math.Vector3f;
import iskallia.vault.core.world.storage.IZonedWorld;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class TotemTileEntity
extends BlockEntity {
    protected static final int RANGE_PARTICLE_MINIMUM = 10;
    protected static final int RANGE_PARTICLE_MAXIMUM = 200;
    protected static final int UPDATE_INTERVAL_TICKS = 2;
    private int remainingDurationTicks;
    private float effectRadius;
    private int nextUpdateTick;
    private UUID playerUUID;
    private Vec3 effectOrigin = new Vec3((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5);
    private AABB effectBounds;
    protected static final String TAG_REMAINING_DURATION_TICKS = "remainingDurationTicks";
    protected static final String TAG_EFFECT_RADIUS = "effectRadius";
    protected static final String TAG_NEXT_UPDATE_TICK = "nextUpdateTick";
    private static final String TAG_PLAYER_UUID = "playerUUID";
    @OnlyIn(value=Dist.CLIENT)
    private RenderContext renderContext;

    public TotemTileEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    protected void initialize(UUID playerUUID, int durationTicks, float effectRadius) {
        this.playerUUID = playerUUID;
        this.remainingDurationTicks = durationTicks;
        this.effectRadius = effectRadius;
        this.resetUpdateCounter();
        this.updateEffectBounds();
    }

    protected void updateEffectBounds() {
        this.effectBounds = new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).m_82338_(this.m_58899_()).m_82400_((double)(this.getEffectRadius() + 2.0f));
    }

    protected void resetUpdateCounter() {
        this.nextUpdateTick = this.getUpdateIntervalTicks();
    }

    protected int getRemainingDurationTicks() {
        return this.remainingDurationTicks;
    }

    protected int decrementUpdateCounter(int ticks) {
        return this.nextUpdateTick -= ticks;
    }

    public float getEffectRadius() {
        return this.effectRadius;
    }

    protected int getUpdateIntervalTicks() {
        return 2;
    }

    public AABB getEffectBounds() {
        if (this.effectBounds == null) {
            this.updateEffectBounds();
        }
        return this.effectBounds;
    }

    public Vec3 getEffectOrigin() {
        return this.effectOrigin;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    protected boolean serverTick() {
        if (--this.remainingDurationTicks <= 0) {
            this.removeTotem();
            return false;
        }
        this.doParticles();
        this.doAmbientSound();
        return true;
    }

    protected void removeTotem() {
        if (this.f_58857_ == null) {
            return;
        }
        BlockPos blockPos = this.m_58899_();
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, 25, 0.25, 0.25, 0.25, 0.0);
            serverLevel.m_6263_(null, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), SoundEvents.f_11738_, SoundSource.PLAYERS, 0.5f, 2.0f);
        }
        IZonedWorld.runWithBypass(this.f_58857_, true, () -> this.f_58857_.m_46597_(blockPos, Blocks.f_50016_.m_49966_()));
    }

    protected void doParticles() {
        Level level;
        if (this.getRemainingDurationTicks() % 5 == 0 && (level = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos blockPos = this.m_58899_();
            this.doFountainParticles(serverLevel, blockPos);
            this.doEffectRangeParticles(serverLevel, blockPos);
        }
    }

    protected abstract ParticleOptions getFountainParticleOptions();

    private void doFountainParticles(ServerLevel serverLevel, BlockPos blockPos) {
        serverLevel.m_8767_(this.getFountainParticleOptions(), (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.7, (double)blockPos.m_123343_() + 0.5, 5, 0.075, 0.0, 0.075, 0.0);
    }

    protected abstract ParticleOptions getEffectRangeParticleOptions(float var1);

    private void doEffectRangeParticles(ServerLevel serverLevel, BlockPos blockPos) {
        serverLevel.m_8767_(this.getEffectRangeParticleOptions(this.effectRadius), (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, this.getEffectRangeParticleCount(), 0.0, 0.0, 0.0, 0.0);
    }

    protected int getEffectRangeParticleCount() {
        return Mth.m_14045_((int)((int)(Math.PI * 4 * (double)this.effectRadius * (double)this.effectRadius * 0.166666)), (int)10, (int)200);
    }

    public abstract Vector3f getParticleEffectColor();

    protected void doAmbientSound() {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.remainingDurationTicks >= 40 && this.f_58857_.m_46467_() % 40L == 0L) {
            BlockPos blockPos = this.m_58899_();
            this.f_58857_.m_6263_(null, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), SoundEvents.f_11737_, SoundSource.BLOCKS, 0.5f, 2.0f);
        }
    }

    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        this.remainingDurationTicks = tag.m_128451_(TAG_REMAINING_DURATION_TICKS);
        this.effectRadius = tag.m_128457_(TAG_EFFECT_RADIUS);
        this.nextUpdateTick = tag.m_128451_(TAG_NEXT_UPDATE_TICK);
        this.playerUUID = tag.m_128441_(TAG_PLAYER_UUID) ? tag.m_128342_(TAG_PLAYER_UUID) : null;
        this.updateEffectBounds();
    }

    protected void m_183515_(@Nonnull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_(TAG_REMAINING_DURATION_TICKS, this.remainingDurationTicks);
        tag.m_128350_(TAG_EFFECT_RADIUS, this.effectRadius);
        tag.m_128405_(TAG_NEXT_UPDATE_TICK, this.nextUpdateTick);
        if (this.playerUUID != null) {
            tag.m_128362_(TAG_PLAYER_UUID, this.playerUUID);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public <R extends RenderContext> R getRenderContext() {
        if (this.renderContext == null) {
            this.renderContext = this.createRenderContext();
        }
        return (R)this.renderContext;
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    protected RenderContext createRenderContext() {
        return new RenderContext();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class RenderContext {
        public float rotationAngleRadians;
        public int[] glyphIndices;
    }
}

