/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.block.entity.base.FilteredInputInventoryTileEntity;
import iskallia.vault.container.TransmogTableContainer;
import iskallia.vault.container.inventory.TransmogTableInventory;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModBlocks;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransmogTableTileEntity
extends BlockEntity
implements MenuProvider,
FilteredInputInventoryTileEntity {
    protected TransmogTableInventory internalInventory = new TransmogTableInventory(this){

        @Override
        public void m_6596_() {
            super.m_6596_();
            TransmogTableTileEntity.this.m_6596_();
        }

        public boolean m_7013_(int slot, ItemStack stack) {
            if (slot == 0) {
                if (!(stack.m_41720_() instanceof VaultGearItem)) {
                    return false;
                }
                VaultGearData data = VaultGearData.read(stack);
                return data.getState() == VaultGearState.IDENTIFIED && data.getRarity() != VaultGearRarity.UNIQUE;
            }
            if (slot == 1) {
                return stack.m_41720_() == ModBlocks.VAULT_BRONZE.m_5456_();
            }
            return false;
        }
    };

    public TransmogTableTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.TRANSMOG_TABLE_TILE_ENTITY, pos, state);
    }

    public TransmogTableInventory getInternalInventory() {
        return this.internalInventory;
    }

    public AbstractContainerMenu m_7208_(int containerId, @NotNull Inventory inv, @NotNull Player player) {
        if (this.m_58904_() == null) {
            return null;
        }
        return new TransmogTableContainer(containerId, this.m_58904_(), this.m_58899_(), inv);
    }

    @Override
    public boolean isInventorySideAccessible(@Nullable Direction side) {
        return true;
    }

    public boolean stillValid(@NotNull Player player) {
        if (this.f_58857_ == null || this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return this.internalInventory.m_6542_(player);
    }

    public void m_6596_() {
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
            super.m_6596_();
        }
    }

    public void m_142466_(@Nonnull CompoundTag compound) {
        super.m_142466_(compound);
        super.m_142466_(compound);
        if (compound.m_128441_("Items")) {
            TransmogTableTileEntity.loadAllItems(compound, this.internalInventory);
        } else {
            this.internalInventory.load(compound);
        }
    }

    protected void m_183515_(@Nonnull CompoundTag tag) {
        super.m_183515_(tag);
        this.internalInventory.save(tag);
    }

    private static void loadAllItems(CompoundTag pTag, Container inventory) {
        ListTag listtag = pTag.m_128437_("Items", 10);
        for (int i = 0; i < listtag.size(); ++i) {
            CompoundTag compoundtag = listtag.m_128728_(i);
            int j = compoundtag.m_128445_("Slot") & 0xFF;
            if (j < 0 || j >= inventory.m_6643_()) continue;
            inventory.m_6836_(j, ItemStack.m_41712_((CompoundTag)compoundtag));
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Nonnull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.getFilteredInputCapability(side, new Container[]{this.internalInventory});
        }
        return super.getCapability(cap, side);
    }

    @NotNull
    public Component m_5446_() {
        return new TranslatableComponent("container.the_vault.transmog_table");
    }
}

