/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.block.base.LootableTileEntity;
import iskallia.vault.init.ModBlocks;
import java.awt.Color;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TreasurePedestalTileEntity
extends LootableTileEntity {
    private static final Random rand = new Random();
    private ItemStack contained = ItemStack.f_41583_;
    private boolean vaultPedestal;

    public TreasurePedestalTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.TREASURE_PEDESTAL_TILE_ENTITY, pos, state);
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_, this.f_58858_.m_142082_(1, 1, 1)).m_82400_(5.0);
    }

    public static void tick(Level world, BlockPos pos, BlockState state, TreasurePedestalTileEntity tile) {
        if (world.m_5776_()) {
            TreasurePedestalTileEntity.clientTick(world, pos, state, tile);
            return;
        }
        if (tile.contained.m_41619_() && tile.getLootTable() != null && tile.isVaultPedestal()) {
            List<ItemStack> generatedStacks = tile.generateLoot(null);
            tile.setLootTable(null);
            tile.contained = generatedStacks.stream().filter(stack -> !stack.m_41619_()).findFirst().orElse(ItemStack.f_41583_);
            tile.m_6596_();
            world.m_7260_(pos, state, state, 3);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void clientTick(Level world, BlockPos pos, BlockState state, TreasurePedestalTileEntity tile) {
        if (tile.contained.m_41619_()) {
            return;
        }
        if (rand.nextInt(3) != 0 && tile.contained != null && !tile.contained.m_41619_()) {
            return;
        }
        if (rand.nextInt(5) != 0 && tile.contained == null) {
            return;
        }
        ParticleEngine engine = Minecraft.m_91087_().f_91061_;
        double x = (double)pos.m_123341_() + 0.5 + (double)(rand.nextFloat() * 1.0f * (float)(rand.nextBoolean() ? 1 : -1));
        double y = (double)pos.m_123342_() + 2.0 + (double)(rand.nextFloat() * 1.0f * (float)(rand.nextBoolean() ? 1 : -1));
        double z = (double)pos.m_123343_() + 0.5 + (double)(rand.nextFloat() * 1.0f * (float)(rand.nextBoolean() ? 1 : -1));
        float hueGold = 0.125f;
        int color = Color.HSBtoRGB(hueGold, 0.2f + rand.nextFloat() * 0.6f, 1.0f);
        if (rand.nextInt(3) == 0 && tile.contained != null && !tile.contained.m_41619_()) {
            x = (double)pos.m_123341_() + 0.5;
            y = (double)pos.m_123342_() + 1.5;
            z = (double)pos.m_123343_() + 0.5;
        }
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        SimpleAnimatedParticle particle = (SimpleAnimatedParticle)engine.m_107370_((ParticleOptions)ParticleTypes.f_123815_.m_6012_(), x, y, z, (double)(rand.nextFloat() * 0.02f * (float)(rand.nextBoolean() ? 1 : -1)), (double)(rand.nextFloat() * 0.04f), (double)(rand.nextFloat() * 0.02f * (float)(rand.nextBoolean() ? 1 : -1)));
        if (particle != null) {
            particle.m_107253_(r, g, b);
        }
    }

    public ItemStack getContained() {
        return this.contained.m_41777_();
    }

    public void setContained(ItemStack contained) {
        this.contained = contained;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.contained = ItemStack.m_41712_((CompoundTag)tag.m_128469_("contained"));
        this.vaultPedestal = tag.m_128425_("LootTable", 8) && !tag.m_128461_("LootTable").isBlank();
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("contained", (Tag)this.contained.serializeNBT());
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public boolean isVaultPedestal() {
        return this.vaultPedestal;
    }

    public void setVaultPedestal(boolean vaultPedestal) {
        this.vaultPedestal = vaultPedestal;
        this.m_6596_();
    }
}

