/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.block.base.LootableTileEntity;
import iskallia.vault.block.entity.base.TemplateTagContainer;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.util.MiscUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TreasureSandTileEntity
extends LootableTileEntity
implements TemplateTagContainer {
    private static final Random rand = new Random();
    private final List<String> templateTags = new ArrayList<String>();

    public TreasureSandTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.TREASURE_SAND_TILE_ENTITY, pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, TreasureSandTileEntity tile) {
        if (level.m_5776_()) {
            TreasureSandTileEntity.clientTick(level, pos, state, tile);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void clientTick(Level level, BlockPos pos, BlockState state, TreasureSandTileEntity tile) {
        if (rand.nextInt(14) != 0) {
            return;
        }
        if (MiscUtils.getClientDistance((Vec3i)pos) > 48.0) {
            return;
        }
        boolean hasEmptyBlockAround = false;
        for (Direction dir : Direction.values()) {
            BlockPos offsetPos = pos.m_142300_(dir);
            if (!level.m_46859_(offsetPos)) continue;
            hasEmptyBlockAround = true;
            break;
        }
        if (!hasEmptyBlockAround) {
            return;
        }
        ParticleEngine engine = Minecraft.m_91087_().f_91061_;
        float hueGold = 0.125f;
        int color = Color.HSBtoRGB(hueGold, 0.2f + rand.nextFloat() * 0.6f, 1.0f);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        SimpleAnimatedParticle particle = (SimpleAnimatedParticle)engine.m_107370_((ParticleOptions)ParticleTypes.f_123815_.m_6012_(), (double)pos.m_123341_() + 0.5 + (double)(rand.nextFloat() * (float)(rand.nextBoolean() ? 1 : -1)), (double)pos.m_123342_() + 0.5 + (double)(rand.nextFloat() * (float)(rand.nextBoolean() ? 1 : -1)), (double)pos.m_123343_() + 0.5 + (double)(rand.nextFloat() * (float)(rand.nextBoolean() ? 1 : -1)), 0.0, (double)(rand.nextFloat() * 0.01f), 0.0);
        if (particle != null) {
            particle.m_107253_(r, g, b);
        }
    }

    @Override
    public List<String> getTemplateTags() {
        return Collections.unmodifiableList(this.templateTags);
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.templateTags.clear();
        this.templateTags.addAll(this.loadTemplateTags(nbt));
    }

    @Override
    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        this.saveTemplateTags(nbt);
    }
}

