/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import com.mojang.math.Vector3f;
import iskallia.vault.VaultMod;
import iskallia.vault.altar.AltarInfusionRecipe;
import iskallia.vault.altar.RequiredItems;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.event.event.CraftCrystalEvent;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.item.crystal.properties.CapacityCrystalProperties;
import iskallia.vault.item.crystal.properties.CrystalProperties;
import iskallia.vault.network.message.ClientboundUpdateAltarIndexMessage;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.expertise.type.MysticExpertise;
import iskallia.vault.skill.prestige.SuperCrystalsPrestigePower;
import iskallia.vault.world.data.PlayerExpertisesData;
import iskallia.vault.world.data.PlayerPrestigePowersData;
import iskallia.vault.world.data.PlayerStatsData;
import iskallia.vault.world.data.PlayerVaultAltarData;
import iskallia.vault.world.data.PlayerVaultStatsData;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkDirection;
import org.jetbrains.annotations.NotNull;

public class VaultAltarTileEntity
extends BlockEntity {
    private UUID owner;
    private ItemStack input = ItemStack.f_41583_;
    private AltarInfusionRecipe recipe;
    private AltarState altarState;
    private HashMap<String, Integer> displayedIndex = new HashMap();
    private int infusionTimer = -666;

    public VaultAltarTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.VAULT_ALTAR_TILE_ENTITY, pos, state);
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public AltarInfusionRecipe getRecipe() {
        return this.recipe;
    }

    public void setRecipe(AltarInfusionRecipe recipe) {
        this.recipe = recipe;
    }

    public AltarState getAltarState() {
        return this.altarState;
    }

    public void setAltarState(AltarState state) {
        this.altarState = state;
    }

    public int getInfusionTimer() {
        return this.infusionTimer;
    }

    public HashMap<String, Integer> getDisplayedIndex() {
        return this.displayedIndex;
    }

    public void setDisplayedIndex(HashMap<String, Integer> displayedIndex) {
        this.displayedIndex = displayedIndex;
    }

    public void sendUpdates() {
        if (this.f_58857_ == null) {
            return;
        }
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        this.m_6596_();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, VaultAltarTileEntity altar) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (altar.altarState == AltarState.IDLE) {
            return;
        }
        PlayerVaultAltarData altarData = PlayerVaultAltarData.get(serverLevel);
        altar.recipe = altarData.getRecipe(altar.owner);
        if (altar.recipe != null && altar.recipe.isComplete() && altar.altarState != AltarState.INFUSING) {
            altar.altarState = AltarState.COMPLETE;
        }
        if (altar.altarState == AltarState.ACCEPTING) {
            if (serverLevel.m_46467_() % (long)ModConfigs.VAULT_ALTAR.GROUP_DISPLAY_TICKS == 0L) {
                altar.updateDisplayedItems();
            }
            altar.pullNearbyItems(serverLevel, ModConfigs.VAULT_ALTAR.ITEM_RANGE_CHECK);
        } else if (altar.altarState == AltarState.INFUSING) {
            altar.playInfusionEffects(serverLevel);
            if (altar.infusionTimer-- <= 0) {
                altar.completeInfusion(level);
            }
        }
    }

    private void updateDisplayedItems() {
        if (this.m_58904_() == null) {
            return;
        }
        AltarInfusionRecipe infusionRecipe = this.getRecipe();
        if (infusionRecipe == null) {
            return;
        }
        this.updateDisplayedIndex(infusionRecipe);
        ServerLevel level = (ServerLevel)this.m_58904_();
        List players = level.m_6443_(Player.class, this.getAABB(120.0), player -> player instanceof ServerPlayer);
        players.stream().map(player -> (ServerPlayer)player).forEach(player -> ModNetwork.CHANNEL.sendTo((Object)new ClientboundUpdateAltarIndexMessage(this.m_58899_(), this.getDisplayedIndex()), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT));
    }

    private void updateDisplayedIndex(AltarInfusionRecipe infusionRecipe) {
        List<RequiredItems> items = infusionRecipe.getRequiredItems();
        for (RequiredItems required : items) {
            String id = required.getPoolId();
            List<ItemStack> stacks = required.getItems();
            int index = this.displayedIndex.computeIfAbsent(id, poolId -> 0);
            this.displayedIndex.put(id, index + 1 >= stacks.size() ? 0 : index + 1);
        }
    }

    public void onAltarPowered() {
        ServerLevel serverWorld;
        block3: {
            block2: {
                Level level = this.f_58857_;
                if (!(level instanceof ServerLevel)) break block2;
                serverWorld = (ServerLevel)level;
                if (this.getAltarState() == AltarState.COMPLETE) break block3;
            }
            return;
        }
        PlayerVaultAltarData.get(serverWorld).getAltars(this.owner).stream().filter(pos -> this.f_58857_.m_46749_(pos)).forEach(altarPos -> {
            VaultAltarTileEntity altar;
            BlockEntity te;
            if (!this.m_58899_().equals(altarPos) && (te = this.f_58857_.m_7702_(altarPos)) instanceof VaultAltarTileEntity && (altar = (VaultAltarTileEntity)te).getAltarState() != AltarState.IDLE) {
                altar.onRemoveInput(this.owner);
            }
        });
        serverWorld.m_6263_(null, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), SoundEvents.f_11736_, SoundSource.BLOCKS, 1.0f, 0.5f);
        this.infusionTimer = ModConfigs.VAULT_ALTAR.INFUSION_TIME * 20;
        this.altarState = AltarState.INFUSING;
        this.sendUpdates();
    }

    public InteractionResult onAddInput(ServerPlayer player, ItemStack input) {
        if (this.f_58857_ == null || !this.owner.equals(player.m_142081_())) {
            return InteractionResult.FAIL;
        }
        ServerLevel serverLevel = (ServerLevel)this.f_58857_;
        List<BlockPos> altarPositions = PlayerVaultAltarData.get(serverLevel).getAltars(player.m_142081_());
        for (BlockPos altarPosition : altarPositions) {
            BlockEntity te;
            if (!serverLevel.m_46749_(altarPosition) || !((te = serverLevel.m_7702_(altarPosition)) instanceof VaultAltarTileEntity)) continue;
            VaultAltarTileEntity altar = (VaultAltarTileEntity)te;
            if (altar.altarState != AltarState.INFUSING) continue;
            return InteractionResult.FAIL;
        }
        PlayerVaultAltarData altarData = PlayerVaultAltarData.get(serverLevel);
        this.recipe = altarData.getRecipe(player, this.f_58858_);
        this.updateDisplayedIndex(this.recipe);
        this.setAltarState(AltarState.ACCEPTING);
        this.input = input.m_41777_();
        this.input.m_41764_(1);
        if (!player.m_7500_()) {
            input.m_41774_(1);
        }
        this.sendUpdates();
        return InteractionResult.SUCCESS;
    }

    public InteractionResult onRemoveInput(UUID playerId) {
        if (!this.owner.equals(playerId)) {
            return InteractionResult.FAIL;
        }
        this.setAltarState(AltarState.IDLE);
        this.recipe = null;
        this.infusionTimer = -666;
        if (this.m_58904_() != null) {
            this.m_58904_().m_7967_((Entity)new ItemEntity(this.m_58904_(), (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 1.5, (double)this.m_58899_().m_123343_() + 0.5, this.input));
        }
        this.sendUpdates();
        return InteractionResult.SUCCESS;
    }

    private void completeInfusion(Level world) {
        if (this.recipe == null) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)world;
        ItemStack stack = this.createOutput(serverLevel);
        serverLevel.m_7967_((Entity)new ItemEntity(world, (double)this.m_58899_().m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.5, (double)this.f_58858_.m_123343_() + 0.5, stack));
        PlayerStatsData.get(serverLevel.m_142572_()).onCrystalCrafted(this.owner, this.recipe.getRequiredItems());
        this.resetAltar(serverLevel);
        this.playCompletionEffects(serverLevel);
        MinecraftForge.EVENT_BUS.post((Event)new CraftCrystalEvent(serverLevel.m_46003_(this.owner)));
        this.sendUpdates();
    }

    @NotNull
    private ItemStack createOutput(ServerLevel serverLevel) {
        ItemStack stack = ModConfigs.VAULT_ALTAR.getOutput(this.input, this.owner).orElse(ItemStack.f_41583_);
        if (stack.m_41720_() == ModItems.VAULT_CRYSTAL) {
            CrystalData crystal = CrystalData.read(stack);
            int level = PlayerVaultStatsData.get(serverLevel).getVaultStats(this.owner).getVaultLevel();
            if (crystal.getProperties().getLevel().isEmpty()) {
                CapacityCrystalProperties capacityCrystalProperties;
                crystal.getProperties().setLevel(level);
                CrystalProperties crystalProperties = crystal.getProperties();
                if (crystalProperties instanceof CapacityCrystalProperties && (capacityCrystalProperties = (CapacityCrystalProperties)crystalProperties).getVolume().isEmpty() && this.f_58857_ != null) {
                    ModConfigs.VAULT_CRYSTAL.getRandomProperties(VaultMod.id("default"), level).ifPresent(properties -> {
                        if (properties instanceof CapacityCrystalProperties) {
                            CapacityCrystalProperties capacityProperties = (CapacityCrystalProperties)properties;
                            capacityProperties.getVolume().ifPresent(volume -> {
                                int additionalVolume = 0;
                                additionalVolume += PlayerExpertisesData.get(serverLevel).getExpertises(this.owner).getAll(MysticExpertise.class, Skill::isUnlocked).stream().mapToInt(MysticExpertise::getAdditionalCrystalVolume).sum();
                                capacityCrystalProperties.setVolume(volume + (additionalVolume += PlayerPrestigePowersData.get(serverLevel).getPowers(this.owner).getAll(SuperCrystalsPrestigePower.class, Skill::isUnlocked).stream().mapToInt(SuperCrystalsPrestigePower::getExtraCapacity).sum()));
                            });
                        }
                    });
                }
                crystal.write(stack);
            }
        }
        return stack;
    }

    private void playInfusionEffects(ServerLevel world) {
        float speed = (float)this.infusionTimer * 0.01f - 0.5f;
        if (speed > 0.0f) {
            world.m_8767_((ParticleOptions)ParticleTypes.f_123760_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 1.6, (double)this.m_58899_().m_123343_() + 0.5, 3, 0.0, 0.0, 0.0, (double)speed);
        }
    }

    private void playCompletionEffects(ServerLevel serverLevel) {
        DustParticleOptions particleData = new DustParticleOptions(new Vector3f(0.0f, 1.0f, 0.0f), 1.0f);
        for (int i = 0; i < 10; ++i) {
            float offset = 0.1f * (float)i;
            if (serverLevel.f_46441_.nextFloat() < 0.5f) {
                offset *= -1.0f;
            }
            serverLevel.m_8767_((ParticleOptions)particleData, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.6, (double)this.f_58858_.m_123343_() + 0.5, 10, (double)offset, (double)offset, (double)offset, 1.0);
        }
        serverLevel.m_6263_(null, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), SoundEvents.f_12275_, SoundSource.BLOCKS, 0.7f, 1.5f);
    }

    private void resetAltar(ServerLevel world) {
        this.infusionTimer = -666;
        this.altarState = AltarState.IDLE;
        PlayerVaultAltarData.get(world).removeRecipe(this.owner);
        this.recipe = null;
    }

    private void pullNearbyItems(ServerLevel level, double range) {
        if (this.recipe == null) {
            return;
        }
        List entities = level.m_45976_(ItemEntity.class, this.getAABB(range));
        for (ItemEntity itemEntity : entities) {
            ItemStack stack = itemEntity.m_32055_();
            if (!this.isItemValid(stack)) continue;
            List<RequiredItems> itemsToPull = this.recipe.getRequiredItems();
            itemsToPull.stream().filter(required -> !required.isComplete()).filter(required -> required.getItems().stream().anyMatch(itemStack -> ItemStack.m_41758_((ItemStack)itemStack, (ItemStack)stack))).forEach(required -> {
                this.moveItemTowardPedestal(itemEntity);
                if (this.isItemInRange(itemEntity.m_142538_())) {
                    this.incrementRequiredItems(itemEntity, (RequiredItems)required);
                }
            });
        }
    }

    public boolean isItemValid(ItemStack stack) {
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        AltarInfusionRecipe altarInfusionRecipe = PlayerVaultAltarData.get(serverLevel).getRecipe(this.owner);
        if (altarInfusionRecipe == null) {
            return false;
        }
        if (altarInfusionRecipe.isComplete()) {
            return false;
        }
        return altarInfusionRecipe.getRequiredItems().stream().filter(requiredItem -> !requiredItem.isComplete()).map(RequiredItems::getItems).flatMap(Collection::stream).anyMatch(requiredStack -> ItemStack.m_41758_((ItemStack)stack, (ItemStack)requiredStack));
    }

    private void incrementRequiredItems(ItemEntity itemEntity, RequiredItems requiredItems) {
        int excess = requiredItems.getRemainder(itemEntity.m_32055_().m_41613_());
        if (excess > 0) {
            requiredItems.setCurrentAmount(requiredItems.getAmountRequired());
            itemEntity.m_32055_().m_41764_(excess);
        } else {
            requiredItems.addAmount(itemEntity.m_32055_().m_41613_());
            itemEntity.m_32055_().m_41764_(excess);
            itemEntity.m_146870_();
        }
        this.sendUpdates();
        PlayerVaultAltarData.get().m_77762_();
    }

    private void moveItemTowardPedestal(ItemEntity itemEntity) {
        float speed = ModConfigs.VAULT_ALTAR.PULL_SPEED / 20.0f;
        Vec3 target = Vec3.m_82512_((Vec3i)this.m_58899_());
        Vec3 current = itemEntity.m_20182_();
        Vec3 velocity = target.m_82546_(current).m_82541_().m_82490_((double)speed);
        itemEntity.m_5997_(velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
    }

    private boolean isItemInRange(BlockPos itemPos) {
        return itemPos.m_123331_((Vec3i)this.m_58899_()) <= 4.0;
    }

    public AABB getAABB(double range) {
        return new AABB((double)this.m_58899_().m_123341_() + 0.5 - range, (double)this.m_58899_().m_123342_() + 0.5 - range, (double)this.m_58899_().m_123343_() + 0.5 - range, (double)this.m_58899_().m_123341_() + 0.5 + range, (double)this.m_58899_().m_123342_() + 0.5 + range, (double)this.m_58899_().m_123343_() + 0.5 + range);
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        if (this.altarState != null) {
            tag.m_128405_("AltarState", this.altarState.ordinal());
        }
        if (this.owner != null) {
            tag.m_128362_("Owner", this.owner);
        }
        if (this.recipe != null) {
            tag.m_128365_("Recipe", (Tag)this.recipe.serializeNBT());
        }
        tag.m_128405_("InfusionTimer", this.infusionTimer);
        CompoundTag displayed = new CompoundTag();
        this.displayedIndex.forEach((arg_0, arg_1) -> ((CompoundTag)displayed).m_128405_(arg_0, arg_1));
        tag.m_128365_("Displayed", (Tag)displayed);
        Adapters.ITEM_STACK.writeNbt(this.input).ifPresent(input -> tag.m_128365_("Input", input));
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        if (!tag.m_128441_("AltarState")) {
            this.migrate(tag.m_128471_("containsVaultRock"));
        }
        if (tag.m_128441_("AltarState")) {
            this.altarState = AltarState.values()[tag.m_128451_("AltarState")];
        }
        if (tag.m_128441_("Owner")) {
            this.owner = tag.m_128342_("Owner");
        }
        if (tag.m_128441_("Recipe")) {
            this.recipe = new AltarInfusionRecipe(tag.m_128469_("Recipe"));
        }
        if (tag.m_128441_("InfusionTimer")) {
            this.infusionTimer = tag.m_128451_("InfusionTimer");
        }
        if (tag.m_128441_("Displayed")) {
            this.displayedIndex.clear();
            CompoundTag displayed = tag.m_128469_("Displayed");
            for (String poolId : displayed.m_128431_()) {
                this.displayedIndex.put(poolId, displayed.m_128451_(poolId));
            }
        }
        this.input = Adapters.ITEM_STACK.readNbt(tag.m_128423_("Input")).orElse(null);
        if (!tag.m_128441_("Input") && this.altarState != AltarState.IDLE) {
            this.input = new ItemStack((ItemLike)ModItems.VAULT_ROCK);
        }
    }

    private void migrate(boolean containsVaultRock) {
        this.altarState = containsVaultRock ? AltarState.ACCEPTING : AltarState.IDLE;
    }

    @NotNull
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, BlockEntity::m_187482_);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public static enum AltarState {
        IDLE,
        ACCEPTING,
        COMPLETE,
        INFUSING;

    }
}

