/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.block.entity.base.FilteredInputInventoryTileEntity;
import iskallia.vault.block.entity.base.InventoryRetainerTileEntity;
import iskallia.vault.container.VaultArtisanStationContainer;
import iskallia.vault.container.oversized.OverSizedInventory;
import iskallia.vault.container.oversized.OverSizedItemStack;
import iskallia.vault.gear.crafting.VaultGearCraftingHelper;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.integration.IntegrationRefinedStorage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public class VaultArtisanStationTileEntity
extends BlockEntity
implements MenuProvider,
FilteredInputInventoryTileEntity,
InventoryRetainerTileEntity {
    private final OverSizedInventory inventory = new OverSizedInventory.FilteredInsert(17, this, this::canInsertInput);
    private final SimpleContainer gearInput = new SimpleContainer(1){

        public void m_6596_() {
            super.m_6596_();
            VaultArtisanStationTileEntity.this.updateLegacyGearInput();
            VaultArtisanStationTileEntity.this.m_6596_();
        }
    };

    public boolean stillValid(Player player) {
        if (this.f_58857_ == null || this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return this.inventory.m_6542_(player);
    }

    public VaultArtisanStationTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.VAULT_ARTISAN_STATION_ENTITY, pos, state);
    }

    public OverSizedInventory getInventory() {
        return this.inventory;
    }

    public SimpleContainer getGearInput() {
        return this.gearInput;
    }

    public void updateLegacyGearInput() {
        ItemStack gearInput = this.gearInput.m_8020_(0);
        if (gearInput.m_41619_()) {
            return;
        }
        if (!VaultGearData.hasData(gearInput)) {
            return;
        }
        VaultGearData data = VaultGearData.read(gearInput);
        if (data.hasAttribute(ModGearAttributes.MAX_CRAFTING_POTENTIAL)) {
            return;
        }
        VaultGearCraftingHelper.generateCraftingPotential(gearInput);
        this.gearInput.m_6836_(0, gearInput);
        this.m_6596_();
    }

    public boolean canInsertInput(int slot, @Nonnull ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        if (slot == 0) {
            return stack.m_150930_((Item)ModItems.VAULT_PLATING);
        }
        if (slot == 1) {
            return stack.m_150930_((Item)ModBlocks.VAULT_BRONZE);
        }
        if (slot == 2) {
            return stack.m_150930_((Item)ModItems.WILD_FOCUS);
        }
        if (slot == 3) {
            return stack.m_150930_((Item)ModItems.AMPLIFYING_FOCUS);
        }
        if (slot == 4) {
            return stack.m_150930_((Item)ModItems.NULLIFYING_FOCUS);
        }
        if (slot == 5) {
            return stack.m_150930_((Item)ModItems.FACETED_FOCUS);
        }
        if (slot == 6) {
            return stack.m_150930_((Item)ModItems.OPPORTUNISTIC_FOCUS);
        }
        if (slot == 7) {
            return stack.m_150930_((Item)ModItems.RESILIENT_FOCUS);
        }
        if (slot == 8) {
            return stack.m_150930_((Item)ModItems.FUNDAMENTAL_FOCUS);
        }
        if (slot == 9) {
            return stack.m_150930_((Item)ModItems.CHAOTIC_FOCUS);
        }
        if (slot == 10) {
            return stack.m_150930_((Item)ModItems.WAXING_FOCUS);
        }
        if (slot == 11) {
            return stack.m_150930_((Item)ModItems.WANING_FOCUS);
        }
        if (slot == 12) {
            return stack.m_150930_((Item)ModItems.EMPOWERED_CHAOTIC_FOCUS);
        }
        if (slot == 13) {
            return stack.m_150930_((Item)ModItems.CRYONIC_FOCUS);
        }
        if (slot == 14) {
            return stack.m_150930_((Item)ModItems.PYRETIC_FOCUS);
        }
        if (slot == 15) {
            return stack.m_150930_((Item)ModItems.VORPAL_FOCUS);
        }
        if (slot == 16) {
            return stack.m_150930_((Item)ModItems.ADAPTIVE_FOCUS);
        }
        return false;
    }

    @Override
    public boolean isInventorySideAccessible(@Nullable Direction side) {
        return true;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory.load(tag);
        this.gearInput.m_6836_(0, ItemStack.m_41712_((CompoundTag)tag.m_128469_("gearInput")));
        this.updateLegacyGearInput();
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.inventory.save(tag);
        tag.m_128365_("gearInput", (Tag)this.gearInput.m_8020_(0).m_41777_().serializeNBT());
    }

    public Component m_5446_() {
        return this.m_58900_().m_60734_().m_49954_();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (IntegrationRefinedStorage.shouldPreventImportingCapability(this.m_58904_(), this.m_58899_(), side)) {
            return super.getCapability(cap, side);
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.getFilteredInputCapability(side, new Container[]{this.inventory}).cast();
        }
        return super.getCapability(cap, side);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory inv, Player player) {
        if (this.m_58904_() == null) {
            return null;
        }
        return new VaultArtisanStationContainer(containerId, this.m_58904_(), this.m_58899_(), inv);
    }

    public static InventoryRetainerTileEntity.ContentDisplayInfo addInventoryTooltip(ItemStack stack, CompoundTag tag) {
        return InventoryRetainerTileEntity.displayContentsOverSized(5, stacks -> {
            ItemStack result = ItemStack.m_41712_((CompoundTag)tag.m_128469_("gearInput"));
            if (!result.m_41619_()) {
                stacks.add(OverSizedItemStack.of(result));
            }
            stacks.addAll(OverSizedInventory.loadContents("inventory", tag));
        });
    }

    @Override
    public void storeInventoryContents(CompoundTag tag) {
        this.getInventory().save("inventory", tag);
        tag.m_128365_("gearInput", (Tag)this.gearInput.m_8020_(0).m_41777_().serializeNBT());
    }

    @Override
    public void loadInventoryContents(CompoundTag tag) {
        this.inventory.load("inventory", tag);
        this.gearInput.m_6836_(0, ItemStack.m_41712_((CompoundTag)tag.m_128469_("gearInput")));
    }

    @Override
    public void clearInventoryContents() {
        this.getInventory().m_6211_();
        this.getGearInput().m_6211_();
    }
}

