/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.block.entity.base.ForgeRecipeTileEntity;
import iskallia.vault.block.entity.base.InventoryRetainerTileEntity;
import iskallia.vault.config.gear.VaultGearCraftingConfig;
import iskallia.vault.config.recipe.ForgeRecipeType;
import iskallia.vault.container.VaultForgeContainer;
import iskallia.vault.container.oversized.OverSizedInventory;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModItems;
import iskallia.vault.util.SidedHelper;
import iskallia.vault.world.data.PlayerProficiencyData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;

public class VaultForgeTileEntity
extends ForgeRecipeTileEntity
implements MenuProvider,
InventoryRetainerTileEntity {
    private final OverSizedInventory otherInputInventory = new OverSizedInventory.FilteredInsert(1, this, (slot, stack) -> stack.m_150930_((Item)ModItems.VAULT_SCRAP));

    public VaultForgeTileEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super(ModBlocks.VAULT_FORGE_TILE_ENTITY, pWorldPosition, pBlockState, 2, ForgeRecipeType.GEAR);
    }

    public void increaseProficiency(ServerPlayer player) {
        int cap;
        int scrapInput = this.otherInputInventory.m_8020_(0).m_41613_();
        if (scrapInput <= 0) {
            return;
        }
        PlayerProficiencyData data = PlayerProficiencyData.get(player.m_183503_());
        int currentProficiency = data.getAbsoluteProficiency(player.m_142081_());
        if (currentProficiency >= (cap = VaultGearCraftingConfig.getProficiencyCap(SidedHelper.getVaultLevel((Player)player)))) {
            return;
        }
        data.addAbsoluteProficiency(player.m_142081_(), scrapInput);
        data.sendProficiencyInformation(player);
        if (!player.m_7500_()) {
            this.otherInputInventory.m_6836_(0, ItemStack.f_41583_);
            this.m_6596_();
        }
    }

    @Override
    protected boolean canInsertRecipeInput(int slot, @NotNull ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        if (slot == 0) {
            return stack.m_150930_((Item)ModBlocks.VAULT_GOLD);
        }
        if (slot == 1) {
            return stack.m_150930_((Item)ModItems.VAULT_ALLOY);
        }
        return false;
    }

    public OverSizedInventory getOtherInputInventory() {
        return this.otherInputInventory;
    }

    @Override
    protected <T> LazyOptional<T> getInventoryCapability(Direction side) {
        return this.getFilteredInputCapability(side, new Container[]{this.getInventory(), this.getOtherInputInventory()});
    }

    @Override
    public boolean stillValid(Player player) {
        return super.stillValid(player) && this.otherInputInventory.m_6542_(player);
    }

    @Override
    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.otherInputInventory.load("otherInputs", tag);
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        this.otherInputInventory.save("otherInputs", tag);
    }

    @Override
    protected AbstractContainerMenu createMenu(int windowId, Inventory playerInventory) {
        return new VaultForgeContainer(windowId, this.m_58904_(), this.m_58899_(), playerInventory);
    }

    @Override
    public void storeInventoryContents(CompoundTag tag) {
        super.storeInventoryContents(tag);
        this.getOtherInputInventory().save("otherInputs", tag);
    }

    @Override
    public void loadInventoryContents(CompoundTag tag) {
        super.loadInventoryContents(tag);
        this.getOtherInputInventory().load("otherInputs", tag);
    }

    @Override
    public void clearInventoryContents() {
        super.clearInventoryContents();
        this.getOtherInputInventory().m_6211_();
    }

    public static InventoryRetainerTileEntity.ContentDisplayInfo addInventoryTooltip(ItemStack stack, CompoundTag tag) {
        InventoryRetainerTileEntity.ContentDisplayInfo forgeContent = InventoryRetainerTileEntity.displayContentsOverSized(5, stacks -> stacks.addAll(OverSizedInventory.loadContents("otherInputs", tag)));
        return ForgeRecipeTileEntity.addInventoryTooltip(stack, tag).append(forgeContent);
    }
}

