/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.block.entity.base.InventoryRetainerTileEntity;
import iskallia.vault.container.VaultJewelApplicationStationContainer;
import iskallia.vault.container.oversized.OverSizedInventory;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModSounds;
import iskallia.vault.item.tool.JewelItem;
import iskallia.vault.item.tool.ToolItem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class VaultJewelApplicationStationTileEntity
extends BlockEntity
implements MenuProvider,
InventoryRetainerTileEntity {
    public static final int TOOL_SLOT = 0;
    public static final int JEWEL_SLOTS = 60;
    private final OverSizedInventory inventory = new OverSizedInventory(61, this){

        @Override
        public void m_6596_() {
            super.m_6596_();
            VaultJewelApplicationStationTileEntity.this.updateJewelContents();
        }
    };
    private int totalSizeInJewels = 0;
    private ItemStack renderedTool = this.getToolItem();

    public VaultJewelApplicationStationTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.VAULT_JEWEL_APPLICATION_STATION_ENTITY, pos, state);
    }

    private void updateJewelContents() {
        ItemStack result = this.getToolItem().m_41777_();
        this.totalSizeInJewels = 0;
        this.renderedTool = result.m_41777_();
        if (!(result.m_41720_() instanceof ToolItem)) {
            return;
        }
        for (int slot = 0; slot < 60; ++slot) {
            ItemStack jewel = this.getJewelItem(slot);
            if (!(jewel.m_41720_() instanceof JewelItem)) continue;
            if (result.m_41720_() instanceof ToolItem) {
                ToolItem.applyJewel(result, jewel, false);
            }
            if (!VaultGearData.hasData(jewel)) continue;
            VaultGearData data = VaultGearData.read(jewel);
            for (VaultGearAttributeInstance<Integer> sizeAttribute : data.getModifiers(ModGearAttributes.JEWEL_SIZE, VaultGearData.Type.ALL_MODIFIERS)) {
                this.totalSizeInJewels += sizeAttribute.getValue().intValue();
            }
        }
        this.renderedTool = result.m_41777_();
        this.m_6596_();
    }

    public void applyJewels() {
        ItemStack result = this.getToolItem();
        for (int slot = 0; slot < 60; ++slot) {
            ItemStack jewel = this.getJewelItem(slot);
            if (jewel.m_41720_() instanceof JewelItem && result.m_41720_() instanceof ToolItem && ToolItem.applyJewel(result, jewel, true)) {
                this.setJewelItem(slot, ItemStack.f_41583_);
            }
            this.setToolItem(result);
        }
        if (this.m_58904_() != null) {
            this.m_58904_().m_5594_(null, this.m_58899_(), ModSounds.ARTISAN_SMITHING, SoundSource.BLOCKS, 0.2f, this.m_58904_().f_46441_.nextFloat() * 0.1f + 0.9f);
        }
    }

    public OverSizedInventory getInventory() {
        return this.inventory;
    }

    public int getTotalSizeInJewels() {
        return this.totalSizeInJewels;
    }

    public ItemStack getRenderedTool() {
        return this.renderedTool;
    }

    public ItemStack getToolItem() {
        return this.getInventory().m_8020_(0);
    }

    public void setToolItem(ItemStack stack) {
        this.getInventory().m_6836_(0, stack.m_41777_());
    }

    public ItemStack getJewelItem(int slot) {
        slot = Mth.m_14045_((int)slot, (int)0, (int)60);
        return this.getInventory().m_8020_(slot + 1);
    }

    public void setJewelItem(int slot, ItemStack stack) {
        slot = Mth.m_14045_((int)slot, (int)0, (int)60);
        this.getInventory().m_6836_(slot + 1, stack);
    }

    public List<ItemStack> getJewels() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < 60; ++i) {
            stacks.add(this.getInventory().m_8020_(i + 1));
        }
        return stacks;
    }

    public boolean stillValid(Player player) {
        if (this.f_58857_ == null || this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return this.getInventory().m_6542_(player);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.renderedTool = ItemStack.m_41712_((CompoundTag)tag.m_128469_("renderedItem"));
        this.totalSizeInJewels = tag.m_128451_("size");
        this.getInventory().load(tag);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("renderedItem", (Tag)this.renderedTool.m_41739_(new CompoundTag()));
        tag.m_128405_("size", this.totalSizeInJewels);
        this.getInventory().save(tag);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public Component m_5446_() {
        return this.m_58900_().m_60734_().m_49954_();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory inv, Player player) {
        if (this.m_58904_() == null) {
            return null;
        }
        return new VaultJewelApplicationStationContainer(containerId, this.m_58904_(), this.m_58899_(), inv);
    }

    public static InventoryRetainerTileEntity.ContentDisplayInfo addInventoryTooltip(ItemStack stack, CompoundTag tag) {
        InventoryRetainerTileEntity.ContentDisplayInfo itemContent = InventoryRetainerTileEntity.displayContentsOverSized(5, stacks -> OverSizedInventory.loadContents("inventory", tag).stream().filter(containedStack -> !containedStack.overSizedStack().m_150930_((Item)ModItems.JEWEL)).forEach(stacks::add));
        int totalSize = tag.m_128451_("totalSize");
        if (totalSize > 0) {
            itemContent = itemContent.append(List.of(new TextComponent("- Jewels totaling ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(String.valueOf(totalSize)).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)new TextComponent(" size").m_130940_(ChatFormatting.GRAY))), 5);
        }
        return itemContent;
    }

    @Override
    public void storeInventoryContents(CompoundTag tag) {
        this.getInventory().save("inventory", tag);
        tag.m_128365_("renderedItem", (Tag)this.renderedTool.m_41739_(new CompoundTag()));
        tag.m_128405_("totalSize", this.totalSizeInJewels);
    }

    @Override
    public void loadInventoryContents(CompoundTag tag) {
        this.getInventory().load("inventory", tag);
        this.renderedTool = ItemStack.m_41712_((CompoundTag)tag.m_128469_("renderedItem"));
        this.totalSizeInJewels = tag.m_128451_("totalSize");
    }

    @Override
    public void clearInventoryContents() {
        this.getInventory().m_6211_();
        this.renderedTool = ItemStack.f_41583_;
        this.totalSizeInJewels = 0;
    }
}

