/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.world.data.ServerVaults;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class VaultPortalTileEntity
extends BlockEntity {
    private CrystalData data;

    public VaultPortalTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.VAULT_PORTAL_TILE_ENTITY, pos, state);
    }

    public void sendUpdates() {
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        this.m_6596_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag nbt = pkt.m_131708_();
        if (nbt != null) {
            this.m_142466_(nbt);
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.sendUpdates();
        }
    }

    protected void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        Adapters.CRYSTAL.writeNbt(this.data).ifPresent(data -> nbt.m_128365_("Data", (Tag)data));
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.data = Adapters.CRYSTAL.readNbt((CompoundTag)nbt.m_128423_("Data")).orElse(null);
    }

    public Optional<CrystalData> getData() {
        return Optional.ofNullable(this.data);
    }

    public void setCrystalData(CrystalData data) {
        this.data = data;
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.sendUpdates();
        }
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, VaultPortalTileEntity te) {
        if (level.f_46443_) {
            return;
        }
        UUID vaultId = te.getData().map(crystal -> crystal.getProperties().getVaultId()).orElse(null);
        if (vaultId != null && ServerVaults.get(vaultId).isEmpty()) {
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            return;
        }
        te.getData().ifPresent(data -> data.onPortalTick(level, pos, state));
    }
}

