/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import com.google.common.collect.Lists;
import iskallia.vault.config.VaultRecyclerConfig;
import iskallia.vault.container.VaultRecyclerContainer;
import iskallia.vault.container.base.SimpleSidedContainer;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.item.gear.RecyclableItem;
import iskallia.vault.network.message.RecyclerParticleMessage;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.util.nbt.NBTHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.minecraftforge.network.PacketDistributor;

public class VaultRecyclerTileEntity
extends BlockEntity
implements MenuProvider {
    private static final Random rand = new Random();
    private final RecyclerInventory inventory = new RecyclerInventory();
    private UUID gearIdProcessing = null;
    private int processTick = 0;
    private LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this.inventory, (Direction[])new Direction[]{Direction.UP, Direction.DOWN});

    public VaultRecyclerTileEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super(ModBlocks.VAULT_RECYCLER_ENTITY, pWorldPosition, pBlockState);
    }

    public boolean stillValid(Player player) {
        if (this.f_58857_ == null || this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return this.inventory.m_6542_(player);
    }

    public static void tick(Level world, BlockPos pos, BlockState state, VaultRecyclerTileEntity tile) {
        if (world.m_5776_() || tile.gearIdProcessing == null) {
            return;
        }
        if (!tile.canCraft()) {
            tile.resetProcess(world);
            return;
        }
        ++tile.processTick;
        if (tile.processTick >= ModConfigs.VAULT_RECYCLER.getProcessingTickTime()) {
            tile.finishCraft();
        }
        tile.m_6596_();
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            serverWorld.m_7260_(pos, state, state, 3);
        }
    }

    private void finishCraft() {
        VaultRecyclerConfig.RecyclerOutput output = this.getRecipeOutput();
        if (output == null || this.f_58857_ == null) {
            return;
        }
        this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11914_, SoundSource.BLOCKS, 0.5f + new Random().nextFloat() * 0.25f, 0.75f + new Random().nextFloat() * 0.25f);
        ItemStack input = this.inventory.m_8020_(0).m_41777_();
        float additionalChance = 0.0f;
        if (input.m_41720_() instanceof VaultGearItem) {
            VaultGearData data = VaultGearData.read(input);
            VaultGearRarity rarity = data.getRarity();
            boolean isCrafted = data.hasAttribute(ModGearAttributes.CRAFTED_BY) || data.getFirstValue(ModGearAttributes.CRAFTED_BY).isPresent();
            boolean isLegendary = data.get(ModGearAttributes.IS_LEGENDARY, VaultGearAttributeTypeMerger.anyTrue());
            additionalChance = ModConfigs.VAULT_RECYCLER.getAdditionalOutputRarityChance(rarity);
            this.inventory.m_7407_(0, 1);
            MiscUtils.addStackToSlot((Container)this.inventory, 1, this.getUseRelatedOutput(input, output.generateMainOutput(additionalChance)));
            MiscUtils.addStackToSlot((Container)this.inventory, 2, this.getUseRelatedOutput(input, output.generateExtraOutput1(input, additionalChance, rarity, isCrafted, isLegendary)));
            MiscUtils.addStackToSlot((Container)this.inventory, 3, this.getUseRelatedOutput(input, output.generateExtraOutput2(input, additionalChance, rarity, isCrafted, isLegendary)));
        } else {
            this.inventory.m_7407_(0, 1);
            MiscUtils.addStackToSlot((Container)this.inventory, 1, this.getUseRelatedOutput(input, output.generateMainOutput(additionalChance)));
            MiscUtils.addStackToSlot((Container)this.inventory, 2, this.getUseRelatedOutput(input, output.generateExtraOutput1(input, additionalChance)));
            MiscUtils.addStackToSlot((Container)this.inventory, 3, this.getUseRelatedOutput(input, output.generateExtraOutput2(input, additionalChance)));
        }
        ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new RecyclerParticleMessage(this.m_58899_()));
    }

    private ItemStack getUseRelatedOutput(ItemStack input, ItemStack output) {
        float chance = this.getResultPercentage(input);
        float out = (float)output.m_41613_() * chance;
        int resultCount = Mth.m_14143_((float)out);
        if (resultCount < 1 && out > 0.0f && rand.nextFloat() < out) {
            ++resultCount;
        }
        ItemStack copyOut = output.m_41777_();
        copyOut.m_41764_(resultCount);
        return copyOut;
    }

    private boolean canCraft() {
        VaultRecyclerConfig.RecyclerOutput output = this.getRecipeOutput();
        if (output == null) {
            return false;
        }
        if (!MiscUtils.canFullyMergeIntoSlot((Container)this.inventory, 1, output.getMainOutputMatching())) {
            return false;
        }
        if (!MiscUtils.canFullyMergeIntoSlot((Container)this.inventory, 2, output.getExtraOutput1Matching())) {
            return false;
        }
        return MiscUtils.canFullyMergeIntoSlot((Container)this.inventory, 3, output.getExtraOutput2Matching());
    }

    @Nullable
    private VaultRecyclerConfig.RecyclerOutput getRecipeOutput() {
        ItemStack input = this.inventory.m_8020_(0);
        if (!this.isValidInput(input)) {
            return null;
        }
        Item item = input.m_41720_();
        if (item instanceof RecyclableItem) {
            RecyclableItem recyclableItem = (RecyclableItem)item;
            return recyclableItem.getOutput(input);
        }
        return null;
    }

    private void triggerItemChange() {
        ItemStack input = this.inventory.m_8020_(0);
        if (!this.isValidInput(input)) {
            this.resetProcess(null);
            return;
        }
        Item item = input.m_41720_();
        if (!(item instanceof RecyclableItem)) {
            return;
        }
        RecyclableItem recyclableItem = (RecyclableItem)item;
        recyclableItem.getUuid(input).ifPresent(itemId -> {
            if ((this.gearIdProcessing == null || !this.gearIdProcessing.equals(itemId)) && this.canCraft()) {
                this.startProcess(null, (UUID)itemId);
            }
        });
    }

    public boolean isValidInput(ItemStack input) {
        Item item = input.m_41720_();
        if (item instanceof RecyclableItem) {
            RecyclableItem recyclableItem = (RecyclableItem)item;
            return recyclableItem.isValidInput(input);
        }
        return false;
    }

    public float getResultPercentage(ItemStack input) {
        Item item = input.m_41720_();
        if (item instanceof RecyclableItem) {
            RecyclableItem recyclableItem = (RecyclableItem)item;
            return recyclableItem.getResultPercentage(input);
        }
        return 0.0f;
    }

    private void resetProcess(@Nullable Level world) {
        this.startProcess(world, null);
    }

    private void startProcess(@Nullable Level world, UUID id) {
        int prevTick = this.processTick;
        this.gearIdProcessing = id;
        this.processTick = 0;
        this.m_6596_();
        if (prevTick != this.processTick && world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            serverWorld.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public float getProgressPercent() {
        return (float)this.processTick / (float)ModConfigs.VAULT_RECYCLER.getProcessingTickTime();
    }

    public RecyclerInventory getInventory() {
        return this.inventory;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        NBTHelper.deserializeSimpleContainer(this.inventory, tag.m_128437_("inventory", 10));
        this.processTick = tag.m_128451_("processTick");
        if (tag.m_128403_("gearIdProcessing")) {
            this.gearIdProcessing = tag.m_128342_("gearIdProcessing");
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inventory", (Tag)NBTHelper.serializeSimpleContainer(this.inventory));
        tag.m_128405_("processTick", this.processTick);
        if (this.gearIdProcessing != null) {
            tag.m_128362_("gearIdProcessing", this.gearIdProcessing);
        }
    }

    public Component m_5446_() {
        return this.m_58900_().m_60734_().m_49954_();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory inv, Player player) {
        if (this.m_58904_() == null) {
            return null;
        }
        return new VaultRecyclerContainer(containerId, this.m_58904_(), this.m_58899_(), inv);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        Arrays.stream(this.handlers).forEach(LazyOptional::invalidate);
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.handlers = SidedInvWrapper.create((WorldlyContainer)this.inventory, (Direction[])new Direction[]{Direction.UP, Direction.DOWN});
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void spawnRecycleParticles(BlockPos pos) {
        Vec3 offset;
        Random random;
        int i;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        for (i = 0; i < 4; ++i) {
            random = level.m_5822_();
            offset = new Vec3(random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1));
            level.m_6493_((ParticleOptions)ParticleTypes.f_123756_, true, (double)pos.m_123341_() + 0.5 + offset.f_82479_, (double)pos.m_123342_() + random.nextDouble() * (double)0.15f + 0.25, (double)pos.m_123343_() + 0.5 + offset.f_82481_, offset.f_82479_ / 2.0, random.nextDouble() * 0.1, offset.f_82481_ / 2.0);
        }
        for (i = 0; i < 3; ++i) {
            random = level.m_5822_();
            offset = new Vec3(random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1));
            level.m_6493_((ParticleOptions)ParticleTypes.f_123756_, true, (double)pos.m_123341_() + 0.5 + offset.f_82479_, (double)pos.m_7494_().m_123342_() + random.nextDouble() * (double)0.15f, (double)pos.m_123343_() + 0.5 + offset.f_82481_, offset.f_82479_ / 20.0, random.nextDouble() * 0.2, offset.f_82481_ / 20.0);
        }
        for (i = 0; i < 3; ++i) {
            random = level.m_5822_();
            offset = new Vec3(random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1));
            level.m_6493_((ParticleOptions)ParticleTypes.f_123762_, true, (double)pos.m_123341_() + 0.5 + offset.f_82479_, (double)pos.m_7494_().m_123342_() + random.nextDouble() * (double)0.15f, (double)pos.m_123343_() + 0.5 + offset.f_82481_, offset.f_82479_ / 20.0, random.nextDouble() * 0.2, offset.f_82481_ / 20.0);
        }
        for (i = 0; i < 3; ++i) {
            random = level.m_5822_();
            offset = new Vec3(random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1));
            level.m_6493_((ParticleOptions)ParticleTypes.f_123755_, true, (double)pos.m_123341_() + 0.5 + offset.f_82479_, (double)pos.m_7494_().m_123342_() + random.nextDouble() * (double)0.15f, (double)pos.m_123343_() + 0.5 + offset.f_82481_, offset.f_82479_ / 10.0, random.nextDouble() * 0.05, offset.f_82481_ / 10.0);
        }
    }

    public class RecyclerInventory
    extends SimpleSidedContainer {
        public RecyclerInventory() {
            super(4);
        }

        @Override
        public List<Direction> getAccessibleSlots(int slot) {
            if (slot == 0) {
                return Lists.newArrayList((Object[])new Direction[]{Direction.UP});
            }
            return Lists.newArrayList((Object[])new Direction[]{Direction.DOWN});
        }

        public boolean m_7013_(int slot, ItemStack stack) {
            Item item;
            if (stack.m_41619_()) {
                return false;
            }
            if (slot == 0 && (item = stack.m_41720_()) instanceof RecyclableItem) {
                RecyclableItem recyclableItem = (RecyclableItem)item;
                return recyclableItem.isValidInput(stack);
            }
            return false;
        }

        public void m_6596_() {
            super.m_6596_();
            VaultRecyclerTileEntity.this.m_6596_();
            VaultRecyclerTileEntity.this.triggerItemChange();
        }
    }
}

