/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.VaultMod;
import iskallia.vault.block.base.FacedBlock;
import iskallia.vault.block.entity.base.FilteredInputInventoryTileEntity;
import iskallia.vault.block.entity.base.InventoryRetainerTileEntity;
import iskallia.vault.config.recipe.ForgeRecipeType;
import iskallia.vault.container.VoidCrucibleContainer;
import iskallia.vault.container.oversized.OverSizedInventory;
import iskallia.vault.container.oversized.OverSizedItemStack;
import iskallia.vault.gear.crafting.recipe.VaultForgeRecipe;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.integration.IntegrationRefinedStorage;
import iskallia.vault.world.data.VoidStoneBlacklistData;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VoidCrucibleTileEntity
extends BlockEntity
implements FilteredInputInventoryTileEntity,
InventoryRetainerTileEntity,
MenuProvider {
    private final OverSizedInventory craftingInventory;
    private final Container blacklistInventory;
    private final ResultContainer output = new ResultContainer(){

        public void m_6596_() {
            super.m_6596_();
            VoidCrucibleTileEntity.this.m_6596_();
        }
    };
    private final ForgeRecipeType recipeType = ForgeRecipeType.VOID_STONE;

    public VoidCrucibleTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.VOID_CRUCIBLE_TILE_ENTITY, pos, state);
        this.craftingInventory = new OverSizedInventory.FilteredInsert(2, this, this::canInsertRecipeInput);
        this.blacklistInventory = new SimpleContainer(54);
    }

    public OverSizedInventory getInventory() {
        return this.craftingInventory;
    }

    public Container getBlacklistInventory() {
        return this.blacklistInventory;
    }

    public List<ResourceLocation> getBlacklist(ServerPlayer player) {
        List<ResourceLocation> blacklist = VoidStoneBlacklistData.get(player.m_183503_()).getInventory(player).getBlacklist();
        return blacklist;
    }

    public ResultContainer getResultContainer() {
        return this.output;
    }

    public VaultForgeRecipe getRecipe() {
        return this.recipeType.getRecipe(VaultMod.id("void_stone"));
    }

    public boolean stillValid(Player player) {
        if (this.m_58904_() == null || this.m_58904_().m_7702_(this.m_58899_()) != this) {
            return false;
        }
        if (this.getRecipe() == null) {
            return false;
        }
        boolean result = this.getInventory().m_6542_(player);
        return result;
    }

    protected boolean canInsertRecipeInput(int slot, @Nonnull ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        if (this.getRecipe() == null) {
            return false;
        }
        boolean result = this.recipeType.getRecipeConfig().getInputItemCache().contains(stack.m_41720_());
        return result;
    }

    @Override
    public boolean isInventorySideAccessible(@Nullable Direction side) {
        return true;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (IntegrationRefinedStorage.shouldPreventImportingCapability(this.m_58904_(), this.m_58899_(), side)) {
            return super.getCapability(cap, side);
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.getInventoryCapability(side);
        }
        return super.getCapability(cap, side);
    }

    protected <T> LazyOptional<T> getInventoryCapability(Direction side) {
        return this.getFilteredInputCapability(side, new Container[]{this.craftingInventory});
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.getInventory().load(tag);
        this.getResultContainer().m_6836_(0, ItemStack.m_41712_((CompoundTag)tag.m_128469_("result")));
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        this.getInventory().save(pTag);
        pTag.m_128365_("result", (Tag)this.getResultContainer().m_8020_(0).serializeNBT());
    }

    public static InventoryRetainerTileEntity.ContentDisplayInfo addInventoryTooltip(ItemStack stack, CompoundTag tag) {
        return InventoryRetainerTileEntity.displayContentsOverSized(5, stacks -> {
            ItemStack result = ItemStack.m_41712_((CompoundTag)tag.m_128469_("result"));
            if (!result.m_41619_()) {
                stacks.add(OverSizedItemStack.of(result));
            }
            stacks.addAll(OverSizedInventory.loadContents("inventory", tag));
        });
    }

    @Override
    public void storeInventoryContents(CompoundTag tag) {
        this.getInventory().save("inventory", tag);
        tag.m_128365_("result", (Tag)this.getResultContainer().m_8020_(0).m_41777_().serializeNBT());
    }

    @Override
    public void loadInventoryContents(CompoundTag tag) {
        this.getInventory().load("inventory", tag);
        this.getResultContainer().m_6836_(0, ItemStack.m_41712_((CompoundTag)tag.m_128469_("result")));
    }

    @Override
    public void clearInventoryContents() {
        this.getInventory().m_6211_();
        this.getResultContainer().m_6211_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void spawnParticles(BlockPos pos) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        for (int i = 0; i < 8; ++i) {
            Random random = level.m_5822_();
            Direction direction = level.m_8055_(pos).m_61138_((Property)FacedBlock.FACING) ? (Direction)level.m_8055_(pos).m_61143_((Property)FacedBlock.FACING) : Direction.NORTH;
            Direction.Axis direction$axis = direction.m_122434_();
            double x = (double)pos.m_123341_() + 0.5;
            double y = pos.m_123342_();
            double z = (double)pos.m_123343_() + 0.5;
            double d3 = -0.52;
            double d4 = random.nextDouble() * 0.6 - 0.3;
            double d5 = direction$axis == Direction.Axis.X ? (double)direction.m_122429_() * d3 : d4;
            double d6 = random.nextDouble() * 6.0 / 16.0;
            double d7 = direction$axis == Direction.Axis.Z ? (double)direction.m_122431_() * d3 : d4;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x + d5, y + d6, z + d7, 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123756_, x + d5, y + d6, z + d7, 0.0, 0.0, 0.0);
        }
    }

    public boolean transferCraftingItemsToPlayer(Player player) {
        boolean allItemsMoved = true;
        for (int i = 0; i < this.craftingInventory.m_6643_(); ++i) {
            ItemStack stackInSlot = this.craftingInventory.m_8020_(i);
            if (stackInSlot.m_41619_()) continue;
            if (!player.m_150109_().m_36054_(stackInSlot)) {
                allItemsMoved = false;
                continue;
            }
            this.craftingInventory.m_6836_(i, ItemStack.f_41583_);
        }
        if (!allItemsMoved) {
            this.m_6596_();
        }
        return allItemsMoved;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player playerEntity) {
        Level level = this.m_58904_();
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel world = (ServerLevel)level;
        if (!(playerEntity instanceof ServerPlayer)) {
            return null;
        }
        ServerPlayer player = (ServerPlayer)playerEntity;
        CompoundTag inventoryNbt = VoidStoneBlacklistData.get(world).getInventory(player).serializeNBT();
        return new VoidCrucibleContainer.Blacklist(windowId, playerInventory, this.m_58899_(), inventoryNbt);
    }

    public Component m_5446_() {
        return new TextComponent("Void Crucible: Blacklist");
    }
}

