/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import com.mojang.authlib.GameProfile;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.integration.IntegrationCurios;
import iskallia.vault.util.nbt.NBTHelper;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class WardrobeTileEntity
extends BlockEntity {
    private Map<EquipmentSlot, ItemStack> equipmentSlots = new EnumMap<EquipmentSlot, ItemStack>(EquipmentSlot.class);
    private Map<String, Map<Integer, ItemStack>> curiosItems = new HashMap<String, Map<Integer, ItemStack>>();
    private final ItemStackHandler hotbarItems = new ItemStackHandler(9){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            WardrobeTileEntity.this.m_6596_();
            WardrobeTileEntity.this.f_58857_.m_7260_(WardrobeTileEntity.this.m_58899_(), WardrobeTileEntity.this.m_58900_(), WardrobeTileEntity.this.m_58900_(), 3);
        }
    };
    @Nullable
    private UUID owner = null;
    @Nullable
    private Player dummyRenderPlayer;
    private boolean renderSolid = true;

    public WardrobeTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.WARDROBE_TILE_ENTITY, pos, state);
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
        this.m_6596_();
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    public boolean isOwner(Player player) {
        return player.m_142081_().equals(this.owner);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        NBTHelper.writeMap(tag, "equipmentSlots", this.equipmentSlots, EquipmentSlot::m_20751_, stack -> stack.m_41739_(new CompoundTag()));
        NBTHelper.writeMap(tag, "curiosItems", this.curiosItems, name -> name, stacks -> NBTHelper.serializeMap(stacks, String::valueOf, stack -> stack.m_41739_(new CompoundTag())));
        tag.m_128365_("hotbarItems", (Tag)this.hotbarItems.serializeNBT());
        if (this.owner != null) {
            tag.m_128362_("owner", this.owner);
        }
        tag.m_128379_("renderSolid", this.renderSolid);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.equipmentSlots = NBTHelper.readMap(tag, "equipmentSlots", EquipmentSlot::m_20747_, (key, t) -> Optional.of(ItemStack.m_41712_((CompoundTag)((CompoundTag)t)))).orElse(Map.of());
        this.curiosItems = NBTHelper.readMap(tag, "curiosItems", name -> name, (name, t) -> Optional.of(NBTHelper.deserializeMap((CompoundTag)t, Integer::valueOf, (k, stackTag) -> Optional.of(ItemStack.m_41712_((CompoundTag)((CompoundTag)stackTag)))))).orElse(Map.of());
        this.hotbarItems.deserializeNBT(tag.m_128469_("hotbarItems"));
        this.updateRenderPlayerItems();
        if (tag.m_128441_("owner")) {
            this.owner = tag.m_128342_("owner");
        }
        this.renderSolid = tag.m_128471_("renderSolid");
    }

    public void setEquipmentSlot(EquipmentSlot equipmentSlot, ItemStack stack) {
        this.equipmentSlots.put(equipmentSlot, stack);
        this.m_6596_();
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    public Player getDummyRenderPlayer() {
        if (this.dummyRenderPlayer == null) {
            this.dummyRenderPlayer = new Player(this.f_58857_, this.m_58899_(), 0.0f, new GameProfile(null, "dummyWardrobeRender")){

                public boolean m_5833_() {
                    return false;
                }

                public boolean m_7500_() {
                    return false;
                }
            };
            this.updateRenderPlayerItems();
        }
        return this.dummyRenderPlayer;
    }

    public AABB getRenderBoundingBox() {
        return super.getRenderBoundingBox().m_82363_(0.0, 3.0, 0.0);
    }

    private void updateRenderPlayerItems() {
        if (this.dummyRenderPlayer == null) {
            return;
        }
        this.dummyRenderPlayer.m_150109_().m_6211_();
        this.equipmentSlots.forEach((equipmentSlot, stack) -> this.dummyRenderPlayer.m_8061_(equipmentSlot, stack));
        this.curiosItems.forEach((slotKey, stacks) -> stacks.forEach((slot, stack) -> IntegrationCurios.setCurioItemStack((LivingEntity)this.dummyRenderPlayer, stack, slotKey, slot)));
        this.dummyRenderPlayer.m_8061_(EquipmentSlot.MAINHAND, this.hotbarItems.getStackInSlot(0));
    }

    public boolean shouldRenderSolid() {
        return this.renderSolid;
    }

    public ItemStackHandler getHotbarItems() {
        return this.hotbarItems;
    }

    public Map<EquipmentSlot, ItemStack> getEquipmentSlots() {
        return this.equipmentSlots;
    }

    public ItemStack getEquipment(EquipmentSlot equipmentSlot) {
        return this.equipmentSlots.getOrDefault(equipmentSlot, ItemStack.f_41583_);
    }

    public Map<String, Map<Integer, ItemStack>> getCuriosItems() {
        return this.curiosItems;
    }

    public ItemStack getCurio(String slotKey, int index) {
        return this.curiosItems.getOrDefault(slotKey, Collections.emptyMap()).getOrDefault(index, ItemStack.f_41583_);
    }

    public void setCurio(String slotKey, int index, ItemStack stack) {
        this.curiosItems.computeIfAbsent(slotKey, sk -> new HashMap()).put(index, stack);
        this.m_6596_();
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    public void swap(Player player, boolean swapEverything) {
        this.swapEquipmentSlots(player, swapEverything);
        this.swapCuriosSlots(player, swapEverything);
        this.swapHotbar(player, swapEverything);
        this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11673_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private void swapHotbar(Player player, boolean swapEverything) {
        for (int slot = 0; slot < this.hotbarItems.getSlots(); ++slot) {
            ItemStack slotStack = this.hotbarItems.getStackInSlot(slot);
            if (!swapEverything && slotStack.m_41619_()) continue;
            ItemStack storedCopy = slotStack;
            this.hotbarItems.setStackInSlot(slot, player.m_150109_().m_8020_(slot));
            player.m_150109_().f_35974_.set(slot, (Object)storedCopy);
            this.m_6596_();
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    private void swapEquipmentSlots(Player player, boolean swapEverything) {
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            if (equipmentSlot == EquipmentSlot.MAINHAND || !swapEverything && (!this.equipmentSlots.containsKey(equipmentSlot) || this.equipmentSlots.get(equipmentSlot).m_41619_())) continue;
            ItemStack storedCopy = this.equipmentSlots.getOrDefault(equipmentSlot, ItemStack.f_41583_).m_41777_();
            this.equipmentSlots.put(equipmentSlot, player.m_6844_(equipmentSlot));
            player.m_8061_(equipmentSlot, storedCopy);
            this.m_6596_();
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    private void swapCuriosSlots(Player player, boolean swapEverything) {
        IntegrationCurios.getCuriosItemStacks((LivingEntity)player).forEach((slotKey, slotStacks) -> {
            Map storedStacks = this.curiosItems.getOrDefault(slotKey, Collections.emptyMap());
            slotStacks.forEach(t -> {
                ItemStack stack = (ItemStack)t.m_14418_();
                int slot = (Integer)t.m_14419_();
                if (swapEverything || storedStacks.containsKey(slot) && !((ItemStack)storedStacks.get(slot)).m_41619_()) {
                    ItemStack storedCopy = storedStacks.getOrDefault(slot, ItemStack.f_41583_);
                    this.setCurio((String)slotKey, slot, stack);
                    IntegrationCurios.setCurioItemStack((LivingEntity)player, storedCopy, slotKey, slot);
                    this.m_6596_();
                    this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
                }
            });
        });
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, blockEntity -> this.m_187482_());
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void toggleSolidRender() {
        this.renderSolid = !this.renderSolid;
        this.m_6596_();
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    public static class CuriosDynamicStackHandler
    implements IDynamicStackHandler {
        private NonNullList<ItemStack> previousStacks;
        private final WardrobeTileEntity wardrobeTile;
        private final String slotKey;
        private final int slots;

        public CuriosDynamicStackHandler(WardrobeTileEntity wardrobeTile, String slotKey, int slots) {
            this.wardrobeTile = wardrobeTile;
            this.slotKey = slotKey;
            this.slots = slots;
            this.previousStacks = NonNullList.m_122780_((int)slots, (Object)ItemStack.f_41583_);
        }

        public void setStackInSlot(int slot, @NotNull ItemStack stack) {
            this.wardrobeTile.setCurio(this.slotKey, slot, stack);
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return this.wardrobeTile.getCurio(this.slotKey, slot);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (stack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            if (!this.wardrobeTile.getCurio(this.slotKey, slot).m_41619_()) {
                return stack;
            }
            if (simulate) {
                return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.m_41613_() - 1));
            }
            this.wardrobeTile.setCurio(this.slotKey, slot, stack.m_41620_(1));
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack curio = this.wardrobeTile.getCurio(this.slotKey, slot);
            if (amount < 1 || curio.m_41619_()) {
                return ItemStack.f_41583_;
            }
            if (simulate) {
                return curio;
            }
            this.wardrobeTile.setCurio(this.slotKey, slot, ItemStack.f_41583_);
            return curio;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return true;
        }

        public void setPreviousStackInSlot(int slot, @NotNull ItemStack stack) {
            this.previousStacks.set(slot, (Object)stack);
        }

        public ItemStack getPreviousStackInSlot(int slot) {
            this.validateSlotIndex(slot);
            return (ItemStack)this.previousStacks.get(slot);
        }

        private void validateSlotIndex(int slot) {
            if (slot < 0 || slot >= this.slots) {
                throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.slots + ")");
            }
        }

        public int getSlots() {
            return this.slots;
        }

        public void grow(int amount) {
            this.previousStacks = CuriosDynamicStackHandler.getResizedList(this.previousStacks.size() + amount, this.previousStacks);
        }

        public void shrink(int amount) {
            this.previousStacks = CuriosDynamicStackHandler.getResizedList(this.previousStacks.size() - amount, this.previousStacks);
        }

        private static NonNullList<ItemStack> getResizedList(int size, NonNullList<ItemStack> stacks) {
            NonNullList newList = NonNullList.m_122780_((int)Math.max(0, size), (Object)ItemStack.f_41583_);
            for (int i = 0; i < newList.size() && i < stacks.size(); ++i) {
                newList.set(i, (Object)((ItemStack)stacks.get(i)));
            }
            return newList;
        }

        public CompoundTag serializeNBT() {
            return new CompoundTag();
        }

        public void deserializeNBT(CompoundTag nbt) {
        }
    }
}

