/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.VaultMod;
import iskallia.vault.block.entity.BaseSpawnerTileEntity;
import iskallia.vault.config.WildSpawnerConfig;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.world.storage.IZonedWorld;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.world.data.ServerVaults;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class WildSpawnerTileEntity
extends BaseSpawnerTileEntity {
    private static final int MAX_PLAYER_CHECK_COOOLDOWN = 10;
    @Nullable
    private WildSpawnerConfig.SpawnerGroup spawnerGroup;
    private int playerCheckCooldown = 0;
    private long lastCheckTime = -1L;

    public WildSpawnerTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.WILD_SPAWNER_TILE_ENTITY, pos, state);
    }

    public static void tick(Level level, BlockPos blockPos, WildSpawnerTileEntity te) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        te.initSpawnerGroup();
        if (te.spawnerGroup == null) {
            VaultMod.LOGGER.warn("Wild Spawner failed to spawn as there was no valid spawn group found in config");
            IZonedWorld.runWithBypass(serverLevel, true, () -> level.m_7471_(blockPos, false));
            return;
        }
        if (te.lastCheckTime + (long)te.playerCheckCooldown > level.m_46467_()) {
            return;
        }
        te.lastCheckTime = level.m_46467_();
        Player player = level.m_45924_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, 100.0, true);
        if (player == null) {
            return;
        }
        double distSqr = player.m_20275_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5);
        WildSpawnerConfig.SpawnerGroup spawnerGroup = te.spawnerGroup;
        if ((double)(spawnerGroup.blockCheckRadius * spawnerGroup.blockCheckRadius) < distSqr) {
            return;
        }
        WildSpawnerTileEntity.spawnEntity(level, blockPos, serverLevel, spawnerGroup);
        IZonedWorld.runWithBypass(serverLevel, true, () -> level.m_7471_(blockPos, false));
    }

    private static void spawnEntity(Level level, BlockPos blockPos, ServerLevel serverLevel, WildSpawnerConfig.SpawnerGroup spawnerGroup) {
        WildSpawnerConfig.SpawnerEntity spawnerEntity = spawnerGroup.entities.getRandom(level.f_46441_);
        if (spawnerEntity == null) {
            VaultMod.LOGGER.warn("Wild Spawner failed to spawn as there was no valid entity found in config for spawn group with minLevel {}", (Object)spawnerGroup.minLevel);
        } else {
            WildSpawnerTileEntity.spawnEntity(blockPos, serverLevel, spawnerEntity.type, spawnerEntity.nbt, false, () -> VaultMod.LOGGER.warn("Wild Spawner failed to spawn \"{}\" as it does not exist in entityType registry", (Object)spawnerEntity.type));
        }
    }

    private void initSpawnerGroup() {
        if (this.spawnerGroup == null) {
            int vaultLevel = ServerVaults.get(this.f_58857_).map(vault -> vault.get(Vault.LEVEL).get()).orElse(0);
            for (WildSpawnerConfig.SpawnerGroup sg : ModConfigs.WILD_SPAWNER.spawnerGroups) {
                if (sg.minLevel > vaultLevel || this.spawnerGroup != null && sg.minLevel <= this.spawnerGroup.minLevel) continue;
                this.spawnerGroup = sg;
            }
            if (this.spawnerGroup != null) {
                this.playerCheckCooldown = Math.min(this.spawnerGroup.blockCheckRadius / 4, 10);
            }
        }
    }
}

