/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity.base;

import iskallia.vault.block.base.FacedBlock;
import iskallia.vault.block.entity.base.FilteredInputInventoryTileEntity;
import iskallia.vault.block.entity.base.InventoryRetainerTileEntity;
import iskallia.vault.config.recipe.ForgeRecipeType;
import iskallia.vault.container.oversized.OverSizedInventory;
import iskallia.vault.container.oversized.OverSizedItemStack;
import iskallia.vault.integration.IntegrationRefinedStorage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public abstract class ForgeRecipeTileEntity
extends BlockEntity
implements MenuProvider,
FilteredInputInventoryTileEntity,
InventoryRetainerTileEntity {
    private final OverSizedInventory inventory;
    private final ResultContainer output = new ResultContainer(){

        public void m_6596_() {
            super.m_6596_();
            ForgeRecipeTileEntity.this.m_6596_();
        }
    };
    private final List<ForgeRecipeType> supportedRecipeTypes;

    public ForgeRecipeTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int inventorySize, ForgeRecipeType ... supportedRecipeTypes) {
        super(type, pos, state);
        this.inventory = new OverSizedInventory.FilteredInsert(inventorySize, this, this::canInsertRecipeInput);
        this.supportedRecipeTypes = new ArrayList<ForgeRecipeType>();
        this.supportedRecipeTypes.addAll(Arrays.asList(supportedRecipeTypes));
    }

    public OverSizedInventory getInventory() {
        return this.inventory;
    }

    public ResultContainer getResultContainer() {
        return this.output;
    }

    protected abstract AbstractContainerMenu createMenu(int var1, Inventory var2);

    public List<ForgeRecipeType> getSupportedRecipeTypes() {
        return this.supportedRecipeTypes;
    }

    public boolean stillValid(Player player) {
        if (this.m_58904_() == null || this.m_58904_().m_7702_(this.m_58899_()) != this) {
            return false;
        }
        return this.getInventory().m_6542_(player);
    }

    protected boolean canInsertRecipeInput(int slot, @Nonnull ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        return this.getSupportedRecipeTypes().stream().anyMatch(type -> type.getRecipeConfig().getInputItemCache().contains(stack.m_41720_()));
    }

    @Override
    public boolean isInventorySideAccessible(@Nullable Direction side) {
        return true;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (IntegrationRefinedStorage.shouldPreventImportingCapability(this.m_58904_(), this.m_58899_(), side)) {
            return super.getCapability(cap, side);
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.getInventoryCapability(side);
        }
        return super.getCapability(cap, side);
    }

    protected <T> LazyOptional<T> getInventoryCapability(Direction side) {
        return this.getFilteredInputCapability(side, new Container[]{this.inventory});
    }

    public Component m_5446_() {
        return this.m_58900_().m_60734_().m_49954_();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        if (this.m_58904_() == null) {
            return null;
        }
        return this.createMenu(windowId, playerInventory);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.getInventory().load(tag);
        this.getResultContainer().m_6836_(0, ItemStack.m_41712_((CompoundTag)tag.m_128469_("result")));
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.getInventory().save(tag);
        tag.m_128365_("result", (Tag)this.getResultContainer().m_8020_(0).serializeNBT());
    }

    public static InventoryRetainerTileEntity.ContentDisplayInfo addInventoryTooltip(ItemStack stack, CompoundTag tag) {
        return InventoryRetainerTileEntity.displayContentsOverSized(5, stacks -> {
            ItemStack result = ItemStack.m_41712_((CompoundTag)tag.m_128469_("result"));
            if (!result.m_41619_()) {
                stacks.add(OverSizedItemStack.of(result));
            }
            stacks.addAll(OverSizedInventory.loadContents("inventory", tag));
        });
    }

    @Override
    public void storeInventoryContents(CompoundTag tag) {
        this.getInventory().save("inventory", tag);
        tag.m_128365_("result", (Tag)this.getResultContainer().m_8020_(0).m_41777_().serializeNBT());
    }

    @Override
    public void loadInventoryContents(CompoundTag tag) {
        this.getInventory().load("inventory", tag);
        this.getResultContainer().m_6836_(0, ItemStack.m_41712_((CompoundTag)tag.m_128469_("result")));
    }

    @Override
    public void clearInventoryContents() {
        this.getInventory().m_6211_();
        this.getResultContainer().m_6211_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void spawnForgeParticles(BlockPos pos) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        for (int i = 0; i < 8; ++i) {
            Random random = level.m_5822_();
            Direction direction = level.m_8055_(pos).m_61138_((Property)FacedBlock.FACING) ? (Direction)level.m_8055_(pos).m_61143_((Property)FacedBlock.FACING) : Direction.NORTH;
            Direction.Axis direction$axis = direction.m_122434_();
            double x = (double)pos.m_123341_() + 0.5;
            double y = pos.m_123342_();
            double z = (double)pos.m_123343_() + 0.5;
            double d3 = -0.52;
            double d4 = random.nextDouble() * 0.6 - 0.3;
            double d5 = direction$axis == Direction.Axis.X ? (double)direction.m_122429_() * d3 : d4;
            double d6 = random.nextDouble() * 6.0 / 16.0;
            double d7 = direction$axis == Direction.Axis.Z ? (double)direction.m_122431_() * d3 : d4;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x + d5, y + d6, z + d7, 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123756_, x + d5, y + d6, z + d7, 0.0, 0.0, 0.0);
        }
    }
}

