/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity.base;

import iskallia.vault.container.oversized.OverSizedItemStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.extensions.IForgeBlockEntity;

public interface InventoryRetainerTileEntity
extends IForgeBlockEntity {
    public static ContentDisplayInfo displayContents(int maxDisplayCount, Consumer<List<ItemStack>> provideContentFn) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        provideContentFn.accept(stacks);
        return ContentDisplayInfo.makeStacks(stacks, maxDisplayCount);
    }

    public static ContentDisplayInfo displayContentsOverSized(int maxDisplayCount, Consumer<List<OverSizedItemStack>> provideContentFn) {
        ArrayList stacks = new ArrayList();
        provideContentFn.accept(stacks);
        return ContentDisplayInfo.makeStacks(stacks.stream().map(OverSizedItemStack::overSizedStack).toList(), maxDisplayCount);
    }

    public void storeInventoryContents(CompoundTag var1);

    public void loadInventoryContents(CompoundTag var1);

    public void clearInventoryContents();

    public record ContentDisplayInfo(List<Component> display, int displayCount, Function<Integer, Component> hasMoreCmp) {
        public static ContentDisplayInfo makeStacks(List<ItemStack> display, int maxDisplay) {
            return ContentDisplayInfo.make(ContentDisplayInfo.convertStacks(display), maxDisplay);
        }

        public static ContentDisplayInfo make(List<Component> display, int maxDisplay) {
            return new ContentDisplayInfo(display, Math.min(display.size(), maxDisplay), ContentDisplayInfo.defaultMoreComponent());
        }

        public ContentDisplayInfo append(ContentDisplayInfo additional) {
            return this.append(additional.display(), Math.max(additional.displayCount(), this.displayCount()));
        }

        public ContentDisplayInfo appendStacks(List<ItemStack> additional, int newMaxDisplay) {
            return this.append(ContentDisplayInfo.convertStacks(additional), newMaxDisplay);
        }

        public ContentDisplayInfo append(List<Component> additional, int newMaxDisplay) {
            ArrayList<Component> newDisplay = new ArrayList<Component>(this.display());
            newDisplay.addAll(additional);
            return new ContentDisplayInfo(newDisplay, Math.max(newDisplay.size(), newMaxDisplay), ContentDisplayInfo.defaultMoreComponent());
        }

        private static Function<Integer, Component> defaultMoreComponent() {
            return count -> {
                if (count <= 0) {
                    return null;
                }
                return new TextComponent("... " + count + " more").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC);
            };
        }

        private static List<Component> convertStacks(List<ItemStack> display) {
            return display.stream().map(stack -> {
                Component displayCmp = stack.m_41786_();
                MutableComponent countCmp = new TextComponent(stack.m_41613_() + "x ").m_130940_(ChatFormatting.WHITE);
                return new TextComponent("- ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)countCmp).m_7220_((Component)new TextComponent("").m_130940_(ChatFormatting.RESET).m_7220_(displayCmp));
            }).collect(Collectors.toList());
        }
    }
}

