/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity.challenge;

import com.google.gson.JsonObject;
import com.mojang.math.Vector3f;
import iskallia.vault.block.ChallengeControllerBlock;
import iskallia.vault.block.entity.challenge.ChallengeManager;
import iskallia.vault.client.particles.ColoredParticleOptions;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.basic.EnumAdapter;
import iskallia.vault.core.data.serializable.ISerializable;
import iskallia.vault.init.ModParticles;
import iskallia.vault.world.data.ChallengeData;
import java.awt.Color;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public abstract class ChallengeControllerBlockEntity<T extends ChallengeManager>
extends BlockEntity {
    protected UUID uuid;
    private Renderer renderer = new Renderer(0xFFFFFF, 0xFFFFFF, 0xFFFFFF);
    private State state = State.IDLE;
    private int ticker = 0;
    public int animationTick;

    public ChallengeControllerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(int coreColor, int glyphColor, int particleColor) {
        this.setRenderer(new Renderer(coreColor, glyphColor, particleColor));
    }

    public void setRenderer(Renderer renderer) {
        this.renderer = renderer;
        this.sendUpdates();
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
        this.ticker = 0;
        this.sendUpdates();
    }

    public int getTicker() {
        return this.ticker;
    }

    public void setTicker(int ticker) {
        this.ticker = ticker;
        this.sendUpdates();
    }

    public abstract T createManager();

    public void onTick(Level world, BlockPos pos, BlockState state) {
        if (world.m_5776_()) {
            if (this.state != State.IDLE) {
                ++this.animationTick;
            }
        } else if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            ChallengeData data = ChallengeData.get(serverWorld.m_142572_());
            if (this.state != State.DESTROYED && !data.contains(this.uuid)) {
                data.add(serverWorld, (ChallengeManager)this.createManager());
            }
            Color color = new Color(this.getRenderer().getParticleColor());
            if ((this.getState() == State.GENERATING || this.getState() == State.ACTIVE) && serverWorld.m_46467_() % 3L == 0L) {
                serverWorld.m_8767_((ParticleOptions)new ColoredParticleOptions((ParticleType<ColoredParticleOptions>)((ParticleType)ModParticles.TOTEM_FOUNTAIN.get()), new Vector3f(color.getColorComponents(new float[3]))), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.5, (double)pos.m_123343_() + 0.5, 5, 0.075, 0.0, 0.075, 0.0);
            }
            if (this.getState() == State.GENERATING && this.getTicker() >= 50) {
                this.setState(State.ACTIVE);
            }
            if (this.getState() == State.ACTIVE && this.getTicker() % 160 == 0) {
                world.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11737_, SoundSource.PLAYERS, 1.0f, 0.5f);
            }
            this.setTicker(this.getTicker() + 1);
        }
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_()).m_82400_(2.0);
    }

    public static void tick(Level world, BlockPos pos, BlockState state, ChallengeControllerBlockEntity<?> entity) {
        entity.onTick(world, pos, state);
    }

    protected Rotation getRotation() {
        return switch ((Direction)this.m_58900_().m_61143_((Property)ChallengeControllerBlock.FACING)) {
            case Direction.NORTH -> Rotation.COUNTERCLOCKWISE_90;
            case Direction.SOUTH -> Rotation.CLOCKWISE_90;
            case Direction.WEST -> Rotation.CLOCKWISE_180;
            case Direction.EAST -> Rotation.NONE;
            default -> throw new UnsupportedOperationException();
        };
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        Adapters.UUID.writeNbt(this.uuid).ifPresent(tag -> nbt.m_128365_("uuid", tag));
        this.renderer.writeNbt().ifPresent(tag -> nbt.m_128365_("renderer", (Tag)tag));
        Adapters.ofEnum(State.class, EnumAdapter.Mode.NAME).writeNbt(this.state).ifPresent(tag -> nbt.m_128365_("state", tag));
        Adapters.INT.writeNbt(this.ticker).ifPresent(tag -> nbt.m_128365_("ticker", tag));
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.uuid = Adapters.UUID.readNbt(nbt.m_128423_("uuid")).orElseGet(Mth::m_14002_);
        this.renderer.readNbt(nbt.m_128469_("renderer"));
        this.state = Adapters.ofEnum(State.class, EnumAdapter.Mode.NAME).readNbt(nbt.m_128423_("state")).orElse(State.IDLE);
        this.ticker = Adapters.INT.readNbt(nbt.m_128423_("ticker")).orElse(0);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void sendUpdates() {
        if (this.f_58857_ == null) {
            return;
        }
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        this.m_6596_();
    }

    public static class Renderer
    implements ISerializable<CompoundTag, JsonObject> {
        private int coreColor;
        private int glyphColor;
        private int particleColor;

        public Renderer(int coreColor, int glyphColor, int particleColor) {
            this.coreColor = coreColor;
            this.glyphColor = glyphColor;
            this.particleColor = particleColor;
        }

        public int getCoreColor() {
            return this.coreColor;
        }

        public int getGlyphColor() {
            return this.glyphColor;
        }

        public int getParticleColor() {
            return this.particleColor;
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            return Optional.of(new CompoundTag()).map(nbt -> {
                Adapters.INT.writeNbt(this.coreColor).ifPresent(tag -> nbt.m_128365_("coreColor", tag));
                Adapters.INT.writeNbt(this.glyphColor).ifPresent(tag -> nbt.m_128365_("glyphColor", tag));
                Adapters.INT.writeNbt(this.particleColor).ifPresent(tag -> nbt.m_128365_("particleColor", tag));
                return nbt;
            });
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            this.coreColor = Adapters.INT.readNbt(nbt.m_128423_("coreColor")).orElse(0xFFFFFF);
            this.glyphColor = Adapters.INT.readNbt(nbt.m_128423_("glyphColor")).orElse(0xFFFFFF);
            this.particleColor = Adapters.INT.readNbt(nbt.m_128423_("particleColor")).orElse(0xFFFFFF);
        }
    }

    public static enum State {
        IDLE,
        GENERATING,
        ACTIVE,
        DESTROYED;

    }
}

