/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity.challenge;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.block.entity.challenge.ChallengeControllerBlockEntity;
import iskallia.vault.block.entity.challenge.elite.EliteChallengeManager;
import iskallia.vault.block.entity.challenge.raid.RaidChallengeManager;
import iskallia.vault.block.entity.challenge.xmark.XMarkChallengeManager;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.basic.TypeSupplierAdapter;
import iskallia.vault.core.data.serializable.ISerializable;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.BlockUseEvent;
import iskallia.vault.util.SidedHelper;
import iskallia.vault.world.data.ChallengeData;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;

public class ChallengeManager
implements ISerializable<CompoundTag, JsonObject> {
    public UUID uuid;
    public ResourceKey<Level> dimension;
    public BlockPos pos;
    public Set<UUID> players;
    public boolean deleted;

    protected ChallengeManager() {
        this.players = new HashSet<UUID>();
    }

    public ChallengeManager(UUID uuid, ResourceKey<Level> dimension, BlockPos pos) {
        this.uuid = uuid;
        this.dimension = dimension;
        this.pos = pos;
        this.players = new HashSet<UUID>();
    }

    public boolean addPlayer(Player player) {
        return this.players.add(player.m_142081_());
    }

    public boolean removePlayer(Player player) {
        if (this.players.remove(player.m_142081_())) {
            ServerPlayer serverPlayer;
            if (player instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player).m_20194_() != null) {
                ChallengeData.get(serverPlayer.m_20194_()).sendUpdatesToClient(serverPlayer);
            }
            return true;
        }
        return false;
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return Optional.of(new CompoundTag()).map(nbt -> {
            Adapters.UUID.writeNbt(this.uuid).ifPresent(tag -> nbt.m_128365_("uuid", tag));
            Adapters.DIMENSION.writeNbt(this.dimension).ifPresent(tag -> nbt.m_128365_("dimension", tag));
            Adapters.BLOCK_POS.writeNbt(this.pos).ifPresent(tag -> nbt.m_128365_("pos", tag));
            ListTag list = new ListTag();
            for (UUID player : this.players) {
                Adapters.UUID.writeNbt(player).ifPresent(arg_0 -> list.add(arg_0));
            }
            nbt.m_128365_("players", (Tag)list);
            Adapters.BOOLEAN.writeNbt(this.deleted).ifPresent(tag -> nbt.m_128365_("deleted", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        this.uuid = Adapters.UUID.readNbt(nbt.m_128423_("uuid")).orElseThrow();
        this.dimension = Adapters.DIMENSION.readNbt(nbt.m_128423_("dimension")).orElseThrow();
        this.pos = Adapters.BLOCK_POS.readNbt(nbt.m_128423_("pos")).orElseThrow();
        this.players.clear();
        Tag tag = nbt.m_128423_("players");
        if (tag instanceof ListTag) {
            ListTag list = (ListTag)tag;
            for (Tag tag2 : list) {
                Adapters.UUID.readNbt(tag2).ifPresent(this.players::add);
            }
        }
        this.deleted = Adapters.BOOLEAN.readNbt(nbt.m_128423_("deleted")).orElse(false);
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public BlockEntity getBlockEntity(MinecraftServer server) {
        ServerLevel world = server.m_129880_(this.dimension);
        if (world == null) {
            return null;
        }
        return world.m_7702_(this.pos);
    }

    public void onAttach(ServerLevel world) {
        CommonEvents.BLOCK_USE.at(BlockUseEvent.Phase.HEAD).register(this, data -> {
            if (data.getHand() != InteractionHand.MAIN_HAND) {
                data.setResult(InteractionResult.SUCCESS);
                return;
            }
            if (data.getWorld() != world) {
                return;
            }
            if (!data.getPos().equals((Object)this.pos)) {
                return;
            }
            this.onClick(world, data.getPlayer());
        });
        CommonEvents.SERVER_TICK.at(TickEvent.Phase.END).register(this, event -> this.onTick(world));
    }

    public void onTick(ServerLevel world) {
    }

    public void onRemove(MinecraftServer server) {
    }

    public void onClick(ServerLevel world, Player player) {
        ChallengeControllerBlockEntity controller;
        BlockEntity blockEntity = world.m_7702_(this.pos);
        if (blockEntity instanceof ChallengeControllerBlockEntity && (controller = (ChallengeControllerBlockEntity)blockEntity).getState() == ChallengeControllerBlockEntity.State.IDLE) {
            world.m_5594_(null, this.pos, SoundEvents.f_11868_, SoundSource.MASTER, 1.0f, 0.7f);
            controller.setState(ChallengeControllerBlockEntity.State.GENERATING);
        }
    }

    public void onDetach() {
        CommonEvents.release(this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onRender(PoseStack matrixStack, float partialTicks, Window window) {
    }

    protected int getHighestVaultLevel(ServerLevel world) {
        int highest = 0;
        for (UUID uuid : this.players) {
            ServerPlayer player = world.m_142572_().m_6846_().m_11259_(uuid);
            if (player == null) continue;
            highest = Math.max(highest, SidedHelper.getVaultLevel((Player)player));
        }
        return highest;
    }

    public boolean shouldRenderObjectives() {
        return false;
    }

    public static class Adapter
    extends TypeSupplierAdapter<ChallengeManager> {
        public Adapter() {
            super("type", true);
            this.register("raid", RaidChallengeManager.class, RaidChallengeManager::new);
            this.register("x-mark", XMarkChallengeManager.class, XMarkChallengeManager::new);
            this.register("elite", EliteChallengeManager.class, EliteChallengeManager::new);
        }
    }
}

