/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity.challenge.elite;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import iskallia.vault.VaultMod;
import iskallia.vault.block.challenge.EliteControllerProxyBlock;
import iskallia.vault.block.entity.challenge.ChallengeControllerBlockEntity;
import iskallia.vault.block.entity.challenge.ChallengeManager;
import iskallia.vault.block.entity.challenge.elite.EliteAnimation;
import iskallia.vault.block.entity.challenge.elite.EliteControllerProxyBlockEntity;
import iskallia.vault.block.entity.challenge.elite.EliteSpawner;
import iskallia.vault.block.entity.challenge.raid.ChallengeActionEntry;
import iskallia.vault.block.entity.challenge.raid.action.ChallengeAction;
import iskallia.vault.client.gui.helper.LightmapHelper;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.array.ArrayAdapter;
import iskallia.vault.core.data.serializable.ISerializable;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.BlockUseEvent;
import iskallia.vault.core.random.ChunkRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.core.world.data.entity.PartialEntity;
import iskallia.vault.core.world.storage.BlockCuboid;
import iskallia.vault.core.world.storage.IZonedWorld;
import iskallia.vault.core.world.storage.WorldZone;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.AbsorbingParticleMessage;
import iskallia.vault.world.data.ServerVaults;
import iskallia.vault.world.data.WorldZonesData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public class EliteChallengeManager
extends ChallengeManager {
    private final Map<BlockPos, Proxy> proxies = new LinkedHashMap<BlockPos, Proxy>();
    private int zoneId;
    private BlockCuboid zone;
    private final EliteSpawner spawner;
    private final EliteAnimation animation;
    private final List<ChallengeAction<?>> actions;
    private final List<ChallengeAction<?>> scheduledActions;
    private BlockPos selected;
    public static ArrayAdapter<ChallengeAction<?>> ACTIONS = Adapters.ofArray(ChallengeAction[]::new, Adapters.CHALLENGE_ACTION);
    public static final ResourceLocation HUD = VaultMod.id("textures/gui/challenge/elite/hud.png");

    public EliteChallengeManager() {
        this.spawner = new EliteSpawner();
        this.animation = new EliteAnimation();
        this.actions = new ArrayList();
        this.scheduledActions = new ArrayList();
    }

    public EliteChallengeManager(UUID uuid, ResourceKey<Level> dimension, BlockPos pos) {
        super(uuid, dimension, pos);
        this.zoneId = -1;
        this.spawner = new EliteSpawner();
        this.animation = new EliteAnimation();
        this.actions = new ArrayList();
        this.scheduledActions = new ArrayList();
    }

    public Map<BlockPos, Proxy> getProxies() {
        return this.proxies;
    }

    public BlockCuboid getZone() {
        return this.zone;
    }

    public void setZone(BlockCuboid zone) {
        this.zone = zone;
    }

    public EliteSpawner getSpawner() {
        return this.spawner;
    }

    @Override
    public void onAttach(ServerLevel world) {
        super.onAttach(world);
        CommonEvents.BLOCK_USE.at(BlockUseEvent.Phase.HEAD).of(ModBlocks.ELITE_CONTROLLER_PROXY).register(this, data -> {
            if (data.getHand() != InteractionHand.MAIN_HAND) {
                data.setResult(InteractionResult.SUCCESS);
                return;
            }
            if (data.getWorld() != world) {
                return;
            }
            if (!this.proxies.containsKey(data.getPos().m_141950_((Vec3i)this.pos))) {
                return;
            }
            BlockEntity patt5444$temp = data.getWorld().m_7702_(data.getPos());
            if (patt5444$temp instanceof EliteControllerProxyBlockEntity) {
                EliteControllerProxyBlockEntity proxy = (EliteControllerProxyBlockEntity)patt5444$temp;
                this.onProxyClick(world, proxy);
            }
        });
        CommonEvents.ENTITY_DAMAGE.register((Object)this, EventPriority.HIGHEST, event -> {
            if (world != event.getEntity().f_19853_) {
                return;
            }
            for (Proxy proxy : this.proxies.values()) {
                if (!event.getEntity().m_142081_().equals(proxy.display)) continue;
                event.setCanceled(true);
                return;
            }
        });
    }

    @Override
    public void onClick(ServerLevel world, Player player) {
        BlockEntity blockEntity;
        if (this.selected != null && (blockEntity = world.m_7702_(this.selected.m_141952_((Vec3i)this.pos))) instanceof EliteControllerProxyBlockEntity) {
            EliteControllerProxyBlockEntity entity = (EliteControllerProxyBlockEntity)blockEntity;
            if (this.animation.getState() == EliteAnimation.State.PROXIES) {
                this.scheduledActions.addAll(entity.getActions());
                this.animation.onStart(EliteAnimation.State.CLOSE_ROOM);
                super.onClick(world, player);
            }
        } else {
            player.m_5661_((Component)new TextComponent("Select an elite first.").m_130940_(ChatFormatting.RED), true);
        }
    }

    @Override
    public void onTick(ServerLevel world) {
        if (this.isDeleted()) {
            return;
        }
        this.refreshPlayers(world);
        ChunkRandom random = ChunkRandom.any();
        random.setDecoratorSeed(ServerVaults.get((Level)world).map(vault -> vault.get(Vault.SEED)).orElse(0L), this.pos.m_123341_(), this.pos.m_123343_(), 329057345);
        if (this.zoneId < 0 && this.zone != null) {
            this.zoneId = WorldZonesData.get(world.m_142572_()).getOrCreate((ResourceKey<Level>)world.m_46472_()).add(new WorldZone().add(this.zone).setModify(false));
        }
        if (this.animation.getState() == EliteAnimation.State.IDLE) {
            this.summonProxies(world, random);
            this.animation.onStart(EliteAnimation.State.PROXIES);
        }
        if (this.animation.getState() == EliteAnimation.State.CLOSE_ROOM && this.animation.isCompleted()) {
            IZonedWorld.runWithBypass(world, true, () -> {
                for (BlockPos pos : this.proxies.keySet()) {
                    world.m_46961_(this.pos.m_141952_((Vec3i)pos), false);
                }
            });
            this.spawner.onSpawn(world, this.pos, this.proxies.get((Object)this.selected).elite);
            this.animation.onStart(EliteAnimation.State.FIGHT);
        }
        if (this.animation.getState() == EliteAnimation.State.FIGHT && this.spawner.isCompleted()) {
            this.computeScheduledActions(world, random);
            this.animation.onStart(EliteAnimation.State.OPEN_ROOM);
        }
        if (this.animation.getState() == EliteAnimation.State.OPEN_ROOM && this.animation.isCompleted()) {
            this.setDeleted(true);
        }
        for (Proxy proxy : this.proxies.values()) {
            Player player;
            Entity entity = world.m_8791_(proxy.display);
            if (entity == null || (player = world.m_5788_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 48.0, target -> !target.m_5833_())) == null) continue;
            entity.m_7618_(EntityAnchorArgument.Anchor.EYES, player.m_146892_());
        }
        this.spawner.onTick(world);
        this.animation.onTick(world, this.pos, this.proxies);
    }

    private void summonProxies(ServerLevel world, RandomSource random) {
        int vaultlevel = VaultUtils.getVault((Level)world).map(vault -> vault.get(Vault.LEVEL).get()).orElse(this.getHighestVaultLevel(world));
        this.proxies.forEach((offset, proxy) -> {
            Direction facing = Direction.m_122378_((int)Integer.compare(offset.m_123341_(), 0), (int)Integer.compare(offset.m_123342_(), 0), (int)Integer.compare(offset.m_123343_(), 0));
            if (facing == null) {
                return;
            }
            BlockPos proxyPos = this.pos.m_141952_((Vec3i)offset);
            IZonedWorld.runWithBypass(world, true, () -> {
                world.m_7731_(proxyPos, (BlockState)ModBlocks.ELITE_CONTROLLER_PROXY.m_49966_().m_61124_((Property)EliteControllerProxyBlock.FACING, (Comparable)facing.m_122424_()), 3);
                if (proxy.display != null) {
                    return;
                }
                EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(proxy.elite.getId());
                BlockPos displayPos = proxyPos.m_5484_(facing, 2).m_5484_(Direction.UP, 1);
                Entity entity = type.m_20600_(world, null, null, null, displayPos, MobSpawnType.SPAWNER, false, false);
                proxy.elite.getNbt().asWhole().ifPresent(nbt -> entity.deserializeNBT(nbt));
                entity.m_6034_((double)displayPos.m_123341_() + 0.5, (double)displayPos.m_123342_(), (double)displayPos.m_123343_() + 0.5);
                entity.m_20331_(true);
                entity.m_20225_(true);
                if (entity instanceof Mob) {
                    Mob mob = (Mob)entity;
                    mob.m_21557_(true);
                    mob.m_20242_(true);
                    mob.m_6863_(false);
                    mob.m_21530_();
                }
                proxy.display = entity.m_142081_();
            });
            BlockEntity patt10588$temp = world.m_7702_(proxyPos);
            if (patt10588$temp instanceof EliteControllerProxyBlockEntity) {
                EliteControllerProxyBlockEntity entity = (EliteControllerProxyBlockEntity)patt10588$temp;
                entity.setActions(ChallengeAction.merge(proxy.entries.stream().map(entry -> {
                    if (random.nextFloat() >= entry.getProbability()) {
                        return null;
                    }
                    entry = entry.copy();
                    entry.onPopulate(random);
                    return entry;
                }).filter(Objects::nonNull).flatMap(entry -> entry.getActions().stream()).flatMap(action -> action.flatten(random, vaultlevel)).peek(action -> action.onPopulate(random)).collect(Collectors.toList())));
                entity.setController(this.pos);
            }
            world.m_5594_(null, this.pos, SoundEvents.f_12653_, SoundSource.BLOCKS, 1.4f, 1.0f);
        });
    }

    public void onProxyClick(ServerLevel world, EliteControllerProxyBlockEntity proxy) {
        if (this.animation.getState() == EliteAnimation.State.PROXIES) {
            ChunkRandom random = ChunkRandom.any();
            random.setDecoratorSeed(ServerVaults.get((Level)world).map(vault -> vault.get(Vault.SEED)).orElse(0L), this.pos.m_123341_(), this.pos.m_123343_(), 390973451);
            BlockEntity blockEntity = this.getBlockEntity(world.m_142572_());
            if (blockEntity instanceof ChallengeControllerBlockEntity) {
                ChallengeControllerBlockEntity controller = (ChallengeControllerBlockEntity)blockEntity;
                world.m_5594_(null, controller.m_58899_(), SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, 2.0f);
                world.m_5594_(null, controller.m_58899_(), SoundEvents.f_11767_, SoundSource.BLOCKS, 1.0f, 2.0f);
                ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new AbsorbingParticleMessage(new Vec3((double)proxy.m_58899_().m_123341_() + 0.5, (double)proxy.m_58899_().m_123342_(), (double)proxy.m_58899_().m_123343_() + 0.5), new Vec3((double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_() + 1.65, (double)this.pos.m_123343_() + 0.5), controller.getRenderer().getParticleColor()));
                this.selected = proxy.m_58899_().m_141950_((Vec3i)this.pos);
            }
        }
    }

    public void refreshPlayers(ServerLevel world) {
        HashSet<ServerPlayer> toRemove = new HashSet<ServerPlayer>();
        for (UUID uuid : this.players) {
            ServerPlayer player = world.m_142572_().m_6846_().m_11259_(uuid);
            if (player == null || player.f_19853_ == world && this.zone.grow(-1, -1, -1).contains((Vec3i)player.m_142538_())) continue;
            toRemove.add(player);
        }
        for (ServerPlayer player : toRemove) {
            this.removePlayer((Player)player);
        }
        for (ServerPlayer player : world.m_6907_()) {
            if (!this.zone.grow(-1, -1, -1).contains((Vec3i)player.m_142538_())) continue;
            this.addPlayer((Player)player);
        }
    }

    @Override
    public void onRemove(MinecraftServer server) {
        BlockEntity blockEntity;
        if (this.zoneId >= 0) {
            WorldZonesData.get(server).getOrCreate((ResourceKey<Level>)this.dimension).remove(this.zoneId);
        }
        if ((blockEntity = this.getBlockEntity(server)) instanceof ChallengeControllerBlockEntity) {
            ChallengeControllerBlockEntity controller = (ChallengeControllerBlockEntity)blockEntity;
            controller.setState(ChallengeControllerBlockEntity.State.DESTROYED);
            controller.m_58904_().m_5594_(null, controller.m_58899_(), SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, 2.0f);
            controller.m_58904_().m_5594_(null, controller.m_58899_(), SoundEvents.f_11983_, SoundSource.BLOCKS, 1.0f, 2.0f);
            ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new AbsorbingParticleMessage(new Vec3((double)controller.m_58899_().m_123341_(), (double)controller.m_58899_().m_123342_() + 1.65, (double)controller.m_58899_().m_123343_()), new Vec3((double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_() + 1.65, (double)this.pos.m_123343_() + 0.5), controller.getRenderer().getParticleColor()));
        }
    }

    public void computeScheduledActions(ServerLevel world, RandomSource random) {
        int vaultlevel = VaultUtils.getVault((Level)world).map(vault -> vault.get(Vault.LEVEL).get()).orElse(this.getHighestVaultLevel(world));
        List<ChallengeAction<?>> merged = ChallengeAction.merge(this.scheduledActions.stream().map(action -> {
            action = action.copy();
            action.onPopulate(random);
            return action;
        }).flatMap(action -> action.flatten(random, vaultlevel)).peek(action -> {
            action.onPopulate(random);
            action.onActivate(world, this, random);
        }).collect(Collectors.toList()));
        ChallengeAction.merge(this.actions, merged);
        this.scheduledActions.clear();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.BLOCK_CUBOID.writeNbt(this.zone).ifPresent(tag -> nbt.m_128365_("zone", tag));
            Adapters.INT.writeNbt(this.zoneId).ifPresent(tag -> nbt.m_128365_("zoneId", tag));
            this.spawner.writeNbt().ifPresent(tag -> nbt.m_128365_("spawner", (Tag)tag));
            ListTag proxies = new ListTag();
            this.proxies.forEach((pos, proxy) -> {
                CompoundTag entry = new CompoundTag();
                Adapters.BLOCK_POS.writeNbt((BlockPos)pos).ifPresent(tag -> entry.m_128365_("pos", tag));
                proxy.writeNbt().ifPresent(tag -> entry.m_128365_("proxy", (Tag)tag));
                proxies.add((Object)entry);
            });
            nbt.m_128365_("proxies", (Tag)proxies);
            ACTIONS.writeNbt((ChallengeAction<?>)((ChallengeAction[])this.actions.toArray(ChallengeAction[]::new))).ifPresent(tag -> nbt.m_128365_("actions", tag));
            ACTIONS.writeNbt((ChallengeAction<?>)((ChallengeAction[])this.scheduledActions.toArray(ChallengeAction[]::new))).ifPresent(tag -> nbt.m_128365_("scheduledActions", tag));
            Adapters.BLOCK_POS.writeNbt(this.selected).ifPresent(tag -> nbt.m_128365_("selected", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.zone = Adapters.BLOCK_CUBOID.readNbt(nbt.m_128423_("zone")).orElse(null);
        this.zoneId = Adapters.INT.readNbt(nbt.m_128423_("zoneId")).orElse(-1);
        this.spawner.readNbt(nbt.m_128469_("spawner"));
        ListTag proxies = nbt.m_128437_("proxies", 10);
        this.proxies.clear();
        for (int i = 0; i < proxies.size(); ++i) {
            CompoundTag entry = proxies.m_128728_(i);
            Proxy proxy = new Proxy();
            proxy.readNbt(entry.m_128469_("proxy"));
            this.proxies.put(Adapters.BLOCK_POS.readNbt(entry.m_128423_("pos")).orElseThrow(), proxy);
        }
        this.actions.clear();
        ACTIONS.readNbt(nbt.m_128423_("actions")).ifPresent(actions -> this.actions.addAll(Arrays.asList(actions)));
        this.scheduledActions.clear();
        ACTIONS.readNbt(nbt.m_128423_("scheduledActions")).ifPresent(actions -> this.scheduledActions.addAll(Arrays.asList(actions)));
        this.selected = Adapters.BLOCK_POS.readNbt(nbt.m_128423_("selected")).orElse(null);
    }

    @Override
    public boolean shouldRenderObjectives() {
        return this.spawner.isCompleted();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onRender(PoseStack matrixStack, float partialTicks, Window window) {
        if (this.spawner.isCompleted()) {
            return;
        }
        TextComponent txt = new TextComponent("Defeat the Elite");
        int midX = window.m_85445_() / 2;
        matrixStack.m_85836_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int previousTexture = RenderSystem.m_157203_((int)0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)HUD);
        double progress = this.spawner.getCurrentHealth() / this.spawner.getTotalHealth();
        matrixStack.m_85837_((double)(midX - 80), 8.0, 0.0);
        GuiComponent.m_93133_((PoseStack)matrixStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)200, (int)26, (int)200, (int)50);
        GuiComponent.m_93133_((PoseStack)matrixStack, (int)0, (int)8, (float)0.0f, (float)28.0f, (int)(15 + (int)(130.0 * progress)), (int)10, (int)200, (int)50);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157453_((int)0, (int)previousTexture);
        matrixStack.m_85849_();
        Font font = Minecraft.m_91087_().f_91062_;
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        matrixStack.m_85836_();
        matrixStack.m_85841_(0.6f, 0.6f, 0.6f);
        FormattedCharSequence formattedCharSequence = txt.m_7532_();
        float f = (float)midX / 0.6f - (float)font.m_92852_((FormattedText)txt) / 2.0f;
        Objects.requireNonNull(font);
        font.m_92733_(formattedCharSequence, f, (float)(9 + 22), -1, true, matrixStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, false, 0, LightmapHelper.getPackedFullbrightCoords());
        buffer.m_109911_();
        matrixStack.m_85849_();
    }

    public static class Proxy
    implements ISerializable<CompoundTag, JsonObject> {
        public List<ChallengeActionEntry> entries;
        public PartialEntity elite;
        public UUID display;
        public static ArrayAdapter<ChallengeActionEntry> ENTRIES = Adapters.ofArray(ChallengeActionEntry[]::new, Adapters.of(ChallengeActionEntry::new, false));

        public Proxy() {
        }

        public Proxy(List<ChallengeActionEntry> entries, PartialEntity elite) {
            this.entries = entries;
            this.elite = elite;
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            return Optional.of(new CompoundTag()).map(nbt -> {
                ENTRIES.writeNbt((ChallengeActionEntry)((ChallengeActionEntry[])this.entries.toArray(ChallengeActionEntry[]::new))).ifPresent(tag -> nbt.m_128365_("entries", tag));
                Adapters.PARTIAL_ENTITY.writeNbt(this.elite).ifPresent(tag -> nbt.m_128365_("elite", tag));
                Adapters.UUID.writeNbt(this.display).ifPresent(tag -> nbt.m_128365_("display", tag));
                return nbt;
            });
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            this.entries = Arrays.stream((ChallengeActionEntry[])ENTRIES.readNbt(nbt.m_128423_("entries")).orElseThrow()).collect(Collectors.toList());
            this.elite = Adapters.PARTIAL_ENTITY.readNbt(nbt.m_128423_("elite")).orElse(null);
            this.display = Adapters.UUID.readNbt(nbt.m_128423_("display")).orElse(null);
        }
    }
}

