/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity.challenge.elite;

import iskallia.vault.block.entity.challenge.raid.action.ChallengeAction;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.init.ModBlocks;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class EliteControllerProxyBlockEntity
extends BlockEntity {
    private BlockPos controller;
    private List<ChallengeAction<?>> actions = new ArrayList();

    public EliteControllerProxyBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.ELITE_CONTROLLER_PROXY_TILE_ENTITY, pos, state);
    }

    public BlockPos getController() {
        return this.controller;
    }

    public void setController(BlockPos controller) {
        this.controller = controller;
        this.sendUpdates();
    }

    public List<ChallengeAction<?>> getActions() {
        return this.actions;
    }

    public void setActions(List<ChallengeAction<?>> actions) {
        this.actions = actions;
        this.sendUpdates();
    }

    public static void tick(Level world, BlockPos pos, BlockState state, EliteControllerProxyBlockEntity entity) {
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        Adapters.BLOCK_POS.writeNbt(this.controller).ifPresent(tag -> nbt.m_128365_("controller", tag));
        ListTag actions = new ListTag();
        for (ChallengeAction<?> action : this.actions) {
            Adapters.CHALLENGE_ACTION.writeNbt(action).ifPresent(arg_0 -> actions.add(arg_0));
        }
        nbt.m_128365_("actions", (Tag)actions);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.controller = Adapters.BLOCK_POS.readNbt(nbt.m_128423_("controller")).orElse(null);
        ListTag actions = nbt.m_128437_("actions", 10);
        this.actions.clear();
        for (Tag tag : actions) {
            Adapters.CHALLENGE_ACTION.readNbt(tag).ifPresent(action -> this.actions.add((ChallengeAction<?>)action));
        }
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void sendUpdates() {
        if (this.f_58857_ == null) {
            return;
        }
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        this.m_6596_();
    }
}

