/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity.challenge.elite;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.serializable.ISerializable;
import iskallia.vault.core.world.data.entity.PartialEntity;
import iskallia.vault.entity.entity.elite.EliteZombieEntity;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraftforge.registries.ForgeRegistries;

public class EliteSpawner
implements ISerializable<CompoundTag, JsonObject> {
    private double currentHealth;
    private double totalHealth;
    private UUID bossId;

    public double getCurrentHealth() {
        return this.currentHealth;
    }

    public double getTotalHealth() {
        return this.totalHealth;
    }

    public boolean isCompleted() {
        return this.bossId == null;
    }

    public void onTick(ServerLevel world) {
        this.updateHealth(world);
    }

    private void updateHealth(ServerLevel world) {
        if (this.bossId == null) {
            return;
        }
        Entity entity = world.m_8791_(this.bossId);
        if (entity == null) {
            this.bossId = null;
        } else {
            double total = 0.0;
            this.currentHealth = 0.0;
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                this.currentHealth += (double)living.m_21223_();
                total += (double)living.m_21233_();
            }
            if (total > this.totalHealth) {
                this.totalHealth = total;
            }
        }
    }

    public void onSpawn(ServerLevel world, BlockPos pos, PartialEntity elite) {
        EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(elite.getId());
        Entity entity = type.m_20600_(world, null, null, null, pos, MobSpawnType.SPAWNER, false, false);
        elite.getNbt().asWhole().ifPresent(nbt -> entity.deserializeNBT(nbt));
        entity.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
        if (entity instanceof EliteZombieEntity) {
            EliteZombieEntity eliteZombie = (EliteZombieEntity)entity;
            eliteZombie.setControllerPos(pos);
        }
        world.m_7967_(entity);
        this.bossId = entity.m_142081_();
        this.updateHealth(world);
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return Optional.of(new CompoundTag()).map(nbt -> {
            Adapters.DOUBLE.writeNbt(this.currentHealth).ifPresent(tag -> nbt.m_128365_("currentHealth", tag));
            Adapters.DOUBLE.writeNbt(this.totalHealth).ifPresent(tag -> nbt.m_128365_("totalHealth", tag));
            Adapters.UUID.writeNbt(this.bossId).ifPresent(tag -> nbt.m_128365_("bossId", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        this.currentHealth = Adapters.DOUBLE.readNbt(nbt.m_128423_("currentHealth")).orElse(0.0);
        this.totalHealth = Adapters.DOUBLE.readNbt(nbt.m_128423_("totalHealth")).orElse(0.0);
        this.bossId = Adapters.UUID.readNbt(nbt.m_128423_("bossId")).orElse(null);
    }
}

