/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity.challenge.raid;

import com.google.gson.JsonObject;
import iskallia.vault.block.entity.challenge.raid.action.ChallengeAction;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.serializable.ISerializable;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.world.roll.IntRoll;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class ChallengeActionEntry
implements ISerializable<CompoundTag, JsonObject> {
    private final Config config = new Config();
    private boolean populated = false;
    private int count;

    public Config getConfig() {
        return this.config;
    }

    public boolean isPopulated() {
        return this.populated;
    }

    public void setPopulated(boolean populated) {
        this.populated = populated;
    }

    public float getProbability() {
        return this.getConfig().probability;
    }

    public void onPopulate(RandomSource random) {
        if (this.getConfig().count != null) {
            this.count = this.getConfig().count.get(random);
        }
        this.setPopulated(true);
    }

    public List<ChallengeAction<?>> getActions() {
        ArrayList actions = new ArrayList();
        for (int i = 0; i < this.count; ++i) {
            actions.add(this.getConfig().action);
        }
        return actions;
    }

    public <T extends ChallengeActionEntry> T copy() {
        ChallengeActionEntry entry = new ChallengeActionEntry();
        entry.readNbt(this.writeNbt().orElseThrow());
        return (T)entry;
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return Optional.of(new CompoundTag()).map(nbt -> {
            if (!this.isPopulated()) {
                this.config.writeNbt().ifPresent(tag -> {
                    for (String key : tag.m_128431_()) {
                        nbt.m_128365_(key, Objects.requireNonNull(tag.m_128423_(key)));
                    }
                });
            } else {
                this.config.writeNbt().ifPresent(tag -> nbt.m_128365_("config", (Tag)tag));
                Adapters.BOOLEAN.writeNbt(this.populated).ifPresent(tag -> nbt.m_128365_("populated", tag));
            }
            Adapters.INT.writeNbt(this.count).ifPresent(tag -> nbt.m_128365_("count", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        if (nbt.m_128441_("config")) {
            this.config.readNbt(nbt.m_128469_("config"));
        } else {
            this.config.readNbt(nbt);
        }
        this.populated = Adapters.BOOLEAN.readNbt(nbt.m_128423_("populated")).orElse(false);
        this.count = Adapters.INT.readNbt(nbt.m_128423_("count")).orElse(0);
    }

    public static class Config
    implements ISerializable<CompoundTag, JsonObject> {
        private ChallengeAction<?> action;
        private float probability;
        private IntRoll count;

        @Override
        public Optional<CompoundTag> writeNbt() {
            return Optional.of(new CompoundTag()).map(nbt -> {
                Adapters.CHALLENGE_ACTION.writeNbt(this.action).ifPresent(tag -> nbt.m_128365_("action", tag));
                Adapters.FLOAT.writeNbt(Float.valueOf(this.probability)).ifPresent(tag -> nbt.m_128365_("probability", tag));
                Adapters.INT_ROLL.writeNbt(this.count).ifPresent(tag -> nbt.m_128365_("count", tag));
                return nbt;
            });
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            this.action = (ChallengeAction)Adapters.CHALLENGE_ACTION.readNbt(nbt.m_128423_("action")).orElseThrow();
            this.probability = ((Float)Adapters.FLOAT.readNbt(nbt.m_128423_("probability")).orElseThrow()).floatValue();
            this.count = (IntRoll)Adapters.INT_ROLL.readNbt(nbt.m_128423_("count")).orElseThrow();
        }
    }
}

