/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity.challenge.raid;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import iskallia.vault.VaultMod;
import iskallia.vault.block.entity.challenge.ChallengeControllerBlockEntity;
import iskallia.vault.block.entity.challenge.ChallengeManager;
import iskallia.vault.block.entity.challenge.raid.RaidActionEntry;
import iskallia.vault.block.entity.challenge.raid.RaidAnimation;
import iskallia.vault.block.entity.challenge.raid.RaidControllerProxyBlockEntity;
import iskallia.vault.block.entity.challenge.raid.RaidSpawner;
import iskallia.vault.block.entity.challenge.raid.action.AddMobsChallengeAction;
import iskallia.vault.block.entity.challenge.raid.action.ChallengeAction;
import iskallia.vault.block.entity.challenge.raid.action.FloatingItemRewardChallengeAction;
import iskallia.vault.block.entity.challenge.raid.action.MobVanillaAttributeChallengeAction;
import iskallia.vault.block.entity.challenge.raid.action.PlayerVanillaAttributeChallengeAction;
import iskallia.vault.block.entity.challenge.raid.action.TileRewardChallengeAction;
import iskallia.vault.client.gui.framework.text.TextAlign;
import iskallia.vault.client.gui.helper.LightmapHelper;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.array.ArrayAdapter;
import iskallia.vault.core.data.adapter.basic.EnumAdapter;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.BlockUseEvent;
import iskallia.vault.core.random.ChunkRandom;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.vault.time.TickClock;
import iskallia.vault.core.world.storage.BlockCuboid;
import iskallia.vault.core.world.storage.IZonedWorld;
import iskallia.vault.core.world.storage.WorldZone;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModKeybinds;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModSounds;
import iskallia.vault.network.message.AbsorbingParticleMessage;
import iskallia.vault.util.AABBHelper;
import iskallia.vault.util.ServerScheduler;
import iskallia.vault.world.data.ServerVaults;
import iskallia.vault.world.data.WorldZonesData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;

public class RaidChallengeManager
extends ChallengeManager {
    private final Map<BlockPos, List<RaidActionEntry>> proxies;
    private int zoneId;
    private BlockCuboid zone;
    private final RaidSpawner spawner;
    private final List<ChallengeAction<?>> actions;
    private final List<ChallengeAction<?>> scheduledActions;
    private final RaidAnimation animation;
    private int proxyTicker;
    private Phase phase;
    public static ArrayAdapter<ChallengeAction<?>> ACTIONS = Adapters.ofArray(ChallengeAction[]::new, Adapters.CHALLENGE_ACTION);
    public static ArrayAdapter<RaidActionEntry> ENTRIES = Adapters.ofArray(RaidActionEntry[]::new, Adapters.of(RaidActionEntry::new, false));
    public static EnumAdapter<Phase> PHASE = Adapters.ofEnum(Phase.class, EnumAdapter.Mode.NAME);
    public static final ResourceLocation HUD = VaultMod.id("textures/gui/challenge/raid/hud.png");
    public static final int ACTION_COLUMN_WIDTH = 170;

    public RaidChallengeManager() {
        this.proxies = new HashMap<BlockPos, List<RaidActionEntry>>();
        this.spawner = new RaidSpawner();
        this.actions = new ArrayList();
        this.scheduledActions = new ArrayList();
        this.animation = new RaidAnimation();
        this.phase = Phase.IDLE;
    }

    public RaidChallengeManager(UUID uuid, ResourceKey<Level> dimension, BlockPos pos) {
        super(uuid, dimension, pos);
        this.proxies = new LinkedHashMap<BlockPos, List<RaidActionEntry>>();
        this.zoneId = -1;
        this.spawner = new RaidSpawner();
        this.actions = new ArrayList();
        this.scheduledActions = new ArrayList();
        this.animation = new RaidAnimation();
        this.phase = Phase.IDLE;
    }

    public Map<BlockPos, List<RaidActionEntry>> getProxies() {
        return this.proxies;
    }

    public BlockCuboid getZone() {
        return this.zone;
    }

    public void setZone(BlockCuboid zone) {
        this.zone = zone;
    }

    public RaidSpawner getSpawner() {
        return this.spawner;
    }

    public List<ChallengeAction<?>> getActions() {
        return this.actions;
    }

    public void addActions(List<ChallengeAction<?>> actions) {
        this.scheduledActions.addAll(actions);
    }

    public Phase getPhase() {
        return this.phase;
    }

    public void setPhase(Phase phase) {
        this.phase = phase;
    }

    @Override
    public void onAttach(ServerLevel world) {
        super.onAttach(world);
        CommonEvents.BLOCK_USE.at(BlockUseEvent.Phase.HEAD).of(ModBlocks.RAID_CONTROLLER_PROXY).register(this, data -> {
            if (data.getHand() != InteractionHand.MAIN_HAND) {
                data.setResult(InteractionResult.SUCCESS);
                return;
            }
            if (data.getWorld() != world) {
                return;
            }
            if (!this.proxies.containsKey(data.getPos().m_141950_((Vec3i)this.pos))) {
                return;
            }
            BlockEntity patt5652$temp = data.getWorld().m_7702_(data.getPos());
            if (patt5652$temp instanceof RaidControllerProxyBlockEntity) {
                RaidControllerProxyBlockEntity proxy = (RaidControllerProxyBlockEntity)patt5652$temp;
                this.onProxyClick(world, data.getPlayer(), proxy);
            }
        });
        this.spawner.onAttach((Level)world, this);
    }

    @Override
    public void onDetach() {
        super.onDetach();
        this.spawner.onDetach();
    }

    @Override
    public boolean addPlayer(Player player) {
        if (super.addPlayer(player)) {
            for (ChallengeAction<?> action : this.getActions()) {
                action.onAddPlayer(player);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removePlayer(Player player) {
        if (super.removePlayer(player)) {
            for (ChallengeAction<?> action : this.getActions()) {
                action.onRemovePlayer(player);
            }
            return true;
        }
        return false;
    }

    @Override
    public void onTick(ServerLevel world) {
        ChallengeControllerBlockEntity controller;
        Object object;
        if (this.isDeleted()) {
            return;
        }
        ChunkRandom random = ChunkRandom.any();
        random.setDecoratorSeed(ServerVaults.get((Level)world).map(vault -> vault.get(Vault.SEED)).orElse(0L), this.pos.m_123341_(), this.pos.m_123343_(), 329057345 * this.spawner.getWaveCount());
        if (this.zoneId < 0 && this.zone != null) {
            this.zoneId = WorldZonesData.get(world.m_142572_()).getOrCreate((ResourceKey<Level>)world.m_46472_()).add(new WorldZone().add(this.zone.offset((Vec3i)this.pos)).setModify(false));
        }
        if ((object = this.getBlockEntity(world.m_142572_())) instanceof ChallengeControllerBlockEntity && (controller = (ChallengeControllerBlockEntity)((Object)object)).getState() == ChallengeControllerBlockEntity.State.GENERATING && this.phase != Phase.STARTING) {
            this.phase = Phase.STARTING;
            this.animation.onStart(RaidAnimation.State.CLOSE_ROOM);
        }
        if (this.phase == Phase.STARTING && this.animation.isCompleted()) {
            if (this.spawner.hasWaveAvailable()) {
                this.phase = Phase.PROXIES;
                this.proxyTicker = 0;
            } else {
                this.phase = Phase.COMPLETED;
            }
        }
        if (this.phase == Phase.PROXIES) {
            this.tickProxySummon(world, this.pos, random);
        }
        if (this.phase == Phase.IN_WAVE && this.spawner.isWaveCompleted()) {
            this.spawner.onCompleteWave();
            if (this.spawner.hasWaveAvailable()) {
                this.phase = Phase.PROXIES;
                this.proxyTicker = 0;
            } else {
                this.phase = Phase.COMPLETED;
            }
        }
        if ((this.phase == Phase.COMPLETED || this.phase == Phase.FORFEITED) && this.animation.isCompleted()) {
            if (this.animation.getState() != RaidAnimation.State.OPEN_HATCH && this.animation.getState() != RaidAnimation.State.OPEN_ROOM) {
                this.animation.onStart(RaidAnimation.State.OPEN_ROOM);
            } else if (this.animation.getState() == RaidAnimation.State.OPEN_ROOM && this.phase == Phase.COMPLETED) {
                this.animation.onStart(RaidAnimation.State.OPEN_HATCH);
                ServerVaults.get((Level)world).ifPresent(vault -> {
                    if (vault.get(Vault.WORLD).get(WorldManager.THEME).m_135815_().contains("raid")) {
                        vault.get(Vault.CLOCK).set(TickClock.PAUSED);
                    }
                });
            }
            if (this.animation.isCompleted()) {
                this.setDeleted(true);
            }
        }
        if (this.phase == Phase.IN_WAVE) {
            Vec3 controllerPos = new Vec3((double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_() + 0.5, (double)this.pos.m_123343_() + 0.5);
            AABB searchArea = AABBHelper.create(controllerPos, 16.0f);
            List mobs = world.m_6443_(Mob.class, searchArea, mob -> !mob.m_146910_() && !mob.m_21525_() && mob.m_6084_());
            for (Mob mob2 : mobs) {
                double mobHeadY = mob2.m_20186_() + (double)mob2.m_20192_();
                if (!(mobHeadY < (double)this.pos.m_123342_())) continue;
                mob2.m_6021_((double)this.pos.m_123341_() + 2.5, (double)this.pos.m_123342_() + 1.0, (double)this.pos.m_123343_() + 2.5);
                mob2.f_19789_ = 0.0f;
            }
        }
        this.animation.onTick(world, this.pos);
        this.spawner.onTick(world);
        if (this.getPhase() != Phase.IDLE && this.phase != Phase.COMPLETED && this.phase != Phase.FORFEITED) {
            for (ServerPlayer player : world.m_6907_()) {
                if (!this.zone.offset((Vec3i)this.pos).grow(-1, -1, -1).contains((Vec3i)player.m_142538_())) continue;
                this.addPlayer((Player)player);
            }
        }
        HashSet<ServerPlayer> toRemove = new HashSet<ServerPlayer>();
        for (UUID uuid : this.players) {
            ServerPlayer player = world.m_142572_().m_6846_().m_11259_(uuid);
            if (player == null || player.f_19853_ == world && this.zone.offset((Vec3i)this.pos).grow(-1, -1, -1).contains((Vec3i)player.m_142538_())) continue;
            toRemove.add(player);
        }
        for (ServerPlayer player : toRemove) {
            this.removePlayer((Player)player);
        }
    }

    @Override
    public void onRemove(MinecraftServer server) {
        BlockEntity blockEntity;
        if (this.phase == Phase.COMPLETED && this.zoneId >= 0) {
            WorldZonesData.get(server).getOrCreate((ResourceKey<Level>)this.dimension).remove(this.zoneId);
        }
        if ((blockEntity = this.getBlockEntity(server)) instanceof ChallengeControllerBlockEntity) {
            ChallengeControllerBlockEntity controller = (ChallengeControllerBlockEntity)blockEntity;
            controller.setState(ChallengeControllerBlockEntity.State.DESTROYED);
            controller.m_58904_().m_5594_(null, controller.m_58899_(), SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, 2.0f);
            controller.m_58904_().m_5594_(null, controller.m_58899_(), SoundEvents.f_11983_, SoundSource.BLOCKS, 1.0f, 2.0f);
            ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new AbsorbingParticleMessage(new Vec3((double)controller.m_58899_().m_123341_(), (double)controller.m_58899_().m_123342_() + 1.65, (double)controller.m_58899_().m_123343_()), new Vec3((double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_() + 1.65, (double)this.pos.m_123343_() + 0.5), controller.getRenderer().getParticleColor()));
        }
    }

    private void tickProxySummon(ServerLevel world, BlockPos pos, RandomSource random) {
        int proxyIndex;
        if (random instanceof JavaRandom) {
            JavaRandom rng = (JavaRandom)random;
            rng.setSeed(rng.getSeed() ^ (long)this.proxyTicker ^ (long)this.spawner.getWaveCount());
            rng.nextLong();
        }
        int n = proxyIndex = this.proxyTicker % 20 == 0 ? this.proxyTicker / 20 : -1;
        if (proxyIndex >= 0 && proxyIndex < this.proxies.size()) {
            BlockPos offset = new ArrayList<BlockPos>(this.proxies.keySet()).get(proxyIndex);
            this.summonProxy(world, pos, random, offset, this.spawner.getWaveCount());
        }
        ++this.proxyTicker;
    }

    private void summonProxy(ServerLevel world, BlockPos pos, RandomSource random, BlockPos offset, int wave) {
        List<RaidActionEntry> entries = this.proxies.get(offset);
        if (entries == null) {
            return;
        }
        BlockPos proxyPos = pos.m_141952_((Vec3i)offset);
        IZonedWorld.runWithBypass(world, true, () -> world.m_46597_(proxyPos, ModBlocks.RAID_CONTROLLER_PROXY.m_49966_()));
        BlockEntity blockEntity = world.m_7702_(proxyPos);
        if (blockEntity instanceof RaidControllerProxyBlockEntity) {
            RaidControllerProxyBlockEntity entity = (RaidControllerProxyBlockEntity)blockEntity;
            int vaultLevel = VaultUtils.getVault((Level)world).map(vault -> vault.get(Vault.LEVEL).get()).orElse(this.getHighestVaultLevel(world));
            entity.setActions(ChallengeAction.merge(entries.stream().map(entry -> {
                if (random.nextFloat() >= entry.getProbability()) {
                    return null;
                }
                if (!entry.matchesWave(wave + 1)) {
                    return null;
                }
                entry = (RaidActionEntry)entry.copy();
                entry.onPopulate(random);
                return entry;
            }).filter(Objects::nonNull).flatMap(entry -> entry.getActions().stream()).flatMap(action -> action.flatten(random, vaultLevel)).peek(action -> action.onPopulate(random)).collect(Collectors.toList())));
            entity.setController(pos);
        }
        world.m_5594_(null, pos, SoundEvents.f_12653_, SoundSource.BLOCKS, 1.4f, 1.0f);
    }

    public void computeScheduledActions(ServerLevel world, RandomSource random) {
        int vaultLevel = VaultUtils.getVault((Level)world).map(vault -> vault.get(Vault.LEVEL).get()).orElse(this.getHighestVaultLevel(world));
        List<ChallengeAction<?>> merged = ChallengeAction.merge(this.scheduledActions.stream().map(action -> {
            action = action.copy();
            action.onPopulate(random);
            return action;
        }).flatMap(action -> action.flatten(random, vaultLevel)).peek(action -> {
            action.onPopulate(random);
            action.onActivate(world, this, random);
        }).collect(Collectors.toList()));
        ChallengeAction.merge(this.actions, merged);
        this.scheduledActions.clear();
    }

    public void onProxyClick(ServerLevel world, Player player, RaidControllerProxyBlockEntity proxy) {
        if (this.phase == Phase.PROXIES) {
            BlockEntity blockEntity;
            ChunkRandom random = ChunkRandom.any();
            random.setDecoratorSeed(ServerVaults.get((Level)world).map(vault -> vault.get(Vault.SEED)).orElse(0L), this.pos.m_123341_(), this.pos.m_123343_(), 390973451 * this.spawner.getWaveCount());
            this.scheduledActions.addAll(proxy.getActions());
            this.computeScheduledActions(world, random);
            IZonedWorld.runWithBypass(world, true, () -> {
                for (BlockPos pos : this.proxies.keySet()) {
                    world.m_46961_(this.pos.m_141952_((Vec3i)pos), false);
                }
            });
            if (this.phase == Phase.PROXIES) {
                this.spawner.onSpawn(world, this.pos);
                this.phase = Phase.IN_WAVE;
                ServerScheduler.INSTANCE.schedule(20, () -> world.m_5594_(null, this.pos, ModSounds.ARENA_HORNS_SFX, SoundSource.BLOCKS, 1.0f, 1.0f));
            }
            if ((blockEntity = this.getBlockEntity(world.m_142572_())) instanceof ChallengeControllerBlockEntity) {
                ChallengeControllerBlockEntity controller = (ChallengeControllerBlockEntity)blockEntity;
                world.m_5594_(null, controller.m_58899_(), SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, 2.0f);
                world.m_5594_(null, controller.m_58899_(), SoundEvents.f_11767_, SoundSource.BLOCKS, 1.0f, 2.0f);
                ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new AbsorbingParticleMessage(new Vec3((double)proxy.m_58899_().m_123341_() + 0.5, (double)proxy.m_58899_().m_123342_(), (double)proxy.m_58899_().m_123343_() + 0.5), new Vec3((double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_() + 1.65, (double)this.pos.m_123343_() + 0.5), controller.getRenderer().getParticleColor()));
            }
        }
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.BLOCK_CUBOID.writeNbt(this.zone).ifPresent(tag -> nbt.m_128365_("zone", tag));
            Adapters.INT.writeNbt(this.zoneId).ifPresent(tag -> nbt.m_128365_("zoneId", tag));
            this.spawner.writeNbt().ifPresent(tag -> nbt.m_128365_("spawner", (Tag)tag));
            ACTIONS.writeNbt((ChallengeAction<?>)((ChallengeAction[])this.actions.toArray(ChallengeAction[]::new))).ifPresent(tag -> nbt.m_128365_("actions", tag));
            ACTIONS.writeNbt((ChallengeAction<?>)((ChallengeAction[])this.scheduledActions.toArray(ChallengeAction[]::new))).ifPresent(tag -> nbt.m_128365_("scheduledActions", tag));
            ListTag proxies = new ListTag();
            this.proxies.forEach((pos, entries) -> {
                CompoundTag entry = new CompoundTag();
                Adapters.BLOCK_POS.writeNbt((BlockPos)pos).ifPresent(tag -> entry.m_128365_("pos", tag));
                ENTRIES.writeNbt((RaidActionEntry)((RaidActionEntry[])entries.toArray(RaidActionEntry[]::new))).ifPresent(tag -> entry.m_128365_("entries", tag));
                proxies.add((Object)entry);
            });
            nbt.m_128365_("proxies", (Tag)proxies);
            PHASE.asNullable().writeNbt(this.phase).ifPresent(tag -> nbt.m_128365_("phase", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.zone = Adapters.BLOCK_CUBOID.readNbt(nbt.m_128423_("zone")).orElse(null);
        this.zoneId = Adapters.INT.readNbt(nbt.m_128423_("zoneId")).orElse(-1);
        this.spawner.readNbt(nbt.m_128469_("spawner"));
        this.actions.clear();
        ACTIONS.readNbt(nbt.m_128423_("actions")).ifPresent(actions -> this.actions.addAll(Arrays.asList(actions)));
        this.scheduledActions.clear();
        ACTIONS.readNbt(nbt.m_128423_("scheduledActions")).ifPresent(actions -> this.scheduledActions.addAll(Arrays.asList(actions)));
        ListTag proxies = nbt.m_128437_("proxies", 10);
        this.proxies.clear();
        for (int i = 0; i < proxies.size(); ++i) {
            CompoundTag entry = proxies.m_128728_(i);
            this.proxies.put(Adapters.BLOCK_POS.readNbt(entry.m_128423_("pos")).orElseThrow(), Arrays.stream((RaidActionEntry[])ENTRIES.readNbt(entry.m_128423_("entries")).orElseThrow()).filter(e -> e instanceof RaidActionEntry).collect(Collectors.toList()));
        }
        this.phase = PHASE.readNbt(nbt.m_128423_("phase")).orElse(Phase.IDLE);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onRender(PoseStack matrixStack, float partialTicks, Window window) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91080_ == null && ModKeybinds.showRaidInfo.m_90857_()) {
            this.onTabRender(matrixStack, partialTicks, window, minecraft);
            return;
        }
        int waveCount = this.spawner.getWaveCount();
        int waveTarget = this.spawner.getWaveTarget();
        MutableComponent txt = waveTarget < 0 || waveCount < waveTarget ? new TextComponent("").m_130940_(ChatFormatting.WHITE).m_7220_((Component)new TextComponent("Wave ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)new TextComponent(waveCount + 1 + (String)(this.getPhase() == Phase.IN_WAVE || waveTarget <= 0 ? "" : " of " + waveTarget)).m_130940_(ChatFormatting.WHITE)) : new TextComponent("").m_130940_(ChatFormatting.WHITE).m_7220_((Component)new TextComponent("Complete").m_130940_(ChatFormatting.WHITE));
        int midX = window.m_85445_() / 2;
        matrixStack.m_85836_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int previousTexture = RenderSystem.m_157203_((int)0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)HUD);
        double progress = this.getPhase() == Phase.IN_WAVE ? this.spawner.getCurrentHealth() / this.spawner.getTotalHealth() : (waveTarget < 0 ? 0.0 : (double)waveCount / (double)waveTarget);
        matrixStack.m_85837_((double)(midX - 80), 8.0, 0.0);
        GuiComponent.m_93133_((PoseStack)matrixStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)200, (int)26, (int)200, (int)50);
        GuiComponent.m_93133_((PoseStack)matrixStack, (int)0, (int)8, (float)0.0f, (float)28.0f, (int)(15 + (int)(130.0 * progress)), (int)10, (int)200, (int)50);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157453_((int)0, (int)previousTexture);
        matrixStack.m_85849_();
        Font font = minecraft.f_91062_;
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        matrixStack.m_85836_();
        matrixStack.m_85841_(0.6f, 0.6f, 0.6f);
        FormattedCharSequence formattedCharSequence = txt.m_7532_();
        float f = (float)midX / 0.6f - (float)font.m_92852_((FormattedText)txt) / 2.0f;
        Objects.requireNonNull(font);
        font.m_92733_(formattedCharSequence, f, (float)(9 + 22), -1, true, matrixStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, false, 0, LightmapHelper.getPackedFullbrightCoords());
        buffer.m_109911_();
        matrixStack.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void onTabRender(PoseStack matrixStack, float partialTicks, Window window, Minecraft minecraft) {
        if (this.actions.isEmpty()) {
            return;
        }
        List<ChallengeAction<?>> mobActions = this.getActions(AddMobsChallengeAction.class);
        List<ChallengeAction<?>> attributeActions = this.getActions(PlayerVanillaAttributeChallengeAction.class, MobVanillaAttributeChallengeAction.class);
        List<ChallengeAction<?>> rewardActions = this.getActions(TileRewardChallengeAction.class, FloatingItemRewardChallengeAction.class);
        if (mobActions.isEmpty() && attributeActions.isEmpty() && rewardActions.isEmpty()) {
            return;
        }
        Font font = minecraft.f_91062_;
        matrixStack.m_85836_();
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91065_.m_93088_().f_94524_) {
            matrixStack.m_85837_(0.0, (double)(mc.f_91074_.f_108617_.m_105142_().size() * 9 + 10), 0.0);
        }
        matrixStack.m_85837_(0.0, 6.0, 0.0);
        float scale = 0.6f;
        matrixStack.m_85841_(scale, scale, scale);
        int midX = (int)((double)window.m_85445_() / 2.0 / (double)scale);
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        int maxLines = Math.max(mobActions.size(), Math.max(attributeActions.size(), rewardActions.size()));
        Objects.requireNonNull(font);
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)(midX - 170 - 85 - 5), (int)-5, (int)(midX + 170 + 85 + 5), (int)(maxLines * 9 + (maxLines - 1) * 2 + 3), (int)0x66000000);
        RaidChallengeManager.renderActionTexts(matrixStack, mobActions, font, midX - 170 - 85, buffer, TextAlign.LEFT, 170);
        RaidChallengeManager.renderActionTexts(matrixStack, attributeActions, font, midX - 85, buffer, TextAlign.CENTER, 170);
        RaidChallengeManager.renderActionTexts(matrixStack, rewardActions, font, midX + 85, buffer, TextAlign.RIGHT, 170);
        buffer.m_109911_();
        matrixStack.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderActionTexts(PoseStack matrixStack, List<ChallengeAction<?>> actions, Font font, int leftX, MultiBufferSource.BufferSource buffer, TextAlign.ITextAlign textAlign, int columnWidth) {
        ArrayList<Component> lines = new ArrayList<Component>();
        int maxWidth = 0;
        for (ChallengeAction<?> action : actions) {
            Component txt = action.getText();
            lines.add(txt);
            maxWidth = Math.max(maxWidth, font.m_92852_((FormattedText)txt));
        }
        int y = 0;
        for (Component txt : lines) {
            int x = textAlign.calculateX(0, font.m_92852_((FormattedText)txt), columnWidth);
            font.m_92733_(txt.m_7532_(), (float)(leftX + x), (float)y, -1, true, matrixStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, false, 0, LightmapHelper.getPackedFullbrightCoords());
            Objects.requireNonNull(font);
            y += 9 + 2;
        }
    }

    public List<ChallengeAction<?>> getActions(Class<?> ... types) {
        ArrayList result = new ArrayList();
        for (Class<?> type : types) {
            for (ChallengeAction<?> action : this.actions) {
                if (!type.isAssignableFrom(action.getClass())) continue;
                result.add(action);
            }
        }
        return result;
    }

    public static enum Phase {
        IDLE,
        STARTING,
        PROXIES,
        IN_WAVE,
        COMPLETED,
        FORFEITED;

    }
}

