/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity.challenge.raid;

import iskallia.vault.block.entity.challenge.ChallengeControllerBlockEntity;
import iskallia.vault.block.entity.challenge.raid.RaidActionEntry;
import iskallia.vault.block.entity.challenge.raid.RaidChallengeManager;
import iskallia.vault.block.entity.challenge.raid.RaidSpawner;
import iskallia.vault.block.entity.challenge.raid.action.ChallengeAction;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.array.ArrayAdapter;
import iskallia.vault.core.random.ChunkRandom;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.world.roll.IntRoll;
import iskallia.vault.core.world.storage.BlockCuboid;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.world.data.ServerVaults;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class RaidControllerBlockEntity
extends ChallengeControllerBlockEntity<RaidChallengeManager> {
    private BlockCuboid zone;
    private final Map<List<BlockPos>, List<RaidActionEntry>> proxies;
    private final List<RaidSpawner.Block> spawners;
    private IntRoll waves;
    private final List<ChallengeAction<?>> actions;
    public static ArrayAdapter<ChallengeAction<?>> ACTIONS = Adapters.ofArray(ChallengeAction[]::new, Adapters.CHALLENGE_ACTION);
    public static ArrayAdapter<RaidActionEntry> ENTRIES = Adapters.ofArray(RaidActionEntry[]::new, Adapters.of(RaidActionEntry::new, false));

    public RaidControllerBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.RAID_CONTROLLER_TILE_ENTITY, pos, state);
        this.setRenderer(0xCC0000, 0xCC0000, 0xCC0000);
        this.zone = null;
        this.proxies = new LinkedHashMap<List<BlockPos>, List<RaidActionEntry>>();
        this.spawners = new ArrayList<RaidSpawner.Block>();
        this.waves = IntRoll.ofConstant(2);
        this.actions = new ArrayList();
    }

    @Override
    public RaidChallengeManager createManager() {
        ChunkRandom random = ChunkRandom.any();
        random.setDecoratorSeed(ServerVaults.get(this.f_58857_).map(vault -> vault.get(Vault.SEED)).orElse(0L), this.m_58899_().m_123341_(), this.m_58899_().m_123343_(), 329045113);
        RaidChallengeManager manager = new RaidChallengeManager(this.uuid, (ResourceKey<Level>)this.f_58857_.m_46472_(), this.m_58899_());
        this.proxies.forEach((positions, entries) -> positions.forEach(position -> manager.getProxies().put((BlockPos)position, (List<RaidActionEntry>)entries)));
        manager.setZone(this.zone);
        manager.getSpawner().getBlocks().addAll(this.spawners);
        manager.getSpawner().setTarget(this.waves.get(random));
        manager.addActions(this.actions);
        return manager;
    }

    @Override
    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        Adapters.BLOCK_CUBOID.writeNbt(this.zone).ifPresent(tag -> nbt.m_128365_("zone", tag));
        ListTag proxies = new ListTag();
        this.proxies.forEach((pos, entries) -> {
            CompoundTag entry = new CompoundTag();
            if (pos.size() == 1) {
                Adapters.BLOCK_POS.writeNbt((BlockPos)pos.get(0)).ifPresent(tag -> entry.m_128365_("pos", tag));
            } else {
                ListTag positions = new ListTag();
                for (BlockPos p : pos) {
                    Adapters.BLOCK_POS.writeNbt(p).ifPresent(arg_0 -> positions.add(arg_0));
                }
                entry.m_128365_("pos", (Tag)positions);
            }
            ENTRIES.writeNbt((RaidActionEntry)((RaidActionEntry[])entries.toArray(RaidActionEntry[]::new))).ifPresent(tag -> entry.m_128365_("entries", tag));
            proxies.add((Object)entry);
        });
        nbt.m_128365_("proxies", (Tag)proxies);
        ListTag spawners = new ListTag();
        for (RaidSpawner.Block spawner : this.spawners) {
            spawner.writeNbt().ifPresent(arg_0 -> spawners.add(arg_0));
        }
        nbt.m_128365_("spawners", (Tag)spawners);
        Adapters.INT_ROLL.writeNbt(this.waves).ifPresent(roll -> nbt.m_128365_("waves", roll));
        ACTIONS.writeNbt((ChallengeAction<?>)((ChallengeAction[])this.actions.toArray(ChallengeAction[]::new))).ifPresent(tag -> nbt.m_128365_("actions", tag));
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.zone = Adapters.BLOCK_CUBOID.readNbt(nbt.m_128423_("zone")).orElse(null);
        ListTag proxies = nbt.m_128437_("proxies", 10);
        this.proxies.clear();
        for (int i = 0; i < proxies.size(); ++i) {
            ListTag list;
            CompoundTag entry = proxies.m_128728_(i);
            ArrayList positions = new ArrayList();
            Tag tag = entry.m_128423_("pos");
            if (tag instanceof ListTag && ((list = (ListTag)tag).m_7264_() == 9 || list.m_7264_() == 4)) {
                for (Tag tag2 : list) {
                    Adapters.BLOCK_POS.readNbt(tag2).ifPresent(positions::add);
                }
            } else {
                Adapters.BLOCK_POS.readNbt(entry.m_128423_("pos")).ifPresent(positions::add);
            }
            this.proxies.put(positions, Arrays.stream((RaidActionEntry[])ENTRIES.readNbt(entry.m_128423_("entries")).orElseThrow()).collect(Collectors.toList()));
        }
        ListTag blocks = nbt.m_128437_("spawners", 10);
        this.spawners.clear();
        for (int i = 0; i < blocks.size(); ++i) {
            RaidSpawner.Block block = new RaidSpawner.Block();
            block.readNbt(blocks.m_128728_(i));
            this.spawners.add(block);
        }
        this.waves = Adapters.INT_ROLL.readNbt(nbt.m_128423_("waves")).orElse(IntRoll.ofConstant(-1));
        this.actions.clear();
        ACTIONS.readNbt(nbt.m_128423_("actions")).ifPresent(actions -> this.actions.addAll(Arrays.asList(actions)));
    }
}

