/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity.challenge.raid;

import com.google.gson.JsonObject;
import iskallia.vault.block.entity.challenge.raid.RaidChallengeManager;
import iskallia.vault.block.entity.challenge.raid.action.ChallengeAction;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.array.ArrayAdapter;
import iskallia.vault.core.data.serializable.ISerializable;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.world.data.entity.PartialEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.registries.ForgeRegistries;

public class RaidSpawner
implements ISerializable<CompoundTag, JsonObject> {
    private final List<Block> blocks = new ArrayList<Block>();
    private final List<Spawn> spawns = new ArrayList<Spawn>();
    private final Set<UUID> spawnedWave = new HashSet<UUID>();
    private double currentHealth;
    private double totalHealth;
    private int count;
    private int target;
    private boolean trackSpawns;

    public List<Block> getBlocks() {
        return this.blocks;
    }

    public void setTarget(int target) {
        this.target = target;
    }

    public void addSpawn(PartialEntity entity, int count, String spawner) {
        this.spawns.add(new Spawn(entity, count, spawner));
    }

    public boolean isWaveCompleted() {
        return this.spawnedWave.isEmpty();
    }

    public double getCurrentHealth() {
        return this.currentHealth;
    }

    public double getTotalHealth() {
        return this.totalHealth;
    }

    public void onAttach(Level world, RaidChallengeManager manager) {
        CommonEvents.ENTITY_LEAVE.register((Object)this, EventPriority.HIGHEST, event -> {
            if (event.getEntity().f_19853_ != world) {
                return;
            }
            this.spawnedWave.remove(event.getEntity().m_142081_());
        });
        CommonEvents.ENTITY_INITIALIZE.register(this, event -> {
            if (!this.trackSpawns || event.getMob().f_19853_ != world) {
                return;
            }
            this.spawnedWave.add(event.getMob().m_142081_());
            for (ChallengeAction<?> action : manager.getActions()) {
                action.onSummonMob((Entity)event.getMob());
            }
        });
    }

    public void onDetach() {
        CommonEvents.ENTITY_LEAVE.release(this);
        CommonEvents.ENTITY_INITIALIZE.release(this);
    }

    public void onTick(ServerLevel world) {
        this.spawnedWave.removeIf(uuid -> world.m_8791_(uuid) == null);
        double total = 0.0;
        this.currentHealth = 0.0;
        for (UUID uuid2 : this.spawnedWave) {
            Entity entity = world.m_8791_(uuid2);
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            this.currentHealth += (double)living.m_21223_();
            total += (double)living.m_21233_();
        }
        if (total > this.totalHealth) {
            this.totalHealth = total;
        }
    }

    public void onSpawn(ServerLevel world, BlockPos pos) {
        this.totalHealth = 0.0;
        JavaRandom random = JavaRandom.ofNanoTime();
        HashMap<BlockPos, List> spawnerToSpawns = new HashMap<BlockPos, List>();
        for (Spawn spawn : this.spawns) {
            List<BlockPos> spawners = this.blocks.stream().filter(block -> block.groups.contains(spawn.spawner)).map(block -> block.pos).toList();
            if (spawners.isEmpty()) continue;
            BlockPos spawner2 = spawners.get(random.nextInt(spawners.size()));
            spawnerToSpawns.computeIfAbsent(spawner2.m_141952_((Vec3i)pos), unused -> new ArrayList()).add(spawn);
        }
        spawnerToSpawns.forEach((spawner, spawns) -> {
            EntityBlock entityBlock;
            BlockEntityTicker ticker;
            int i;
            BlockEntity blockEntity = world.m_7702_(spawner);
            if (blockEntity == null) {
                return;
            }
            CompoundTag nbt = blockEntity.m_187482_();
            CompoundTag manager = nbt.m_128469_("Manager");
            nbt.m_128365_("Manager", (Tag)manager);
            CompoundTag settings = nbt.m_128469_("Settings");
            manager.m_128365_("Settings", (Tag)settings);
            manager.m_128405_("SpawnTimer", 0);
            manager.m_128405_("UsesLeft", 1000);
            manager.m_128405_("WaveCounter", 1);
            manager.m_128379_("ConsumeCharge", true);
            settings.m_128405_("Mode", 2);
            settings.m_128405_("CheckRadius", 0);
            settings.m_128405_("PlayerRadius", 0);
            settings.m_128405_("SpawnDelay", 1);
            settings.m_128405_("Attempts", 200);
            settings.m_128405_("SpawnDelay", 200000);
            CompoundTag inventory = nbt.m_128469_("Inventory");
            ListTag stacksList = inventory.m_128437_("Stacks", 10);
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (i = 0; i < stacksList.size(); ++i) {
                CompoundTag stackEntry = stacksList.m_128728_(i);
                ItemStack stack = ItemStack.m_41712_((CompoundTag)stackEntry);
                stack.m_41764_(stackEntry.m_128451_("Count"));
                stacks.add(stack);
            }
            for (i = 0; i < spawns.size(); ++i) {
                Spawn spawn = (Spawn)spawns.get(i);
                if (spawn.entity == null || spawn.count <= 0) continue;
                ItemStack egg = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("ispawner:spawn_egg")));
                egg.m_41764_(spawn.count);
                spawn.entity.getNbt().asWhole().ifPresent(tag -> egg.m_41784_().m_128365_("EntityTag", (Tag)tag));
                stacks.add(i, egg);
            }
            stacksList.clear();
            for (ItemStack stack : stacks) {
                CompoundTag tag2 = stack.serializeNBT();
                tag2.m_128405_("Count", stack.m_41613_());
                stacksList.add((Object)tag2);
            }
            inventory.m_128365_("Stacks", (Tag)stacksList);
            blockEntity.m_142466_(nbt);
            net.minecraft.world.level.block.Block patt6804$temp = world.m_8055_(spawner).m_60734_();
            if (patt6804$temp instanceof EntityBlock && (ticker = (entityBlock = (EntityBlock)patt6804$temp).m_142354_((Level)world, blockEntity.m_58900_(), blockEntity.m_58903_())) != null) {
                this.trackSpawns = true;
                ticker.m_155252_((Level)world, blockEntity.m_58899_(), blockEntity.m_58900_(), blockEntity);
                this.trackSpawns = false;
            }
        });
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return Optional.of(new CompoundTag()).map(nbt -> {
            ListTag blocks = new ListTag();
            for (Block block : this.blocks) {
                block.writeNbt().ifPresent(arg_0 -> blocks.add(arg_0));
            }
            nbt.m_128365_("blocks", (Tag)blocks);
            ListTag spawns = new ListTag();
            for (Spawn spawn : this.spawns) {
                spawn.writeNbt().ifPresent(arg_0 -> spawns.add(arg_0));
            }
            nbt.m_128365_("spawns", (Tag)spawns);
            ListTag listTag = new ListTag();
            for (UUID uuid : this.spawnedWave) {
                listTag.add((Object)StringTag.m_129297_((String)uuid.toString()));
            }
            nbt.m_128365_("spawnedWave", (Tag)listTag);
            nbt.m_128405_("count", this.count);
            nbt.m_128405_("target", this.target);
            Adapters.DOUBLE.writeNbt(this.currentHealth).ifPresent(tag -> nbt.m_128365_("currentHealth", tag));
            Adapters.DOUBLE.writeNbt(this.totalHealth).ifPresent(tag -> nbt.m_128365_("totalHealth", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        ListTag blocks = nbt.m_128437_("blocks", 10);
        this.blocks.clear();
        for (int i = 0; i < blocks.size(); ++i) {
            Block block = new Block();
            block.readNbt(blocks.m_128728_(i));
            this.blocks.add(block);
        }
        ListTag spawns = nbt.m_128437_("spawns", 10);
        this.spawns.clear();
        for (int i = 0; i < spawns.size(); ++i) {
            Spawn spawn = new Spawn();
            spawn.readNbt(spawns.m_128728_(i));
            this.spawns.add(spawn);
        }
        ListTag spawnedWave = nbt.m_128437_("spawnedWave", 8);
        this.spawnedWave.clear();
        for (int i = 0; i < spawnedWave.size(); ++i) {
            this.spawnedWave.add(UUID.fromString(spawnedWave.m_128778_(i)));
        }
        this.count = nbt.m_128451_("count");
        this.target = Adapters.INT.readNbt(nbt.m_128423_("target")).orElse(-1);
        this.currentHealth = Adapters.DOUBLE.readNbt(nbt.m_128423_("currentHealth")).orElse(0.0);
        this.totalHealth = Adapters.DOUBLE.readNbt(nbt.m_128423_("totalHealth")).orElse(0.0);
    }

    public int getWaveCount() {
        return this.count;
    }

    public int getWaveTarget() {
        return this.target;
    }

    public void onCompleteWave() {
        ++this.count;
    }

    public boolean hasWaveAvailable() {
        return this.target < 0 || this.count < this.target;
    }

    private static class Spawn
    implements ISerializable<CompoundTag, JsonObject> {
        private PartialEntity entity;
        private int count;
        private String spawner;

        public Spawn() {
        }

        public Spawn(PartialEntity entity, int count, String spawner) {
            this.entity = entity;
            this.count = count;
            this.spawner = spawner;
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            return Optional.of(new CompoundTag()).map(nbt -> {
                Adapters.PARTIAL_ENTITY.writeNbt(this.entity).ifPresent(tag -> nbt.m_128365_("entity", tag));
                Adapters.INT.writeNbt(this.count).ifPresent(tag -> nbt.m_128365_("count", tag));
                Adapters.UTF_8.writeNbt(this.spawner).ifPresent(tag -> nbt.m_128365_("spawner", tag));
                return nbt;
            });
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            this.entity = Adapters.PARTIAL_ENTITY.readNbt(nbt.m_128423_("entity")).orElse(null);
            this.count = Adapters.INT.readNbt(nbt.m_128423_("count")).orElse(0);
            this.spawner = Adapters.UTF_8.readNbt(nbt.m_128423_("spawner")).orElse(null);
        }
    }

    public static class Block
    implements ISerializable<CompoundTag, JsonObject> {
        private BlockPos pos;
        private Set<String> groups;
        public static final ArrayAdapter<String> GROUPS = Adapters.ofArray(String[]::new, Adapters.UTF_8);

        public Block() {
        }

        public Block(BlockPos pos, String ... groups) {
            this.pos = pos;
            this.groups = new HashSet<String>(Arrays.asList(groups));
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            return Optional.of(new CompoundTag()).map(nbt -> {
                Adapters.BLOCK_POS.writeNbt(this.pos).ifPresent(tag -> nbt.m_128365_("pos", tag));
                GROUPS.writeNbt((String)((String[])this.groups.toArray(String[]::new))).ifPresent(tag -> nbt.m_128365_("groups", tag));
                return nbt;
            });
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            this.pos = Adapters.BLOCK_POS.readNbt(nbt.m_128423_("pos")).orElse(null);
            this.groups = Arrays.stream(GROUPS.readNbt(nbt.m_128423_("groups")).orElse(new String[0])).collect(Collectors.toSet());
        }
    }
}

