/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity.challenge.raid.action;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import iskallia.vault.block.entity.challenge.ChallengeManager;
import iskallia.vault.block.entity.challenge.raid.action.AddMobsChallengeAction;
import iskallia.vault.block.entity.challenge.raid.action.FloatingItemRewardChallengeAction;
import iskallia.vault.block.entity.challenge.raid.action.ForfeitChallengeAction;
import iskallia.vault.block.entity.challenge.raid.action.GroupChallengeAction;
import iskallia.vault.block.entity.challenge.raid.action.MobVanillaAttributeChallengeAction;
import iskallia.vault.block.entity.challenge.raid.action.PlayerVanillaAttributeChallengeAction;
import iskallia.vault.block.entity.challenge.raid.action.PoolChallengeAction;
import iskallia.vault.block.entity.challenge.raid.action.ReferenceChallengeAction;
import iskallia.vault.block.entity.challenge.raid.action.TileRewardChallengeAction;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.basic.TypeSupplierAdapter;
import iskallia.vault.core.data.serializable.ISerializable;
import iskallia.vault.core.net.ArrayBitBuffer;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.random.RandomSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public abstract class ChallengeAction<C extends Config>
implements ISerializable<CompoundTag, JsonObject> {
    private final C config;
    private boolean populated;

    protected ChallengeAction(C config) {
        this.config = config;
    }

    public C getConfig() {
        return this.config;
    }

    public boolean isPopulated() {
        return this.populated;
    }

    public void setPopulated(boolean populated) {
        this.populated = populated;
    }

    public boolean onPopulate(RandomSource random) {
        boolean populated = this.isPopulated();
        this.setPopulated(true);
        return populated;
    }

    public abstract boolean onMerge(ChallengeAction<?> var1);

    public abstract Component getText();

    public void onSummonMob(Entity entity) {
    }

    public void onAddPlayer(Player player) {
    }

    public void onRemovePlayer(Player player) {
    }

    public void onActivate(ServerLevel world, ChallengeManager manager, RandomSource random) {
    }

    public Stream<ChallengeAction<?>> flatten(RandomSource random, int vaultLevel) {
        return Stream.of(this);
    }

    public <T extends ChallengeAction<C>> T copy() {
        ArrayBitBuffer buffer = ArrayBitBuffer.empty();
        Adapters.CHALLENGE_ACTION.writeBits(this, (BitBuffer)buffer);
        buffer.setPosition(0);
        return (T)((ChallengeAction)Adapters.CHALLENGE_ACTION.readBits(buffer).orElseThrow());
    }

    public static List<ChallengeAction<?>> merge(List<ChallengeAction<?>> unmergedList) {
        return ChallengeAction.merge(new ArrayList(), unmergedList);
    }

    public static List<ChallengeAction<?>> merge(List<ChallengeAction<?>> mergedList, List<ChallengeAction<?>> unmergedList) {
        for (ChallengeAction<?> second : unmergedList) {
            boolean merged = false;
            for (ChallengeAction<?> first : mergedList) {
                if (!first.onMerge(second)) continue;
                merged = true;
                break;
            }
            if (merged) continue;
            mergedList.add(second);
        }
        return mergedList;
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        ((Config)this.config).writeBits(buffer);
        Adapters.BOOLEAN.writeBits(this.populated, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        ((Config)this.config).readBits(buffer);
        this.populated = Adapters.BOOLEAN.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return Optional.of(new CompoundTag()).map(nbt -> {
            if (!this.populated) {
                CompoundTag other = ((Config)this.config).writeNbt().orElseThrow();
                other.m_128431_().forEach(key -> nbt.m_128365_(key, Objects.requireNonNull(other.m_128423_(key))));
            } else {
                nbt.m_128365_("config", (Tag)((Config)this.config).writeNbt().orElseThrow());
            }
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        if (!nbt.m_128441_("config")) {
            ((Config)this.config).readNbt(nbt);
            this.populated = false;
        } else {
            ((Config)this.config).readNbt(nbt.m_128469_("config"));
            this.populated = true;
        }
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return Optional.of(new JsonObject()).map(json -> {
            if (!this.populated) {
                ((Config)this.config).writeJson().orElseThrow().entrySet().forEach(entry -> json.add((String)entry.getKey(), (JsonElement)entry.getValue()));
            } else {
                json.add("config", (JsonElement)((Config)this.config).writeJson().orElseThrow());
            }
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        if (!json.has("config")) {
            ((Config)this.config).readJson(json);
            this.populated = false;
        } else {
            ((Config)this.config).readJson(json.getAsJsonObject("config"));
            this.populated = true;
        }
    }

    public static class Config
    implements ISerializable<CompoundTag, JsonObject> {
        protected int textColor;

        @Override
        public void writeBits(BitBuffer buffer) {
            Adapters.INT.writeBits(this.textColor, buffer);
        }

        @Override
        public void readBits(BitBuffer buffer) {
            this.textColor = (Integer)Adapters.INT.readBits(buffer).orElseThrow();
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            return Optional.of(new CompoundTag()).map(nbt -> {
                Adapters.INT.writeNbt(this.textColor).ifPresent(tag -> nbt.m_128365_("textColor", tag));
                return nbt;
            });
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            this.textColor = Adapters.INT.readNbt(nbt.m_128423_("textColor")).orElse(0xFFFFFF);
        }

        @Override
        public Optional<JsonObject> writeJson() {
            return Optional.of(new JsonObject()).map(json -> {
                Adapters.INT.writeJson(this.textColor).ifPresent(tag -> json.add("textColor", tag));
                return json;
            });
        }

        @Override
        public void readJson(JsonObject json) {
            this.textColor = Adapters.INT.readJson(json.get("textColor")).orElse(0xFFFFFF);
        }
    }

    public static class Adapter
    extends TypeSupplierAdapter<ChallengeAction<?>> {
        public Adapter() {
            super("type", true);
            this.register("group", GroupChallengeAction.class, GroupChallengeAction::new);
            this.register("pool", PoolChallengeAction.class, PoolChallengeAction::new);
            this.register("reference", ReferenceChallengeAction.class, ReferenceChallengeAction::new);
            this.register("forfeit", ForfeitChallengeAction.class, ForfeitChallengeAction::new);
            this.register("mob_vanilla_attribute", MobVanillaAttributeChallengeAction.class, MobVanillaAttributeChallengeAction::new);
            this.register("player_vanilla_attribute", PlayerVanillaAttributeChallengeAction.class, PlayerVanillaAttributeChallengeAction::new);
            this.register("mob_spawn", AddMobsChallengeAction.class, AddMobsChallengeAction::new);
            this.register("floating_item_reward", FloatingItemRewardChallengeAction.class, FloatingItemRewardChallengeAction::new);
            this.register("tile_reward", TileRewardChallengeAction.class, TileRewardChallengeAction::new);
        }

        @Override
        protected ChallengeAction<?> readSuppliedNbt(Tag nbt) {
            if (nbt instanceof StringTag) {
                StringTag tag = (StringTag)nbt;
                return new ReferenceChallengeAction(new ReferenceChallengeAction.Config(tag.m_7916_()));
            }
            if (nbt instanceof ListTag) {
                CompoundTag action;
                CompoundTag entry;
                Tag tag;
                ListTag tag2 = (ListTag)nbt;
                if (tag2.isEmpty() || !((tag = tag2.get(0)) instanceof CompoundTag) || !(entry = (CompoundTag)tag).m_128441_("weight")) {
                    action = new CompoundTag();
                    action.m_128359_("type", "group");
                    action.m_128365_("children", (Tag)tag2);
                    GroupChallengeAction value = new GroupChallengeAction();
                    value.readNbt(action);
                    return value;
                }
                action = new CompoundTag();
                action.m_128359_("type", "pool");
                action.m_128365_("pool", (Tag)tag2);
                PoolChallengeAction value = new PoolChallengeAction();
                value.readNbt(action);
                return value;
            }
            return (ChallengeAction)super.readSuppliedNbt(nbt);
        }

        @Override
        protected ChallengeAction<?> readSuppliedJson(JsonElement json) {
            JsonPrimitive primitive;
            if (json instanceof JsonPrimitive && (primitive = (JsonPrimitive)json).isString()) {
                return new ReferenceChallengeAction(new ReferenceChallengeAction.Config(primitive.getAsString()));
            }
            if (json instanceof JsonArray) {
                JsonObject action;
                JsonObject entry;
                JsonElement jsonElement;
                JsonArray tag = (JsonArray)json;
                if (tag.isEmpty() || !((jsonElement = tag.get(0)) instanceof JsonObject) || !(entry = (JsonObject)jsonElement).has("weight")) {
                    action = new JsonObject();
                    action.addProperty("type", "group");
                    action.add("children", (JsonElement)tag);
                    GroupChallengeAction value = new GroupChallengeAction();
                    value.readJson(action);
                    return value;
                }
                action = new JsonObject();
                action.addProperty("type", "pool");
                action.add("pool", (JsonElement)tag);
                PoolChallengeAction value = new PoolChallengeAction();
                value.readJson(action);
                return value;
            }
            return (ChallengeAction)super.readSuppliedJson(json);
        }
    }
}

