/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity.challenge.raid.action;

import com.google.gson.JsonObject;
import iskallia.vault.block.entity.challenge.ChallengeManager;
import iskallia.vault.block.entity.challenge.elite.EliteChallengeManager;
import iskallia.vault.block.entity.challenge.raid.RaidChallengeManager;
import iskallia.vault.block.entity.challenge.raid.action.ChallengeAction;
import iskallia.vault.block.entity.challenge.xmark.XMarkChallengeManager;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.modifier.modifier.NoLootModifier;
import iskallia.vault.core.world.data.item.PartialStack;
import iskallia.vault.core.world.storage.BlockCuboid;
import iskallia.vault.entity.entity.FloatingItemEntity;
import iskallia.vault.util.LootInitialization;
import iskallia.vault.world.data.ServerVaults;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class FloatingItemRewardChallengeAction
extends ChallengeAction<Config> {
    public FloatingItemRewardChallengeAction() {
        super(new Config());
    }

    public FloatingItemRewardChallengeAction(Config config) {
        super(config);
    }

    @Override
    public boolean onMerge(ChallengeAction<?> action) {
        if (action instanceof FloatingItemRewardChallengeAction) {
            PartialStack b;
            FloatingItemRewardChallengeAction other = (FloatingItemRewardChallengeAction)action;
            PartialStack a = PartialStack.of(((Config)this.getConfig()).item);
            if (a.isSubsetOf(b = PartialStack.of(((Config)other.getConfig()).item)) && b.isSubsetOf(a)) {
                ((Config)this.getConfig()).item.m_41769_(((Config)other.getConfig()).item.m_41613_());
                return true;
            }
        }
        return false;
    }

    @Override
    public void onActivate(ServerLevel world, ChallengeManager manager, RandomSource random) {
        BlockCuboid zone;
        Vault vault = ServerVaults.get((Level)world).orElse(null);
        if (vault == null) {
            return;
        }
        if (vault.get(Vault.MODIFIERS).getModifiers().stream().anyMatch(modifier -> modifier instanceof NoLootModifier)) {
            return;
        }
        super.onActivate(world, manager, random);
        if (manager instanceof RaidChallengeManager) {
            RaidChallengeManager raid = (RaidChallengeManager)manager;
            zone = raid.getZone().offset((Vec3i)manager.pos);
            zone = BlockCuboid.of(zone.getMinX(), zone.getMinY(), zone.getMinZ(), zone.getMaxX(), zone.getMaxY() - 30, zone.getMaxZ());
        } else if (manager instanceof XMarkChallengeManager) {
            XMarkChallengeManager xmark = (XMarkChallengeManager)manager;
            zone = xmark.getZone().offset((Vec3i)manager.pos);
            zone = BlockCuboid.of(zone.getMinX(), zone.getMinY(), zone.getMinZ(), zone.getMaxX(), zone.getMaxY() - 35, zone.getMaxZ());
        } else if (manager instanceof EliteChallengeManager) {
            EliteChallengeManager elite = (EliteChallengeManager)manager;
            zone = elite.getZone();
            zone = BlockCuboid.of(zone.getMinX() + 10, zone.getMinY() + 10, zone.getMinZ() + 10, zone.getMaxX() - 10, zone.getMaxY() - 10, zone.getMaxZ() - 10);
        } else {
            return;
        }
        block0: for (int j = 0; j < ((Config)this.getConfig()).item.m_41613_(); ++j) {
            for (int i = 0; i < 200; ++i) {
                int z;
                int y;
                int x = random.nextInt(zone.getMaxX() - zone.getMinX() + 1) + zone.getMinX();
                BlockPos pos = new BlockPos(x, y = random.nextInt(zone.getMaxY() - zone.getMinY() + 1) + zone.getMinY(), z = random.nextInt(zone.getMaxZ() - zone.getMinZ() + 1) + zone.getMinZ());
                if (!world.m_8055_(pos).m_60795_() || !world.m_8055_(pos.m_7494_()).m_60795_() || !world.m_8055_(pos.m_7495_()).m_60795_()) continue;
                ItemStack stack = ((Config)this.getConfig()).item.m_41777_();
                stack = LootInitialization.initializeVaultLoot(stack, vault, pos);
                stack.m_41764_(1);
                FloatingItemEntity entity = new FloatingItemEntity((Level)world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, stack);
                entity.setColor(((Config)this.getConfig()).color1, ((Config)this.getConfig()).color2);
                world.m_7967_((Entity)entity);
                continue block0;
            }
        }
    }

    @Override
    public Component getText() {
        return new TextComponent("+" + ((Config)this.getConfig()).item.m_41613_()).m_7220_((Component)new TextComponent(" ")).m_7220_((Component)(((Config)this.getConfig()).name == null ? ((Config)this.getConfig()).item.m_41786_() : new TextComponent(((Config)this.getConfig()).name))).m_6270_(Style.f_131099_.m_178520_(((Config)this.getConfig()).textColor));
    }

    public static class Config
    extends ChallengeAction.Config {
        private String name;
        private ItemStack item;
        private int color1;
        private int color2;

        @Override
        public void writeBits(BitBuffer buffer) {
            super.writeBits(buffer);
            Adapters.UTF_8.asNullable().writeBits(this.name, buffer);
            Adapters.ITEM_STACK.writeBits(this.item, buffer);
            Adapters.INT.writeBits(this.color1, buffer);
            Adapters.INT.writeBits(this.color2, buffer);
        }

        @Override
        public void readBits(BitBuffer buffer) {
            super.readBits(buffer);
            this.name = Adapters.UTF_8.asNullable().readBits(buffer).orElse(null);
            this.item = Adapters.ITEM_STACK.readBits(buffer).orElseThrow();
            this.color1 = (Integer)Adapters.INT.readBits(buffer).orElseThrow();
            this.color2 = (Integer)Adapters.INT.readBits(buffer).orElseThrow();
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            return super.writeNbt().map(nbt -> {
                Adapters.UTF_8.writeNbt(this.name).ifPresent(tag -> nbt.m_128365_("name", tag));
                Adapters.ITEM_STACK.writeNbt(this.item).ifPresent(tag -> nbt.m_128365_("item", tag));
                Adapters.INT.writeNbt(this.color1).ifPresent(tag -> nbt.m_128365_("color1", tag));
                Adapters.INT.writeNbt(this.color2).ifPresent(tag -> nbt.m_128365_("color2", tag));
                return nbt;
            });
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            super.readNbt(nbt);
            this.name = Adapters.UTF_8.asNullable().readNbt(nbt.m_128423_("name")).orElse(null);
            this.item = Adapters.ITEM_STACK.readNbt(nbt.m_128423_("item")).orElseThrow();
            this.color1 = Adapters.INT.readNbt(nbt.m_128423_("color1")).orElse(-1);
            this.color2 = Adapters.INT.readNbt(nbt.m_128423_("color2")).orElse(-1);
        }

        @Override
        public Optional<JsonObject> writeJson() {
            return super.writeJson().map(json -> {
                Adapters.UTF_8.writeJson(this.name).ifPresent(tag -> json.add("name", tag));
                Adapters.ITEM_STACK.writeJson(this.item).ifPresent(tag -> json.add("item", tag));
                Adapters.INT.writeJson(this.color1).ifPresent(tag -> json.add("color1", tag));
                Adapters.INT.writeJson(this.color2).ifPresent(tag -> json.add("color2", tag));
                return json;
            });
        }

        @Override
        public void readJson(JsonObject json) {
            super.readJson(json);
            this.name = Adapters.UTF_8.asNullable().readJson(json.get("name")).orElse(null);
            this.item = Adapters.ITEM_STACK.readJson(json.get("item")).orElseThrow();
            this.color1 = Adapters.INT.readJson(json.get("color1")).orElse(-1);
            this.color2 = Adapters.INT.readJson(json.get("color2")).orElse(-1);
        }
    }
}

