/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity.challenge.raid.action;

import com.google.gson.JsonObject;
import iskallia.vault.block.entity.challenge.ChallengeManager;
import iskallia.vault.block.entity.challenge.raid.RaidChallengeManager;
import iskallia.vault.block.entity.challenge.raid.action.ChallengeAction;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.random.RandomSource;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;

public class ForfeitChallengeAction
extends ChallengeAction<Config> {
    public ForfeitChallengeAction() {
        super(new Config());
    }

    public ForfeitChallengeAction(Config config) {
        super(config);
    }

    @Override
    public boolean onMerge(ChallengeAction<?> action) {
        return action instanceof ForfeitChallengeAction;
    }

    @Override
    public void onActivate(ServerLevel world, ChallengeManager manager, RandomSource random) {
        super.onActivate(world, manager, random);
        if (manager instanceof RaidChallengeManager) {
            RaidChallengeManager raid = (RaidChallengeManager)manager;
            if (((Config)this.getConfig()).loot) {
                raid.setPhase(RaidChallengeManager.Phase.COMPLETED);
            } else {
                raid.setPhase(RaidChallengeManager.Phase.FORFEITED);
            }
        }
    }

    @Override
    public Component getText() {
        if (!((Config)this.getConfig()).loot) {
            return new TextComponent("Forfeit").m_6270_(Style.f_131099_.m_178520_(((Config)this.getConfig()).textColor));
        }
        return new TextComponent("Forfeit & Loot").m_6270_(Style.f_131099_.m_178520_(((Config)this.getConfig()).textColor));
    }

    public static class Config
    extends ChallengeAction.Config {
        private boolean loot;

        @Override
        public void writeBits(BitBuffer buffer) {
            super.writeBits(buffer);
            Adapters.BOOLEAN.writeBits(this.loot, buffer);
        }

        @Override
        public void readBits(BitBuffer buffer) {
            super.readBits(buffer);
            this.loot = Adapters.BOOLEAN.readBits(buffer).orElseThrow();
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            return super.writeNbt().map(nbt -> {
                Adapters.BOOLEAN.writeNbt(this.loot).ifPresent(tag -> nbt.m_128365_("loot", tag));
                return nbt;
            });
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            super.readNbt(nbt);
            this.loot = Adapters.BOOLEAN.readNbt(nbt.m_128423_("loot")).orElse(false);
        }

        @Override
        public Optional<JsonObject> writeJson() {
            return super.writeJson().map(json -> {
                Adapters.BOOLEAN.writeJson(this.loot).ifPresent(tag -> json.add("loot", tag));
                return json;
            });
        }

        @Override
        public void readJson(JsonObject json) {
            super.readJson(json);
            this.loot = Adapters.BOOLEAN.readJson(json.get("loot")).orElse(false);
        }
    }
}

