/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity.challenge.raid.action;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import iskallia.vault.block.entity.challenge.raid.action.ChallengeAction;
import iskallia.vault.block.entity.challenge.raid.action.ReferenceChallengeAction;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.world.roll.IntRoll;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class GroupChallengeAction
extends ChallengeAction<Config> {
    private final List<Integer> rolls = new ArrayList<Integer>();

    protected GroupChallengeAction() {
        super(new Config());
    }

    protected GroupChallengeAction(Config config) {
        super(config);
    }

    @Override
    public boolean onMerge(ChallengeAction<?> action) {
        return false;
    }

    @Override
    public boolean onPopulate(RandomSource random) {
        if (!super.onPopulate(random)) {
            this.rolls.clear();
            ((Config)this.getConfig()).children.forEach((action, roll) -> this.rolls.add(roll.get(random)));
            return false;
        }
        return true;
    }

    @Override
    public Component getText() {
        return new TextComponent("GROUP");
    }

    @Override
    public Stream<ChallengeAction<?>> flatten(RandomSource random, int vaultLevel) {
        ArrayList actions = new ArrayList();
        int index = 0;
        for (ChallengeAction<?> action2 : ((Config)this.getConfig()).children.keySet()) {
            for (int i = 0; i < this.rolls.get(index); ++i) {
                Object copy = action2.copy();
                ((ChallengeAction)copy).onPopulate(random);
                actions.add(copy);
            }
            ++index;
        }
        return actions.stream().flatMap(action -> action.flatten(random, vaultLevel));
    }

    public static class Config
    extends ChallengeAction.Config {
        private final Map<ChallengeAction<?>, IntRoll> children = new LinkedHashMap();

        @Override
        public void writeBits(BitBuffer buffer) {
            super.writeBits(buffer);
            Adapters.INT_SEGMENTED_3.writeBits(this.children.size(), buffer);
            this.children.forEach((action, roll) -> {
                Adapters.CHALLENGE_ACTION.writeBits((ChallengeAction<?>)action, buffer);
                Adapters.INT_ROLL.writeBits(roll, buffer);
            });
        }

        @Override
        public void readBits(BitBuffer buffer) {
            super.readBits(buffer);
            int size = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
            for (int i = 0; i < size; ++i) {
                this.children.put((ChallengeAction)Adapters.CHALLENGE_ACTION.readBits(buffer).orElseThrow(), (IntRoll)Adapters.INT_ROLL.readBits(buffer).orElseThrow());
            }
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            return Optional.of(new CompoundTag()).map(nbt -> {
                ListTag children = new ListTag();
                this.children.forEach((action, roll) -> Adapters.CHALLENGE_ACTION.writeNbt((ChallengeAction<?>)action).ifPresent(tag1 -> {
                    if (tag1 instanceof CompoundTag) {
                        CompoundTag entry = (CompoundTag)tag1;
                        Adapters.INT_ROLL.writeNbt(roll).ifPresent(tag2 -> entry.m_128365_("roll", tag2));
                        children.add((Object)entry);
                    } else {
                        CompoundTag entry = new CompoundTag();
                        entry.m_128365_("value", tag1);
                        Adapters.INT_ROLL.writeNbt(roll).ifPresent(tag2 -> entry.m_128365_("roll", tag2));
                        children.add((Object)entry);
                    }
                }));
                nbt.m_128365_("children", (Tag)children);
                return nbt;
            });
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            super.readNbt(nbt);
            this.children.clear();
            Tag tag = nbt.m_128423_("children");
            if (tag instanceof ListTag) {
                ListTag children = (ListTag)tag;
                for (int i = 0; i < children.size(); ++i) {
                    CompoundTag entry = children.m_128728_(i);
                    if (entry.m_128441_("value") && !entry.m_128441_("type")) {
                        this.children.put((ChallengeAction)Adapters.CHALLENGE_ACTION.readNbt(entry.m_128423_("value")).orElseThrow(), (IntRoll)Adapters.INT_ROLL.readNbt(entry.m_128423_("roll")).orElseThrow());
                        continue;
                    }
                    this.children.put((ChallengeAction)Adapters.CHALLENGE_ACTION.readNbt((Tag)entry).orElseThrow(), (IntRoll)Adapters.INT_ROLL.readNbt(entry.m_128423_("roll")).orElseThrow());
                }
            } else {
                for (String s : nbt.m_128431_()) {
                    if (s.equals("type") || s.equals("weight")) continue;
                    Adapters.INT_ROLL.readNbt(nbt.m_128423_(s)).ifPresent(roll -> this.children.put(new ReferenceChallengeAction(new ReferenceChallengeAction.Config(s)), (IntRoll)roll));
                }
            }
        }

        @Override
        public Optional<JsonObject> writeJson() {
            return super.writeJson().map(json -> {
                JsonArray children = new JsonArray();
                this.children.forEach((action, roll) -> Adapters.CHALLENGE_ACTION.writeJson((ChallengeAction<?>)action).ifPresent(tag1 -> {
                    if (tag1 instanceof JsonObject) {
                        JsonObject entry = (JsonObject)tag1;
                        Adapters.INT_ROLL.writeJson(roll).ifPresent(tag2 -> entry.add("roll", tag2));
                        children.add((JsonElement)entry);
                    } else {
                        JsonObject entry = new JsonObject();
                        entry.add("value", tag1);
                        Adapters.INT_ROLL.writeJson(roll).ifPresent(tag2 -> entry.add("roll", tag2));
                        children.add((JsonElement)entry);
                    }
                }));
                json.add("children", (JsonElement)children);
                return json;
            });
        }

        @Override
        public void readJson(JsonObject json) {
            super.readJson(json);
            this.children.clear();
            JsonElement jsonElement = json.get("children");
            if (jsonElement instanceof JsonArray) {
                JsonArray children = (JsonArray)jsonElement;
                for (int i = 0; i < children.size(); ++i) {
                    JsonObject entry = children.get(i).getAsJsonObject();
                    if (entry.has("value") && !entry.has("type")) {
                        this.children.put((ChallengeAction)Adapters.CHALLENGE_ACTION.readJson(entry.get("value")).orElseThrow(), (IntRoll)Adapters.INT_ROLL.readJson(entry.get("roll")).orElseThrow());
                        continue;
                    }
                    this.children.put((ChallengeAction)Adapters.CHALLENGE_ACTION.readJson((JsonElement)entry).orElseThrow(), (IntRoll)Adapters.INT_ROLL.readJson(entry.get("roll")).orElseThrow());
                }
            } else {
                for (String s : json.keySet()) {
                    if (s.equals("type") || s.equals("weight")) continue;
                    Adapters.INT_ROLL.readJson(json.get(s)).ifPresent(roll -> this.children.put(new ReferenceChallengeAction(new ReferenceChallengeAction.Config(s)), (IntRoll)roll));
                }
            }
        }
    }
}

