/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity.challenge.raid.action;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.Expose;
import iskallia.vault.block.entity.challenge.raid.action.ChallengeAction;
import iskallia.vault.config.entry.LevelEntryList;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.array.ArrayAdapter;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.util.WeightedList;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class PoolChallengeAction
extends ChallengeAction<Config> {
    protected PoolChallengeAction() {
        super(new Config());
    }

    protected PoolChallengeAction(Config config) {
        super(config);
    }

    @Override
    public boolean onMerge(ChallengeAction<?> action) {
        return false;
    }

    @Override
    public Component getText() {
        return new TextComponent("POOL");
    }

    @Override
    public Stream<ChallengeAction<?>> flatten(RandomSource random, int vaultLevel) {
        Config.LevelPool pool = ((Config)this.getConfig()).pools.getForLevel(vaultLevel).orElse(null);
        if (pool == null || pool.pool.isEmpty()) {
            return Stream.empty();
        }
        return pool.pool.getRandom().map(action -> {
            action = action.copy();
            action.onPopulate(random);
            return action.flatten(random, vaultLevel);
        }).orElseGet(Stream::empty);
    }

    public static class Config
    extends ChallengeAction.Config {
        public static final ArrayAdapter<ChallengeAction<?>> CHILDREN = Adapters.ofArray(ChallengeAction[]::new, Adapters.CHALLENGE_ACTION);
        private final LevelEntryList<LevelPool> pools = new LevelEntryList();

        @Override
        public void writeBits(BitBuffer buffer) {
            super.writeBits(buffer);
            Adapters.INT_SEGMENTED_3.writeBits(this.pools.size(), buffer);
            this.pools.forEach(level -> {
                Adapters.INT.writeBits(level.level, buffer);
                Adapters.INT_SEGMENTED_3.writeBits(level.pool.size(), buffer);
                level.pool.forEach((action, weight) -> {
                    Adapters.CHALLENGE_ACTION.writeBits((ChallengeAction<?>)action, buffer);
                    Adapters.DOUBLE.writeBits(weight, buffer);
                });
            });
        }

        @Override
        public void readBits(BitBuffer buffer) {
            super.readBits(buffer);
            int size = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
            this.pools.clear();
            for (int i = 0; i < size; ++i) {
                LevelPool level = new LevelPool();
                level.level = Adapters.INT.readBits(buffer).orElse(0);
                int pSize = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
                for (int j = 0; j < pSize; ++j) {
                    level.pool.add((ChallengeAction)Adapters.CHALLENGE_ACTION.readBits(buffer).orElseThrow(), (Double)Adapters.DOUBLE.readBits(buffer).orElseThrow());
                }
                this.pools.add(level);
            }
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            return Optional.of(new CompoundTag()).map(nbt -> {
                ListTag list = new ListTag();
                this.pools.forEach(level -> {
                    CompoundTag entry = new CompoundTag();
                    Adapters.INT.writeNbt(level.level).ifPresent(t -> entry.m_128365_("level", t));
                    ListTag pool = new ListTag();
                    level.pool.forEach((action, weight) -> Adapters.CHALLENGE_ACTION.writeNbt((ChallengeAction<?>)action).map(tag -> {
                        if (tag instanceof CompoundTag) {
                            CompoundTag compound = (CompoundTag)tag;
                            Adapters.DOUBLE.writeNbt(weight).ifPresent(w -> compound.m_128365_("weight", w));
                            return compound;
                        }
                        CompoundTag inner = new CompoundTag();
                        inner.m_128365_("value", tag);
                        Adapters.DOUBLE.writeNbt(weight).ifPresent(w -> inner.m_128365_("weight", w));
                        return inner;
                    }).ifPresent(arg_0 -> pool.add(arg_0)));
                    entry.m_128365_("pool", (Tag)pool);
                    list.add((Object)entry);
                });
                nbt.m_128365_("levels", (Tag)list);
                return nbt;
            });
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            super.readNbt(nbt);
            this.pools.clear();
            Tag tag = nbt.m_128423_("levels");
            if (tag instanceof ListTag) {
                ListTag levels = (ListTag)tag;
                for (int i = 0; i < levels.size(); ++i) {
                    CompoundTag entry = levels.m_128728_(i);
                    LevelPool level = new LevelPool();
                    level.level = Adapters.INT.readNbt(entry.m_128423_("level")).orElse(0);
                    Tag tag2 = entry.m_128423_("pool");
                    if (tag2 instanceof ListTag) {
                        ListTag pool = (ListTag)tag2;
                        for (int j = 0; j < pool.size(); ++j) {
                            CompoundTag a = pool.m_128728_(j);
                            if (!a.m_128441_("type") && a.m_128441_("value") && a.m_128441_("weight")) {
                                level.pool.put((ChallengeAction)Adapters.CHALLENGE_ACTION.readNbt(a.m_128423_("value")).orElseThrow(), (Double)Adapters.DOUBLE.readNbt(a.m_128423_("weight")).orElseThrow());
                                continue;
                            }
                            level.pool.put((ChallengeAction)Adapters.CHALLENGE_ACTION.readNbt((Tag)a).orElseThrow(), (Double)Adapters.DOUBLE.readNbt(a.m_128423_("weight")).orElseThrow());
                        }
                    }
                    this.pools.add(level);
                }
            } else {
                Tag i = nbt.m_128423_("pool");
                if (i instanceof ListTag) {
                    ListTag list = (ListTag)i;
                    LevelPool level = new LevelPool();
                    for (int i2 = 0; i2 < list.size(); ++i2) {
                        CompoundTag entry = list.m_128728_(i2);
                        if (!entry.m_128441_("type") && entry.m_128441_("value") && entry.m_128441_("weight")) {
                            level.pool.put((ChallengeAction)Adapters.CHALLENGE_ACTION.readNbt(entry.m_128423_("value")).orElseThrow(), (Double)Adapters.DOUBLE.readNbt(entry.m_128423_("weight")).orElseThrow());
                            continue;
                        }
                        level.pool.put((ChallengeAction)Adapters.CHALLENGE_ACTION.readNbt((Tag)entry).orElseThrow(), (Double)Adapters.DOUBLE.readNbt(entry.m_128423_("weight")).orElseThrow());
                    }
                    this.pools.add(level);
                }
            }
        }

        @Override
        public Optional<JsonObject> writeJson() {
            return Optional.of(new JsonObject()).map(json -> {
                JsonArray levels = new JsonArray();
                this.pools.forEach(lvl -> {
                    JsonObject obj = new JsonObject();
                    Adapters.INT.writeJson(lvl.level).ifPresent(t -> obj.add("level", t));
                    JsonArray pool = new JsonArray();
                    lvl.pool.forEach((action, weight) -> Adapters.CHALLENGE_ACTION.writeJson((ChallengeAction<?>)action).map(tag -> {
                        if (tag instanceof JsonObject) {
                            JsonObject object = (JsonObject)tag;
                            Adapters.DOUBLE.writeJson(weight).ifPresent(w -> object.add("weight", w));
                            return object;
                        }
                        JsonObject e = new JsonObject();
                        e.add("value", tag);
                        Adapters.DOUBLE.writeJson(weight).ifPresent(w -> e.add("weight", w));
                        return e;
                    }).ifPresent(arg_0 -> ((JsonArray)pool).add(arg_0)));
                    obj.add("pool", (JsonElement)pool);
                    levels.add((JsonElement)obj);
                });
                json.add("levels", (JsonElement)levels);
                return json;
            });
        }

        @Override
        public void readJson(JsonObject json) {
            super.readJson(json);
            this.pools.clear();
            JsonElement jsonElement = json.get("levels");
            if (jsonElement instanceof JsonArray) {
                JsonArray levels = (JsonArray)jsonElement;
                for (int i = 0; i < levels.size(); ++i) {
                    JsonObject obj = levels.get(i).getAsJsonObject();
                    LevelPool level = new LevelPool();
                    level.level = Adapters.INT.readJson(obj.get("level")).orElse(0);
                    JsonElement jsonElement2 = obj.get("pool");
                    if (jsonElement2 instanceof JsonArray) {
                        JsonArray pool = (JsonArray)jsonElement2;
                        for (int j = 0; j < pool.size(); ++j) {
                            JsonObject entry = pool.get(j).getAsJsonObject();
                            if (!entry.has("type") && entry.has("value") && entry.has("weight")) {
                                level.pool.put((ChallengeAction)Adapters.CHALLENGE_ACTION.readJson(entry.get("value")).orElseThrow(), (Double)Adapters.DOUBLE.readJson(entry.get("weight")).orElseThrow());
                                continue;
                            }
                            level.pool.put((ChallengeAction)Adapters.CHALLENGE_ACTION.readJson((JsonElement)entry).orElseThrow(), (Double)Adapters.DOUBLE.readJson(entry.get("weight")).orElseThrow());
                        }
                    }
                    this.pools.add(level);
                }
            } else {
                JsonElement i = json.get("pool");
                if (i instanceof JsonArray) {
                    JsonArray list = (JsonArray)i;
                    LevelPool level = new LevelPool();
                    for (int i2 = 0; i2 < list.size(); ++i2) {
                        JsonObject entry = list.get(i2).getAsJsonObject();
                        if (!entry.has("type") && entry.has("value") && entry.has("weight")) {
                            level.pool.put((ChallengeAction)Adapters.CHALLENGE_ACTION.readJson(entry.get("value")).orElseThrow(), (Double)Adapters.DOUBLE.readJson(entry.get("weight")).orElseThrow());
                            continue;
                        }
                        level.pool.put((ChallengeAction)Adapters.CHALLENGE_ACTION.readJson((JsonElement)entry).orElseThrow(), (Double)Adapters.DOUBLE.readJson(entry.get("weight")).orElseThrow());
                    }
                    this.pools.add(level);
                }
            }
        }

        public Optional<ChallengeAction<?>> getRandom(int level, RandomSource random) {
            return this.pools.getForLevel(level).flatMap(lvl -> lvl.pool.getRandom(random));
        }

        private static class LevelPool
        implements LevelEntryList.ILevelEntry {
            @Expose
            int level;
            @Expose
            WeightedList<ChallengeAction<?>> pool = new WeightedList();

            private LevelPool() {
            }

            @Override
            public int getLevel() {
                return this.level;
            }
        }
    }
}

