/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity.challenge.raid.action;

import com.google.gson.JsonObject;
import iskallia.vault.block.entity.challenge.ChallengeManager;
import iskallia.vault.block.entity.challenge.elite.EliteChallengeManager;
import iskallia.vault.block.entity.challenge.raid.RaidChallengeManager;
import iskallia.vault.block.entity.challenge.raid.action.ChallengeAction;
import iskallia.vault.block.entity.challenge.xmark.XMarkChallengeManager;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.random.ChunkRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.util.RegionPos;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.vault.modifier.modifier.NoLootModifier;
import iskallia.vault.core.world.data.tile.PartialTile;
import iskallia.vault.core.world.generator.GridGenerator;
import iskallia.vault.core.world.generator.VaultGenerator;
import iskallia.vault.core.world.processor.ProcessorContext;
import iskallia.vault.core.world.processor.tile.MirrorTileProcessor;
import iskallia.vault.core.world.processor.tile.RotateTileProcessor;
import iskallia.vault.core.world.processor.tile.TranslateTileProcessor;
import iskallia.vault.core.world.storage.BlockCuboid;
import iskallia.vault.core.world.storage.IZonedWorld;
import iskallia.vault.core.world.template.DynamicTemplate;
import iskallia.vault.core.world.template.JigsawTemplate;
import iskallia.vault.core.world.template.PlacementSettings;
import iskallia.vault.world.data.ServerVaults;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class TileRewardChallengeAction
extends ChallengeAction<Config> {
    public TileRewardChallengeAction() {
        super(new Config());
    }

    public TileRewardChallengeAction(Config config) {
        super(config);
    }

    @Override
    public boolean onMerge(ChallengeAction<?> action) {
        if (action instanceof TileRewardChallengeAction) {
            TileRewardChallengeAction other = (TileRewardChallengeAction)action;
            PartialTile a = ((Config)this.getConfig()).tile;
            PartialTile b = ((Config)other.getConfig()).tile;
            if (a.isSubsetOf(b) && b.isSubsetOf(a)) {
                ((Config)this.getConfig()).count += ((Config)other.getConfig()).count;
                return true;
            }
        }
        return false;
    }

    @Override
    public void onActivate(ServerLevel world, ChallengeManager manager, RandomSource random) {
        BlockCuboid zone;
        Vault theVault = ServerVaults.get((Level)world).orElse(null);
        if (theVault == null) {
            return;
        }
        if (theVault.get(Vault.MODIFIERS).getModifiers().stream().anyMatch(modifier -> modifier instanceof NoLootModifier)) {
            return;
        }
        super.onActivate(world, manager, random);
        if (manager instanceof RaidChallengeManager) {
            RaidChallengeManager raid = (RaidChallengeManager)manager;
            zone = raid.getZone().offset((Vec3i)manager.pos);
            zone = BlockCuboid.of(zone.getMinX(), zone.getMinY(), zone.getMinZ(), zone.getMaxX(), zone.getMaxY() - 30, zone.getMaxZ());
        } else if (manager instanceof XMarkChallengeManager) {
            XMarkChallengeManager xmark = (XMarkChallengeManager)manager;
            zone = xmark.getZone().offset((Vec3i)manager.pos);
            zone = BlockCuboid.of(zone.getMinX(), zone.getMinY(), zone.getMinZ(), zone.getMaxX(), zone.getMaxY() - 35, zone.getMaxZ());
        } else if (manager instanceof EliteChallengeManager) {
            EliteChallengeManager elite = (EliteChallengeManager)manager;
            zone = elite.getZone();
            zone = BlockCuboid.of(zone.getMinX() + 10, zone.getMinY() + 10, zone.getMinZ() + 10, zone.getMaxX() - 10, zone.getMaxY() - 10, zone.getMaxZ() - 10);
        } else {
            return;
        }
        block0: for (int j = 0; j < ((Config)this.getConfig()).count; ++j) {
            for (int i = 0; i < 200; ++i) {
                int z;
                int y;
                int x = random.nextInt(zone.getMaxX() - zone.getMinX() + 1) + zone.getMinX();
                BlockPos pos = new BlockPos(x, y = random.nextInt(zone.getMaxY() - zone.getMinY() + 1) + zone.getMinY(), z = random.nextInt(zone.getMaxZ() - zone.getMinZ() + 1) + zone.getMinZ());
                if (!world.m_8055_(pos).m_60795_() || !world.m_8055_(pos.m_7494_()).m_60795_() || !world.m_8055_(pos.m_7495_()).m_60838_((BlockGetter)world, pos)) continue;
                DynamicTemplate template = new DynamicTemplate();
                template.add(((Config)this.getConfig()).tile.copy().setPos(pos));
                PlacementSettings settings = new PlacementSettings(new ProcessorContext(null, random)).setFlags(3);
                ServerVaults.get((Level)world).ifPresent(vault -> {
                    VaultGenerator patt5143$temp = vault.get(Vault.WORLD).get(WorldManager.GENERATOR);
                    if (!(patt5143$temp instanceof GridGenerator)) {
                        return;
                    }
                    GridGenerator gen = (GridGenerator)patt5143$temp;
                    RegionPos region = RegionPos.ofBlockPos(pos, gen.get(GridGenerator.CELL_X), gen.get(GridGenerator.CELL_Z));
                    ChunkRandom chunkRandom = ChunkRandom.any();
                    chunkRandom.setRegionSeed(vault.get(Vault.SEED), region.m_123341_(), region.m_123343_(), 1234567890L);
                    JigsawTemplate room = (JigsawTemplate)gen.get(GridGenerator.LAYOUT).getAt((Vault)vault, region, chunkRandom, settings);
                    room.getConfigurator().accept(settings);
                    settings.getTileProcessors().removeIf(processor -> processor instanceof TranslateTileProcessor);
                    settings.getTileProcessors().removeIf(processor -> processor instanceof MirrorTileProcessor);
                    settings.getTileProcessors().removeIf(processor -> processor instanceof RotateTileProcessor);
                });
                IZonedWorld.runWithBypass(world, true, () -> template.place((ServerLevelAccessor)world, settings));
                continue block0;
            }
        }
    }

    @Override
    public Component getText() {
        Component name = ((Config)this.getConfig()).tile.getState().getBlock().asWhole().map(block -> new ItemStack((ItemLike)block).m_41786_()).orElse(ItemStack.f_41583_.m_41786_());
        return new TextComponent("+" + ((Config)this.getConfig()).count).m_7220_((Component)new TextComponent(" ")).m_7220_((Component)(((Config)this.getConfig()).name == null ? name : new TextComponent(((Config)this.getConfig()).name))).m_6270_(Style.f_131099_.m_178520_(((Config)this.getConfig()).textColor));
    }

    public static class Config
    extends ChallengeAction.Config {
        private String name;
        private PartialTile tile;
        private int count;

        @Override
        public void writeBits(BitBuffer buffer) {
            super.writeBits(buffer);
            Adapters.UTF_8.asNullable().writeBits(this.name, buffer);
            Adapters.PARTIAL_TILE.writeBits(this.tile, buffer);
            Adapters.INT_SEGMENTED_3.writeBits(this.count, buffer);
        }

        @Override
        public void readBits(BitBuffer buffer) {
            super.readBits(buffer);
            this.name = Adapters.UTF_8.asNullable().readBits(buffer).orElse(null);
            this.tile = Adapters.PARTIAL_TILE.readBits(buffer).orElseThrow();
            this.count = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            return super.writeNbt().map(nbt -> {
                Adapters.UTF_8.writeNbt(this.name).ifPresent(tag -> nbt.m_128365_("name", tag));
                Adapters.PARTIAL_TILE.writeNbt(this.tile).ifPresent(tag -> nbt.m_128365_("tile", tag));
                Adapters.INT.writeNbt(this.count).ifPresent(tag -> nbt.m_128365_("count", tag));
                return nbt;
            });
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            super.readNbt(nbt);
            this.name = Adapters.UTF_8.readNbt(nbt.m_128423_("name")).orElse(null);
            this.tile = Adapters.PARTIAL_TILE.readNbt(nbt.m_128423_("tile")).orElseThrow();
            this.count = Adapters.INT.readNbt(nbt.m_128423_("count")).orElse(1);
        }

        @Override
        public Optional<JsonObject> writeJson() {
            return super.writeJson().map(json -> {
                Adapters.UTF_8.writeJson(this.name).ifPresent(tag -> json.add("name", tag));
                Adapters.PARTIAL_TILE.writeJson(this.tile).ifPresent(tag -> json.add("tile", tag));
                Adapters.INT.writeJson(this.count).ifPresent(tag -> json.add("count", tag));
                return json;
            });
        }

        @Override
        public void readJson(JsonObject json) {
            super.readJson(json);
            this.name = Adapters.UTF_8.readJson(json.get("name")).orElse(null);
            this.tile = Adapters.PARTIAL_TILE.readJson(json.get("tile")).orElseThrow();
            this.count = Adapters.INT.readJson(json.get("count")).orElse(1);
        }
    }
}

