/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity.challenge.raid.action;

import com.google.gson.JsonObject;
import iskallia.vault.block.entity.challenge.raid.action.ChallengeAction;
import iskallia.vault.block.entity.challenge.raid.action.MobVanillaAttributeChallengeAction;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.array.ArrayAdapter;
import iskallia.vault.core.data.adapter.basic.EnumAdapter;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.world.data.entity.EntityPredicate;
import iskallia.vault.core.world.roll.DoubleRoll;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public abstract class VanillaAttributeChallengeAction
extends ChallengeAction<Config> {
    protected UUID uuid;
    protected double amount;

    public VanillaAttributeChallengeAction() {
        super(new Config());
    }

    public VanillaAttributeChallengeAction(Config config) {
        super(config);
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public double getAmount() {
        return this.amount;
    }

    public Attribute getAttribute() {
        return ((Config)this.getConfig()).attribute;
    }

    public AttributeModifier.Operation getOperation() {
        return ((Config)this.getConfig()).operation;
    }

    @Override
    public boolean onPopulate(RandomSource random) {
        if (!super.onPopulate(random)) {
            this.uuid = Mth.m_14002_();
            this.amount = 0.0;
            for (DoubleRoll roll : ((Config)this.getConfig()).amount) {
                double value = roll.get(random);
                switch (this.getOperation()) {
                    case ADDITION: 
                    case MULTIPLY_BASE: {
                        this.amount += value;
                        break;
                    }
                    case MULTIPLY_TOTAL: {
                        this.amount = 1.0 - (1.0 + this.amount) * (1.0 + value);
                    }
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean onMerge(ChallengeAction<?> action) {
        if (action instanceof VanillaAttributeChallengeAction) {
            VanillaAttributeChallengeAction other = (VanillaAttributeChallengeAction)action;
            if (this.getAttribute() == other.getAttribute() && this.getOperation() == other.getOperation()) {
                ((Config)this.getConfig()).amount.addAll(((Config)other.getConfig()).amount);
                switch (this.getOperation()) {
                    case ADDITION: 
                    case MULTIPLY_BASE: {
                        this.amount += other.getAmount();
                        break;
                    }
                    case MULTIPLY_TOTAL: {
                        this.amount = 1.0 - (1.0 + this.amount) * (1.0 + other.getAmount());
                    }
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Component getText() {
        TextComponent prefix = new TextComponent((String)(switch (this.getOperation()) {
            default -> throw new IncompatibleClassChangeError();
            case AttributeModifier.Operation.ADDITION -> String.format("%+.0f", this.amount);
            case AttributeModifier.Operation.MULTIPLY_BASE -> String.format("%+.0f%%", this.amount * 100.0);
            case AttributeModifier.Operation.MULTIPLY_TOTAL -> "\u00d7" + (1.0 + this.amount);
        }));
        MutableComponent text = new TextComponent("").m_7220_((Component)prefix);
        if (((Config)this.getConfig()).name == null) {
            TranslatableComponent suffix = new TranslatableComponent(this.getAttribute().m_22087_());
            text = text.m_130946_(this instanceof MobVanillaAttributeChallengeAction ? " Mob " : " Player ").m_7220_((Component)suffix);
        } else {
            text = text.m_130946_(" ").m_7220_((Component)new TextComponent(((Config)this.getConfig()).name));
        }
        return text.m_6270_(Style.f_131099_.m_178520_(((Config)this.getConfig()).textColor));
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        if (!this.isPopulated()) {
            return;
        }
        Adapters.UUID.writeBits(this.uuid, buffer);
        Adapters.DOUBLE.writeBits(this.amount, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        if (!this.isPopulated()) {
            return;
        }
        this.uuid = Adapters.UUID.readBits(buffer).orElseThrow();
        this.amount = (Double)Adapters.DOUBLE.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            if (!this.isPopulated()) {
                return nbt;
            }
            Adapters.UUID.writeNbt(this.uuid).ifPresent(tag -> nbt.m_128365_("uuid", tag));
            Adapters.DOUBLE.writeNbt(this.amount).ifPresent(tag -> nbt.m_128365_("amount", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        if (!this.isPopulated()) {
            return;
        }
        this.uuid = Adapters.UUID.readNbt(nbt.m_128423_("uuid")).orElseThrow();
        this.amount = (Double)Adapters.DOUBLE.readNbt(nbt.m_128423_("amount")).orElseThrow();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            if (!this.isPopulated()) {
                return json;
            }
            Adapters.UUID.writeJson(this.uuid).ifPresent(tag -> json.add("uuid", tag));
            Adapters.DOUBLE.writeJson(this.amount).ifPresent(tag -> json.add("amount", tag));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        if (!this.isPopulated()) {
            return;
        }
        this.uuid = Adapters.UUID.readJson(json.get("uuid")).orElseThrow();
        this.amount = (Double)Adapters.DOUBLE.readJson(json.get("amount")).orElseThrow();
    }

    public static class Config
    extends ChallengeAction.Config {
        private String name;
        protected EntityPredicate filter;
        protected Attribute attribute;
        protected AttributeModifier.Operation operation;
        protected List<DoubleRoll> amount;
        protected static final EnumAdapter<AttributeModifier.Operation> OPERATION_ORDINAL = Adapters.ofEnum(AttributeModifier.Operation.class, EnumAdapter.Mode.ORDINAL);
        protected static final EnumAdapter<AttributeModifier.Operation> OPERATION_NAME = Adapters.ofEnum(AttributeModifier.Operation.class, EnumAdapter.Mode.NAME);
        protected static final ArrayAdapter<DoubleRoll> AMOUNT = Adapters.ofArray(DoubleRoll[]::new, Adapters.DOUBLE_ROLL);

        public Config() {
            this.amount = new ArrayList<DoubleRoll>();
        }

        public Config(String name, EntityPredicate filter, Attribute attribute, AttributeModifier.Operation operation, DoubleRoll ... amount) {
            this.name = name;
            this.filter = filter;
            this.attribute = attribute;
            this.operation = operation;
            this.amount = new ArrayList<DoubleRoll>(Arrays.asList(amount));
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            super.writeBits(buffer);
            Adapters.ENTITY_PREDICATE.writeBits(this.filter, buffer);
            Adapters.ATTRIBUTE.writeBits(this.attribute, buffer);
            OPERATION_ORDINAL.writeBits(this.operation, buffer);
            AMOUNT.writeBits((DoubleRoll)((DoubleRoll[])this.amount.toArray(DoubleRoll[]::new)), buffer);
        }

        @Override
        public void readBits(BitBuffer buffer) {
            super.readBits(buffer);
            this.filter = Adapters.ENTITY_PREDICATE.readBits(buffer).orElse(null);
            this.attribute = Adapters.ATTRIBUTE.readBits(buffer).orElseThrow();
            this.operation = OPERATION_ORDINAL.readBits(buffer).orElseThrow();
            this.amount = Arrays.stream((DoubleRoll[])AMOUNT.readBits(buffer).orElseThrow()).collect(Collectors.toList());
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            return super.writeNbt().map(nbt -> {
                Adapters.ENTITY_PREDICATE.writeNbt(this.filter).ifPresent(tag -> nbt.m_128365_("filter", tag));
                Adapters.ATTRIBUTE.writeNbt(this.attribute).ifPresent(tag -> nbt.m_128365_("attribute", tag));
                OPERATION_NAME.writeNbt(this.operation).ifPresent(tag -> nbt.m_128365_("operation", tag));
                AMOUNT.writeNbt((DoubleRoll)((DoubleRoll[])this.amount.toArray(DoubleRoll[]::new))).ifPresent(tag -> nbt.m_128365_("amount", tag));
                return nbt;
            });
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            super.readNbt(nbt);
            this.filter = Adapters.ENTITY_PREDICATE.readNbt(nbt.m_128423_("filter")).orElse(null);
            this.attribute = Adapters.ATTRIBUTE.readNbt(nbt.m_128423_("attribute")).orElseThrow(() -> new IllegalStateException("Unknown attribute in " + String.valueOf(nbt)));
            this.operation = OPERATION_NAME.readNbt(nbt.m_128423_("operation")).orElseThrow();
            this.amount = Arrays.stream((DoubleRoll[])AMOUNT.readNbt(nbt.m_128423_("amount")).orElseThrow()).collect(Collectors.toList());
        }

        @Override
        public Optional<JsonObject> writeJson() {
            return super.writeJson().map(json -> {
                Adapters.ENTITY_PREDICATE.writeJson(this.filter).ifPresent(tag -> json.add("filter", tag));
                Adapters.ATTRIBUTE.writeJson(this.attribute).ifPresent(element -> json.add("attribute", element));
                OPERATION_NAME.writeJson(this.operation).ifPresent(element -> json.add("operation", element));
                AMOUNT.writeJson((DoubleRoll)((DoubleRoll[])this.amount.toArray(DoubleRoll[]::new))).ifPresent(tag -> json.add("amount", tag));
                return json;
            });
        }

        @Override
        public void readJson(JsonObject json) {
            super.readJson(json);
            this.filter = Adapters.ENTITY_PREDICATE.readJson(json.get("filter")).orElse(null);
            this.attribute = Adapters.ATTRIBUTE.readJson(json.get("attribute")).orElseThrow(() -> new IllegalStateException("Unknown attribute in " + String.valueOf(json)));
            this.operation = OPERATION_NAME.readJson(json.get("operation")).orElseThrow();
            this.amount = Arrays.stream((DoubleRoll[])AMOUNT.readJson(json.get("amount")).orElseThrow()).collect(Collectors.toList());
        }
    }
}

